/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportAddressSerializers {
    private static final Map<Short, CheckedBiFunction<StreamInput, String, TransportAddress>> ADDRESS_REGISTRY;

    private static void addAddressType(Map<Short, CheckedBiFunction<StreamInput, String, TransportAddress>> registry, short uniqueAddressTypeId, CheckedBiFunction<StreamInput, String, TransportAddress> address) {
        if (registry.containsKey(uniqueAddressTypeId)) {
            throw new IllegalStateException("Address [" + uniqueAddressTypeId + "] already bound");
        }
        registry.put(uniqueAddressTypeId, address);
    }

    public static TransportAddress addressFromStream(StreamInput input) throws IOException {
        return TransportAddressSerializers.addressFromStream(input, null);
    }

    public static TransportAddress addressFromStream(StreamInput input, String hostString) throws IOException {
        short addressUniqueId = input.readShort();
        CheckedBiFunction<StreamInput, String, TransportAddress> addressType = ADDRESS_REGISTRY.get(addressUniqueId);
        if (addressType == null) {
            throw new IOException("No transport address mapped to [" + addressUniqueId + "]");
        }
        return addressType.apply(input, hostString);
    }

    public static void addressToStream(StreamOutput out, TransportAddress address) throws IOException {
        out.writeShort(address.uniqueAddressTypeId());
        address.writeTo(out);
    }

    static {
        HashMap<Short, CheckedBiFunction<StreamInput, String, TransportAddress>> registry = new HashMap<Short, CheckedBiFunction<StreamInput, String, TransportAddress>>();
        TransportAddressSerializers.addAddressType(registry, (short)1, InetSocketTransportAddress::new);
        TransportAddressSerializers.addAddressType(registry, (short)2, LocalTransportAddress::new);
        ADDRESS_REGISTRY = Collections.unmodifiableMap(registry);
    }

    @FunctionalInterface
    static interface CheckedBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws IOException;
    }
}

