/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.XToParentBlockJoinQuery;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;

public final class ESToParentBlockJoinQuery
extends Query {
    private final XToParentBlockJoinQuery query;
    private final String path;

    public ESToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode, String path) {
        this(new XToParentBlockJoinQuery(childQuery, parentsFilter, scoreMode), path);
    }

    private ESToParentBlockJoinQuery(XToParentBlockJoinQuery query, String path) {
        this.query = query;
        this.path = path;
    }

    public Query getChildQuery() {
        return this.query.getChildQuery();
    }

    public String getPath() {
        return this.path;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query innerRewrite = this.query.rewrite(reader);
        if (innerRewrite != this.query) {
            if (innerRewrite instanceof XToParentBlockJoinQuery) {
                return new ESToParentBlockJoinQuery((XToParentBlockJoinQuery)innerRewrite, this.path);
            }
            return innerRewrite;
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return this.query.createWeight(searcher, needsScores);
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ESToParentBlockJoinQuery that = (ESToParentBlockJoinQuery)((Object)obj);
        return this.query.equals((Object)that.query) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{((Object)((Object)this)).getClass(), this.query, this.path});
    }

    public String toString(String field) {
        return this.query.toString(field);
    }
}

