/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Objects;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Utility;

public final class AnalyzerCaster {
    /*
     * Enabled aggressive block sorting
     */
    public static Definition.Cast getLegalCast(Location location, Definition.Type actual, Definition.Type expected, boolean explicit, boolean internal) {
        Objects.requireNonNull(actual);
        Objects.requireNonNull(expected);
        if (actual.equals(expected)) {
            return null;
        }
        block0 : switch (actual.sort) {
            case BOOL: {
                switch (expected.sort) {
                    case DEF: {
                        return new Definition.Cast(Definition.BOOLEAN_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.BOOLEAN_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.BOOLEAN_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.BOOLEAN_TYPE, null);
                        }
                        break block0;
                    }
                    case BOOL_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BOOLEAN_TYPE, Definition.BOOLEAN_TYPE, explicit, null, null, null, Definition.BOOLEAN_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BYTE: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(Definition.BYTE_TYPE, expected, explicit);
                    }
                    case CHAR: {
                        if (explicit) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.CHAR_TYPE, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.BYTE_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.BYTE_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.BYTE_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.BYTE_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.BYTE_TYPE, null);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.BYTE_TYPE, explicit, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.SHORT_TYPE, explicit, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.INT_TYPE, explicit, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.LONG_TYPE, explicit, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case SHORT: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(Definition.SHORT_TYPE, expected, explicit);
                    }
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(Definition.SHORT_TYPE, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.SHORT_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.SHORT_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.SHORT_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.SHORT_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.SHORT_TYPE, null);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.SHORT_TYPE, explicit, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.INT_TYPE, explicit, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.LONG_TYPE, explicit, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case CHAR: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(Definition.CHAR_TYPE, expected, explicit);
                    }
                    case SHORT: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.CHAR_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.CHAR_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.CHAR_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.CHAR_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.CHAR_TYPE, null);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.CHAR_TYPE, explicit, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                    case STRING: {
                        return new Definition.Cast(Definition.CHAR_TYPE, Definition.STRING_TYPE, explicit);
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.INT_TYPE, explicit, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.LONG_TYPE, explicit, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, Definition.SHORT_TYPE, true, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case INT: {
                switch (expected.sort) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(Definition.INT_TYPE, expected, explicit);
                    }
                    case SHORT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(Definition.INT_TYPE, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.INT_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.INT_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.INT_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.INT_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.INT_TYPE, null);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.INT_TYPE, explicit, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.LONG_TYPE, explicit, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.SHORT_TYPE, true, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.INT_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case LONG: {
                switch (expected.sort) {
                    case FLOAT: 
                    case DOUBLE: {
                        return new Definition.Cast(Definition.LONG_TYPE, expected, explicit);
                    }
                    case SHORT: 
                    case INT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.LONG_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.LONG_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, actual, explicit, null, null, Definition.LONG_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.LONG_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.LONG_TYPE, null);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.LONG_TYPE, explicit, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.SHORT_TYPE, true, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, Definition.INT_TYPE, true, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case FLOAT: {
                switch (expected.sort) {
                    case DOUBLE: {
                        return new Definition.Cast(actual, expected, explicit);
                    }
                    case SHORT: 
                    case INT: 
                    case FLOAT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(actual, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.FLOAT_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.FLOAT_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.FLOAT_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.FLOAT_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.FLOAT_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.FLOAT_TYPE, null);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.FLOAT_TYPE, explicit, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.SHORT_TYPE, true, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.INT_TYPE, true, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, Definition.LONG_TYPE, true, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case FLOAT: 
                    case CHAR: 
                    case BYTE: {
                        if (explicit) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, expected, true);
                        }
                        break block0;
                    }
                    case DEF: {
                        return new Definition.Cast(Definition.DOUBLE_OBJ_TYPE, Definition.DEF_TYPE, explicit, null, null, Definition.DOUBLE_TYPE, null);
                    }
                    case OBJECT: {
                        if (Definition.OBJECT_TYPE.equals(expected) && internal) {
                            return new Definition.Cast(Definition.DOUBLE_OBJ_TYPE, Definition.OBJECT_TYPE, explicit, null, null, Definition.DOUBLE_TYPE, null);
                        }
                        break block0;
                    }
                    case NUMBER: {
                        if (internal) {
                            return new Definition.Cast(Definition.DOUBLE_OBJ_TYPE, Definition.NUMBER_TYPE, explicit, null, null, Definition.DOUBLE_TYPE, null);
                        }
                        break block0;
                    }
                    case DOUBLE_OBJ: {
                        if (internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.DOUBLE_TYPE, explicit, null, null, null, Definition.DOUBLE_TYPE);
                        }
                        break block0;
                    }
                    case BYTE_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.BYTE_TYPE, true, null, null, null, Definition.BYTE_TYPE);
                        }
                        break block0;
                    }
                    case SHORT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.SHORT_TYPE, true, null, null, null, Definition.SHORT_TYPE);
                        }
                        break block0;
                    }
                    case CHAR_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.CHAR_TYPE, true, null, null, null, Definition.CHAR_TYPE);
                        }
                        break block0;
                    }
                    case INT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.INT_TYPE, true, null, null, null, Definition.INT_TYPE);
                        }
                        break block0;
                    }
                    case LONG_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.LONG_TYPE, true, null, null, null, Definition.LONG_TYPE);
                        }
                        break block0;
                    }
                    case FLOAT_OBJ: {
                        if (explicit && internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, Definition.FLOAT_TYPE, true, null, null, null, Definition.FLOAT_TYPE);
                        }
                        break block0;
                    }
                }
                break;
            }
            case OBJECT: {
                if (!Definition.OBJECT_TYPE.equals(actual)) break;
                switch (expected.sort) {
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.BYTE_OBJ_TYPE, true, null, Definition.BYTE_TYPE, null, null);
                        }
                        break block0;
                    }
                    case SHORT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.SHORT_OBJ_TYPE, true, null, Definition.SHORT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.CHAR_OBJ_TYPE, true, null, Definition.CHAR_TYPE, null, null);
                        }
                        break block0;
                    }
                    case INT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.INT_OBJ_TYPE, true, null, Definition.INT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case LONG: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.LONG_OBJ_TYPE, true, null, Definition.LONG_TYPE, null, null);
                        }
                        break block0;
                    }
                    case FLOAT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.FLOAT_OBJ_TYPE, true, null, Definition.FLOAT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case DOUBLE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.OBJECT_TYPE, Definition.DOUBLE_OBJ_TYPE, true, null, Definition.DOUBLE_TYPE, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case NUMBER: {
                switch (expected.sort) {
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.BYTE_OBJ_TYPE, true, null, Definition.BYTE_TYPE, null, null);
                        }
                        break block0;
                    }
                    case SHORT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.SHORT_OBJ_TYPE, true, null, Definition.SHORT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.CHAR_OBJ_TYPE, true, null, Definition.CHAR_TYPE, null, null);
                        }
                        break block0;
                    }
                    case INT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.INT_OBJ_TYPE, true, null, Definition.INT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case LONG: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.LONG_OBJ_TYPE, true, null, Definition.LONG_TYPE, null, null);
                        }
                        break block0;
                    }
                    case FLOAT: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.FLOAT_OBJ_TYPE, true, null, Definition.FLOAT_TYPE, null, null);
                        }
                        break block0;
                    }
                    case DOUBLE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.NUMBER_TYPE, Definition.DOUBLE_OBJ_TYPE, true, null, Definition.DOUBLE_TYPE, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BOOL_OBJ: {
                switch (expected.sort) {
                    case BOOL: {
                        if (internal) {
                            return new Definition.Cast(Definition.BOOLEAN_TYPE, Definition.BOOLEAN_TYPE, explicit, Definition.BOOLEAN_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case BYTE_OBJ: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BYTE: {
                        if (internal) {
                            return new Definition.Cast(Definition.BYTE_TYPE, expected, explicit, Definition.BYTE_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case CHAR: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.BYTE_TYPE, expected, true, Definition.BYTE_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case SHORT_OBJ: {
                switch (expected.sort) {
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(Definition.SHORT_TYPE, expected, explicit, Definition.SHORT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.SHORT_TYPE, expected, true, Definition.SHORT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case CHAR_OBJ: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case CHAR: {
                        if (internal) {
                            return new Definition.Cast(Definition.CHAR_TYPE, expected, explicit, Definition.CHAR_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.CHAR_TYPE, expected, true, Definition.CHAR_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case INT_OBJ: {
                switch (expected.sort) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(Definition.INT_TYPE, expected, explicit, Definition.INT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.INT_TYPE, expected, true, Definition.INT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case LONG_OBJ: {
                switch (expected.sort) {
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(Definition.LONG_TYPE, expected, explicit, Definition.LONG_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.LONG_TYPE, expected, true, Definition.LONG_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case FLOAT_OBJ: {
                switch (expected.sort) {
                    case FLOAT: 
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, expected, explicit, Definition.FLOAT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.FLOAT_TYPE, expected, true, Definition.FLOAT_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE_OBJ: {
                switch (expected.sort) {
                    case DOUBLE: {
                        if (internal) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, expected, explicit, Definition.DOUBLE_TYPE, null, null, null);
                        }
                        break block0;
                    }
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case CHAR: 
                    case BYTE: {
                        if (internal && explicit) {
                            return new Definition.Cast(Definition.DOUBLE_TYPE, expected, true, Definition.DOUBLE_TYPE, null, null, null);
                        }
                        break block0;
                    }
                }
                break;
            }
            case DEF: {
                switch (expected.sort) {
                    case BOOL: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.BOOLEAN_OBJ_TYPE, explicit, null, Definition.BOOLEAN_TYPE, null, null);
                    }
                    case BYTE: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.BYTE_OBJ_TYPE, explicit, null, Definition.BYTE_TYPE, null, null);
                    }
                    case SHORT: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.SHORT_OBJ_TYPE, explicit, null, Definition.SHORT_TYPE, null, null);
                    }
                    case CHAR: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.CHAR_OBJ_TYPE, explicit, null, Definition.CHAR_TYPE, null, null);
                    }
                    case INT: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.INT_OBJ_TYPE, explicit, null, Definition.INT_TYPE, null, null);
                    }
                    case LONG: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.LONG_OBJ_TYPE, explicit, null, Definition.LONG_TYPE, null, null);
                    }
                    case FLOAT: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.FLOAT_OBJ_TYPE, explicit, null, Definition.FLOAT_TYPE, null, null);
                    }
                    case DOUBLE: {
                        return new Definition.Cast(Definition.DEF_TYPE, Definition.DOUBLE_OBJ_TYPE, explicit, null, Definition.DOUBLE_TYPE, null, null);
                    }
                }
                break;
            }
            case STRING: {
                switch (expected.sort) {
                    case CHAR: {
                        if (!explicit) break;
                        return new Definition.Cast(Definition.STRING_TYPE, Definition.CHAR_TYPE, true);
                    }
                }
                break;
            }
        }
        if (actual.sort == Definition.Sort.DEF || actual.sort != Definition.Sort.VOID && expected.sort == Definition.Sort.DEF || expected.clazz.isAssignableFrom(actual.clazz) || explicit && actual.clazz.isAssignableFrom(expected.clazz)) {
            return new Definition.Cast(actual, expected, explicit);
        }
        throw location.createError(new ClassCastException("Cannot cast from [" + actual.name + "] to [" + expected.name + "]."));
    }

    public static Object constCast(Location location, Object constant, Definition.Cast cast) {
        Definition.Sort fsort = cast.from.sort;
        Definition.Sort tsort = cast.to.sort;
        if (fsort == tsort) {
            return constant;
        }
        if (fsort == Definition.Sort.STRING && tsort == Definition.Sort.CHAR) {
            return Character.valueOf(Utility.StringTochar((String)constant));
        }
        if (fsort == Definition.Sort.CHAR && tsort == Definition.Sort.STRING) {
            return Utility.charToString(((Character)constant).charValue());
        }
        if (fsort.numeric && tsort.numeric) {
            Number number = fsort == Definition.Sort.CHAR ? (Number)Integer.valueOf(((Character)constant).charValue()) : (Number)((Number)constant);
            switch (tsort) {
                case BYTE: {
                    return number.byteValue();
                }
                case SHORT: {
                    return number.shortValue();
                }
                case CHAR: {
                    return Character.valueOf((char)number.intValue());
                }
                case INT: {
                    return number.intValue();
                }
                case LONG: {
                    return number.longValue();
                }
                case FLOAT: {
                    return Float.valueOf(number.floatValue());
                }
                case DOUBLE: {
                    return number.doubleValue();
                }
            }
            throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
        }
        throw location.createError(new IllegalStateException("Cannot cast from [" + cast.from.clazz.getCanonicalName() + "] to [" + cast.to.clazz.getCanonicalName() + "]."));
    }

    public static Definition.Type promoteNumeric(Definition.Type from, boolean decimal) {
        Definition.Sort sort = from.sort;
        if (sort == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort == Definition.Sort.DOUBLE && decimal) {
            return Definition.DOUBLE_TYPE;
        }
        if (sort == Definition.Sort.FLOAT && decimal) {
            return Definition.FLOAT_TYPE;
        }
        if (sort == Definition.Sort.LONG) {
            return Definition.LONG_TYPE;
        }
        if (sort == Definition.Sort.INT || sort == Definition.Sort.CHAR || sort == Definition.Sort.SHORT || sort == Definition.Sort.BYTE) {
            return Definition.INT_TYPE;
        }
        return null;
    }

    public static Definition.Type promoteNumeric(Definition.Type from0, Definition.Type from1, boolean decimal) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (decimal) {
            if (sort0 == Definition.Sort.DOUBLE || sort1 == Definition.Sort.DOUBLE) {
                return Definition.DOUBLE_TYPE;
            }
            if (sort0 == Definition.Sort.FLOAT || sort1 == Definition.Sort.FLOAT) {
                return Definition.FLOAT_TYPE;
            }
        }
        if (sort0 == Definition.Sort.LONG || sort1 == Definition.Sort.LONG) {
            return Definition.LONG_TYPE;
        }
        if (sort0 == Definition.Sort.INT || sort1 == Definition.Sort.INT || sort0 == Definition.Sort.CHAR || sort1 == Definition.Sort.CHAR || sort0 == Definition.Sort.SHORT || sort1 == Definition.Sort.SHORT || sort0 == Definition.Sort.BYTE || sort1 == Definition.Sort.BYTE) {
            return Definition.INT_TYPE;
        }
        return null;
    }

    public static Definition.Type promoteAdd(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.STRING || sort1 == Definition.Sort.STRING) {
            return Definition.STRING_TYPE;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, true);
    }

    public static Definition.Type promoteXor(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.bool || sort1.bool) {
            return Definition.BOOLEAN_TYPE;
        }
        return AnalyzerCaster.promoteNumeric(from0, from1, false);
    }

    public static Definition.Type promoteEquality(Definition.Type from0, Definition.Type from1) {
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.primitive && sort1.primitive) {
            if (sort0.bool && sort1.bool) {
                return Definition.BOOLEAN_TYPE;
            }
            if (sort0.numeric && sort1.numeric) {
                return AnalyzerCaster.promoteNumeric(from0, from1, true);
            }
        }
        return Definition.OBJECT_TYPE;
    }

    public static Definition.Type promoteConditional(Definition.Type from0, Definition.Type from1, Object const0, Object const1) {
        if (from0.equals(from1)) {
            return from0;
        }
        Definition.Sort sort0 = from0.sort;
        Definition.Sort sort1 = from1.sort;
        if (sort0 == Definition.Sort.DEF || sort1 == Definition.Sort.DEF) {
            return Definition.DEF_TYPE;
        }
        if (sort0.primitive && sort1.primitive) {
            if (sort0.bool && sort1.bool) {
                return Definition.BOOLEAN_TYPE;
            }
            if (sort0 == Definition.Sort.DOUBLE || sort1 == Definition.Sort.DOUBLE) {
                return Definition.DOUBLE_TYPE;
            }
            if (sort0 == Definition.Sort.FLOAT || sort1 == Definition.Sort.FLOAT) {
                return Definition.FLOAT_TYPE;
            }
            if (sort0 == Definition.Sort.LONG || sort1 == Definition.Sort.LONG) {
                return Definition.LONG_TYPE;
            }
            if (sort0 == Definition.Sort.BYTE) {
                if (sort1 == Definition.Sort.BYTE) {
                    return Definition.BYTE_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    short constant;
                    if (const1 != null && (constant = ((Short)const1).shortValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.SHORT) {
                if (sort1 == Definition.Sort.BYTE) {
                    short constant;
                    if (const0 != null && (constant = ((Short)const0).shortValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    return Definition.SHORT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Definition.SHORT_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.CHAR) {
                if (sort1 == Definition.Sort.BYTE) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    return Definition.CHAR_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    int constant;
                    if (const1 != null && (constant = ((Integer)const1).intValue()) <= 65535 && constant >= 0) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
            } else if (sort0 == Definition.Sort.INT) {
                if (sort1 == Definition.Sort.BYTE) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 127 && constant >= -128) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.SHORT) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= Short.MAX_VALUE && constant >= Short.MIN_VALUE) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.CHAR) {
                    int constant;
                    if (const0 != null && (constant = ((Integer)const0).intValue()) <= 65535 && constant >= 0) {
                        return Definition.BYTE_TYPE;
                    }
                    return Definition.INT_TYPE;
                }
                if (sort1 == Definition.Sort.INT) {
                    return Definition.INT_TYPE;
                }
            }
        }
        return Definition.OBJECT_TYPE;
    }

    private AnalyzerCaster() {
    }
}

