/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.FatherDetailPanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FoundingFather;

public final class ChooseFoundingFatherDialog
extends FreeColDialog<FoundingFather> {
    private static final Logger logger = Logger.getLogger(ChooseFoundingFatherDialog.class.getName());
    private final JTabbedPane tb;
    private final List<FoundingFather> possibleFathers;

    public ChooseFoundingFatherDialog(FreeColClient freeColClient, JFrame frame, List<FoundingFather> possibleFoundingFathers) {
        super(freeColClient, frame);
        this.possibleFathers = possibleFoundingFathers;
        this.tb = new JTabbedPane(1);
        JButton helpButton = new JButton(freeColClient.getActionManager().getFreeColAction("colopediaAction.fathers"));
        helpButton.setText(Messages.message("help"));
        FatherDetailPanel details = new FatherDetailPanel(freeColClient, new ColopediaPanel(freeColClient));
        for (FoundingFather father : possibleFoundingFathers) {
            MigPanel jp = new MigPanel();
            details.buildDetail(father, (JPanel)jp);
            jp.validate();
            this.tb.addTab(Messages.message(father.getTypeKey()), jp);
        }
        this.tb.setSelectedIndex(0);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "align center"));
        panel.add(Utility.localizedHeader("chooseFoundingFatherDialog.title", false));
        panel.add((Component)helpButton, "tag help");
        panel.add((Component)this.tb, "width 100%");
        panel.setPreferredSize(panel.getPreferredSize());
        List c = ChooseFoundingFatherDialog.choices();
        c.add(new ChoiceItem<FoundingFather>(Messages.message("ok"), null).okOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, false, panel, null, c);
    }

    @Override
    public FoundingFather getResponse() {
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            return this.possibleFathers.get(this.tb.getSelectedIndex());
        }
        return null;
    }
}

