/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.listeners;

import freemind.controller.Controller;
import freemind.main.Resources;
import freemind.modes.ControllerAdapter;
import freemind.modes.mindmapmode.actions.MindMapActions;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.MapView;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Set;
import java.util.logging.Logger;

public class MindMapMouseWheelEventHandler
implements MouseWheelListener {
    private static int SCROLL_SKIPS = 8;
    private static final int HORIZONTAL_SCROLL_MASK = 29;
    private static final int ZOOM_MASK = 2;
    private static Logger logger = null;

    public MindMapMouseWheelEventHandler(ControllerAdapter controller) {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        Controller.addPropertyChangeListener(new FreemindPropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("wheel_velocity")) {
                    SCROLL_SKIPS = Integer.parseInt(newValue);
                }
            }
        });
        SCROLL_SKIPS = controller.getFrame().getIntProperty("wheel_velocity", 8);
        logger.info("Setting SCROLL_SKIPS to " + SCROLL_SKIPS);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MapView mapView = (MapView)e.getSource();
        ControllerAdapter mController = (ControllerAdapter)mapView.getModel().getModeController();
        if (mController.isBlocked()) {
            return;
        }
        Set registeredMouseWheelEventHandler = mController.getRegisteredMouseWheelEventHandler();
        for (MindMapActions.MouseWheelEventHandler handler : registeredMouseWheelEventHandler) {
            boolean result = handler.handleMouseWheelEvent(e);
            if (!result) continue;
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoomFactor = 1.0f + Math.abs((float)e.getWheelRotation()) / 10.0f;
            if (e.getWheelRotation() < 0) {
                newZoomFactor = 1.0f / newZoomFactor;
            }
            float oldZoom = ((MapView)e.getComponent()).getZoom();
            float newZoom = oldZoom / newZoomFactor;
            newZoom = (float)Math.rint(newZoom * 1000.0f) / 1000.0f;
            newZoom = Math.max(0.03125f, newZoom);
            if ((newZoom = Math.min(32.0f, newZoom)) != oldZoom) {
                mController.getController().setZoom(newZoom);
            }
        } else if ((e.getModifiers() & 0x1D) != 0) {
            ((MapView)e.getComponent()).scrollBy(SCROLL_SKIPS * e.getWheelRotation(), 0);
        } else {
            ((MapView)e.getComponent()).scrollBy(0, SCROLL_SKIPS * e.getWheelRotation());
        }
    }
}

