/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements Destroyable {
    public static final BooleanProperty PROP_ZOOM_REVERSE_WHEEL = new BooleanProperty("zoom.reverse-wheel", false);
    private EastNorth mousePosMove;
    private final NavigatableComponent nc;
    private boolean movementInPlace;
    private final ArrayList<Pair<ZoomerAction, Shortcut>> registeredShortcuts = new ArrayList();

    public MapMover(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        this.registerActionShortcut(new ZoomerAction("right"), Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right", new Object[0])), 39, 5006));
        this.registerActionShortcut(new ZoomerAction("left"), Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left", new Object[0])), 37, 5006));
        this.registerActionShortcut(new ZoomerAction("up"), Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up", new Object[0])), 38, 5006));
        this.registerActionShortcut(new ZoomerAction("down"), Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down", new Object[0])), 40, 5006));
        if (!Main.isPlatformOsx()) {
            this.registerActionShortcut(new ZoomerAction(",", "MapMover.Zoomer.in"), Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom in", new Object[0])), 44, 5006));
            this.registerActionShortcut(new ZoomerAction(".", "MapMover.Zoomer.out"), Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom out", new Object[0])), 46, 5006));
        }
    }

    private void registerActionShortcut(ZoomerAction zoomerAction, Shortcut shortcut) {
        Main.registerActionShortcut(zoomerAction, shortcut);
        this.registeredShortcuts.add(new Pair<ZoomerAction, Shortcut>(zoomerAction, shortcut));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        int n = 3072;
        int n2 = 1152;
        boolean bl2 = (mouseEvent.getModifiersEx() & (0x1000 | n)) == 4096;
        boolean bl3 = Main.isPlatformOsx() && mouseEvent.getModifiersEx() == n2;
        boolean bl4 = bl = !Main.map.mapModeSelect.equals(Main.map.mapMode) || SelectAction.Mode.SELECT.equals((Object)Main.map.mapModeSelect.getMode());
        if (bl2 || bl3 && bl) {
            if (this.mousePosMove == null) {
                this.startMovement(mouseEvent);
            }
            EastNorth eastNorth = this.nc.getCenter();
            EastNorth eastNorth2 = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + eastNorth.east() - eastNorth2.east(), this.mousePosMove.north() + eastNorth.north() - eastNorth2.north()));
        } else {
            this.endMovement();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = 3072;
        int n2 = 1152;
        if (mouseEvent.getButton() == 3 && (mouseEvent.getModifiersEx() & n) == 0 || Main.isPlatformOsx() && mouseEvent.getModifiersEx() == n2) {
            this.startMovement(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 || Main.isPlatformOsx() && mouseEvent.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent mouseEvent) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        this.nc.setNewCursor(13, (Object)this);
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        this.nc.resetCursor(this);
        this.mousePosMove = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = PROP_ZOOM_REVERSE_WHEEL.get() != false ? -mouseWheelEvent.getWheelRotation() : mouseWheelEvent.getWheelRotation();
        this.nc.zoomManyTimes(mouseWheelEvent.getX(), mouseWheelEvent.getY(), n);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.movementInPlace) {
            return;
        }
        if (Main.isPlatformOsx()) {
            if (mouseEvent.getModifiersEx() == 128) {
                if (this.mousePosMove == null) {
                    this.startMovement(mouseEvent);
                }
                EastNorth eastNorth = this.nc.getCenter();
                EastNorth eastNorth2 = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
                this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + eastNorth.east() - eastNorth2.east(), this.mousePosMove.north() + eastNorth.north() - eastNorth2.north()));
            } else {
                this.endMovement();
            }
        }
    }

    @Override
    public void destroy() {
        for (Pair<ZoomerAction, Shortcut> pair : this.registeredShortcuts) {
            Main.unregisterActionShortcut((Action)pair.a, (Shortcut)pair.b);
        }
    }

    static {
        new JMapViewerUpdater();
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        ZoomerAction(String string) {
            this(string, "MapMover.Zoomer." + string);
        }

        ZoomerAction(String string, String string2) {
            this.action = string;
            this.putValue("Name", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (".".equals(this.action) || ",".equals(this.action)) {
                Point point = Optional.ofNullable(MapMover.this.nc.getMousePosition()).orElseGet(() -> new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY()));
                MapMover.this.mouseWheelMoved(new MouseWheelEvent((Component)MapMover.this.nc, actionEvent.getID(), actionEvent.getWhen(), actionEvent.getModifiers(), point.x, point.y, 0, false, 0, 1, ",".equals(this.action) ? -1 : 1));
            } else {
                EastNorth eastNorth = MapMover.this.nc.getCenter();
                EastNorth eastNorth2 = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                switch (this.action) {
                    case "left": {
                        MapMover.this.nc.zoomTo(new EastNorth(2.0 * eastNorth.east() - eastNorth2.east(), eastNorth.north()));
                        break;
                    }
                    case "right": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth2.east(), eastNorth.north()));
                        break;
                    }
                    case "up": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), 2.0 * eastNorth.north() - eastNorth2.north()));
                        break;
                    }
                    case "down": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), eastNorth2.north()));
                        break;
                    }
                }
            }
        }
    }

    private static class JMapViewerUpdater
    implements Preferences.PreferenceChangedListener {
        JMapViewerUpdater() {
            Main.pref.addPreferenceChangeListener(this);
            JMapViewerUpdater.updateJMapViewer();
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (PROP_ZOOM_REVERSE_WHEEL.getKey().equals(preferenceChangeEvent.getKey())) {
                JMapViewerUpdater.updateJMapViewer();
            }
        }

        private static void updateJMapViewer() {
            JMapViewer.zoomReverseWheel = PROP_ZOOM_REVERSE_WHEEL.get();
        }
    }
}

