/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.openstreetmap.josm.gui.datatransfer.data.TagTransferData;

public class TagTransferable
implements Transferable {
    private final TagTransferData data;

    public TagTransferable(TagTransferData tagTransferData) {
        this.data = tagTransferData;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{TagTransferData.FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Stream.of(this.getTransferDataFlavors()).anyMatch(dataFlavor2 -> dataFlavor2.equals(dataFlavor));
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getStringData();
        }
        if (TagTransferData.FLAVOR.equals(dataFlavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private String getStringData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.data.getTags().entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

