/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;

public final class PartiallyInsideAreaStrategy
extends CompletelyInsideAreaStrategy {
    public static final PartiallyInsideAreaStrategy INSTANCE = new PartiallyInsideAreaStrategy();

    private PartiallyInsideAreaStrategy() {
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath mapViewPath, Rectangle2D rectangle2D) {
        MapViewPositionAndRotation mapViewPositionAndRotation = super.findLabelPlacement(mapViewPath, rectangle2D);
        if (mapViewPositionAndRotation != null) {
            return mapViewPositionAndRotation;
        }
        double d = Math.max(0.0, (rectangle2D.getWidth() - 20.0) / 2.0);
        double d2 = Math.max(0.0, (rectangle2D.getHeight() - 10.0) / 2.0);
        if (d < 0.5 && d2 < 0.5) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth() - 2.0 * d, rectangle2D.getHeight() - 2.0 * d2);
        return super.findLabelPlacement(mapViewPath, double_);
    }
}

