-- EFL LuaJIT bindings: efl_gfx_buffer.eo (class Efl.Gfx.Buffer)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_gfx_buffer_interface_get()
    eo.class_register("Efl_Gfx_Buffer", nil, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_gfx_buffer_interface_get(void);
    void efl_gfx_buffer_size_set(int w, int h);
    void efl_gfx_buffer_size_get(int *w, int *h);
    Efl_Gfx_Colorspace efl_gfx_buffer_colorspace_get(void);
    void efl_gfx_buffer_alpha_set(Eina_Bool alpha);
    Eina_Bool efl_gfx_buffer_alpha_get(void);
    int efl_gfx_buffer_stride_get(void);
    void efl_gfx_buffer_borders_get(unsigned int *l, unsigned int *r, unsigned int *t, unsigned int *b);
    void efl_gfx_buffer_update_add(int x, int y, int w, int h);
    void *efl_gfx_buffer_map(int *length, Efl_Gfx_Buffer_Access_Mode mode, int x, int y, int w, int h, Efl_Gfx_Colorspace cspace, int *stride);
    Eina_Bool efl_gfx_buffer_unmap(void * data, int length);
    Eina_Bool efl_gfx_buffer_data_set(void * pixels, int width, int height, int stride, Efl_Gfx_Colorspace cspace);
    Eina_Bool efl_gfx_buffer_copy_set(const void * pixels, int width, int height, int stride, Efl_Gfx_Colorspace cspace);
    void *efl_gfx_buffer_data_get(void);
]]

local __M = util.get_namespace(M, { "gfx" })
__body = {
    buffer_size_set = function(self, w, h)
        eo.__do_start(self, __class)
        __lib.efl_gfx_buffer_size_set(w, h)
        eo.__do_end()
    end,

    buffer_size_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("int[1]")
        local h = ffi.new("int[1]")
        __lib.efl_gfx_buffer_size_get(w, h)
        eo.__do_end()
        return tonumber(w[0]), tonumber(h[0])
    end,

    colorspace_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_colorspace_get()
        eo.__do_end()
        return v
    end,

    alpha_set = function(self, alpha)
        eo.__do_start(self, __class)
        __lib.efl_gfx_buffer_alpha_set(alpha)
        eo.__do_end()
    end,

    alpha_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_alpha_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    stride_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_stride_get()
        eo.__do_end()
        return tonumber(v)
    end,

    buffer_borders_get = function(self)
        eo.__do_start(self, __class)
        local l = ffi.new("unsigned int[1]")
        local r = ffi.new("unsigned int[1]")
        local t = ffi.new("unsigned int[1]")
        local b = ffi.new("unsigned int[1]")
        __lib.efl_gfx_buffer_borders_get(l, r, t, b)
        eo.__do_end()
        return l[0], r[0], t[0], b[0]
    end,

    buffer_update_add = function(self, x, y, w, h)
        eo.__do_start(self, __class)
        __lib.efl_gfx_buffer_update_add(x, y, w, h)
        eo.__do_end()
    end,

    buffer_map = function(self, mode, x, y, w, h, cspace)
        eo.__do_start(self, __class)
        local length = ffi.new("int[1]")
        local stride = ffi.new("int[1]")
        local v = __lib.efl_gfx_buffer_map(length, mode, x, y, w, h, cspace, stride)
        eo.__do_end()
        return v, tonumber(length[0]), tonumber(stride[0])
    end,

    buffer_unmap = function(self, data, length)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_unmap(data, length)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    buffer_data_set = function(self, pixels, width, height, stride, cspace)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_data_set(pixels, width, height, stride, cspace)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    buffer_copy_set = function(self, pixels, width, height, stride, cspace)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_copy_set(pixels, width, height, stride, cspace)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    buffer_data_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_gfx_buffer_data_get()
        eo.__do_end()
        return v
    end,

    __properties = {
        ["buffer_borders"] = { 0, 0, 4, 0, true, false },
        ["alpha"] = { 0, 0, 1, 1, true, true },
        ["buffer_size"] = { 0, 0, 2, 2, true, true },
        ["stride"] = { 0, 0, 1, 0, true, false },
        ["colorspace"] = { 0, 0, 1, 0, true, false }
    }
}
__body["__iface_Efl_Gfx_Buffer"] = true

return M
