/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.NamedWeakReference;
import com.sun.naming.internal.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String DISABLE_APP_RESOURCE_FILES = "com.sun.naming.disable.app.resource.files";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap<Object, Hashtable<? super String, Object>> propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap<ClassLoader, Map<String, List<NamedWeakReference<Object>>>> factoryCache = new WeakHashMap(11);
    private static final WeakHashMap<ClassLoader, Map<String, WeakReference<Object>>> urlFactoryCache = new WeakHashMap(11);
    private static final WeakReference<Object> NO_FACTORY = new WeakReference<Object>(null);

    private ResourceManager() {
    }

    public static Hashtable<?, ?> getInitialEnvironment(Hashtable<?, ?> env) throws NamingException {
        String[] props = VersionHelper.PROPS;
        if (env == null) {
            env = new Hashtable(11);
        }
        Object applet = env.get("java.naming.applet");
        String[] jndiSysProps = helper.getJndiProperties();
        for (int i = 0; i < props.length; ++i) {
            Object val = env.get(props[i]);
            if (val != null) continue;
            if (applet != null) {
                val = AppletParameter.get(applet, props[i]);
            }
            if (val == null) {
                Object object = val = jndiSysProps != null ? jndiSysProps[i] : helper.getJndiProperty(i);
            }
            if (val == null) continue;
            env.put(props[i], val);
        }
        String disableAppRes = (String)env.get(DISABLE_APP_RESOURCE_FILES);
        if (disableAppRes != null && disableAppRes.equalsIgnoreCase("true")) {
            return env;
        }
        ResourceManager.mergeTables(env, ResourceManager.getApplicationResources());
        return env;
    }

    public static String getProperty(String propName, Hashtable<?, ?> env, Context ctx, boolean concat) throws NamingException {
        String val1;
        String string = val1 = env != null ? (String)env.get(propName) : null;
        if (ctx == null || val1 != null && !concat) {
            return val1;
        }
        String val2 = (String)ResourceManager.getProviderResource(ctx).get(propName);
        if (val1 == null) {
            return val2;
        }
        if (val2 == null || !concat) {
            return val1;
        }
        return val1 + ":" + val2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryEnumeration getFactories(String propName, Hashtable<?, ?> env, Context ctx) throws NamingException {
        String facProp = ResourceManager.getProperty(propName, env, ctx, true);
        if (facProp == null) {
            return null;
        }
        ClassLoader loader = helper.getContextClassLoader();
        Map<String, List<NamedWeakReference<Object>>> perLoaderCache = null;
        Map<Object, Object> map = factoryCache;
        synchronized (map) {
            perLoaderCache = factoryCache.get(loader);
            if (perLoaderCache == null) {
                perLoaderCache = new HashMap<String, List<NamedWeakReference<Object>>>(11);
                factoryCache.put(loader, perLoaderCache);
            }
        }
        map = perLoaderCache;
        synchronized (map) {
            List<NamedWeakReference<Object>> factories = perLoaderCache.get(facProp);
            if (factories != null) {
                return factories.size() == 0 ? null : new FactoryEnumeration(factories, loader);
            }
            StringTokenizer parser = new StringTokenizer(facProp, ":");
            factories = new ArrayList<NamedWeakReference<Object>>(5);
            while (parser.hasMoreTokens()) {
                try {
                    String className = parser.nextToken();
                    Class<?> c = helper.loadClass(className, loader);
                    factories.add(new NamedWeakReference(c, className));
                }
                catch (Exception exception) {}
            }
            perLoaderCache.put(facProp, factories);
            return new FactoryEnumeration(factories, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String propName, Hashtable<?, ?> env, Context ctx, String classSuffix, String defaultPkgPrefix) throws NamingException {
        String facProp = ResourceManager.getProperty(propName, env, ctx, true);
        facProp = facProp != null ? facProp + ":" + defaultPkgPrefix : defaultPkgPrefix;
        ClassLoader loader = helper.getContextClassLoader();
        String key = classSuffix + " " + facProp;
        Map<String, WeakReference<Object>> perLoaderCache = null;
        Map<Object, Object> map = urlFactoryCache;
        synchronized (map) {
            perLoaderCache = urlFactoryCache.get(loader);
            if (perLoaderCache == null) {
                perLoaderCache = new HashMap<String, WeakReference<Object>>(11);
                urlFactoryCache.put(loader, perLoaderCache);
            }
        }
        map = perLoaderCache;
        synchronized (map) {
            Object factory = null;
            WeakReference<Object> factoryRef = perLoaderCache.get(key);
            if (factoryRef == NO_FACTORY) {
                return null;
            }
            if (factoryRef != null && (factory = (Object)factoryRef.get()) != null) {
                return factory;
            }
            StringTokenizer parser = new StringTokenizer(facProp, ":");
            while (factory == null && parser.hasMoreTokens()) {
                String className = parser.nextToken() + classSuffix;
                try {
                    factory = helper.loadClass(className, loader).newInstance();
                }
                catch (InstantiationException e) {
                    NamingException ne = new NamingException("Cannot instantiate " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (IllegalAccessException e) {
                    NamingException ne = new NamingException("Cannot access " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (Exception exception) {
                }
            }
            perLoaderCache.put(key, (WeakReference<Object>)(factory != null ? new WeakReference<Object>(factory) : NO_FACTORY));
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<? super String, Object> getProviderResource(Object obj) throws NamingException {
        if (obj == null) {
            return new Hashtable(1);
        }
        WeakHashMap<Object, Hashtable<? super String, Object>> weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Class<?> c = obj.getClass();
            Properties props = propertiesCache.get(c);
            if (props != null) {
                return props;
            }
            props = new Properties();
            InputStream istream = helper.getResourceAsStream(c, PROVIDER_RESOURCE_FILE_NAME);
            if (istream != null) {
                try {
                    props.load(istream);
                }
                catch (IOException e) {
                    ConfigurationException ne = new ConfigurationException("Error reading provider resource file for " + c);
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            propertiesCache.put(c, props);
            return props;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<? super String, Object> getApplicationResources() throws NamingException {
        ClassLoader cl = helper.getContextClassLoader();
        WeakHashMap<Object, Hashtable<? super String, Object>> weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Properties result;
            block23: {
                result = propertiesCache.get(cl);
                if (result != null) {
                    return result;
                }
                try {
                    InputStream istream;
                    NamingEnumeration<InputStream> resources = helper.getResources(cl, "jndi.properties");
                    try {
                        while (resources.hasMore()) {
                            Properties props = new Properties();
                            try (InputStream istream2 = resources.next();){
                                props.load(istream2);
                            }
                            if (result == null) {
                                result = props;
                                continue;
                            }
                            ResourceManager.mergeTables(result, props);
                        }
                    }
                    finally {
                        while (resources.hasMore()) {
                            istream = resources.next();
                            istream.close();
                        }
                    }
                    istream = helper.getJavaHomeLibStream("jndi.properties");
                    if (istream == null) break block23;
                    try {
                        Properties props = new Properties();
                        props.load(istream);
                        if (result == null) {
                            result = props;
                        } else {
                            ResourceManager.mergeTables(result, props);
                        }
                    }
                    finally {
                        istream.close();
                    }
                }
                catch (IOException e) {
                    ConfigurationException ne = new ConfigurationException("Error reading application resource file");
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            if (result == null) {
                result = new Hashtable(11);
            }
            propertiesCache.put(cl, result);
            return result;
        }
    }

    private static void mergeTables(Hashtable<? super String, Object> props1, Hashtable<? super String, Object> props2) {
        for (String string : props2.keySet()) {
            String prop = string;
            Object val1 = props1.get(prop);
            if (val1 == null) {
                props1.put(prop, props2.get(prop));
                continue;
            }
            if (!ResourceManager.isListProperty(prop)) continue;
            String val2 = (String)props2.get(prop);
            props1.put(prop, (String)val1 + ":" + val2);
        }
    }

    private static boolean isListProperty(String prop) {
        prop = prop.intern();
        for (int i = 0; i < listProperties.length; ++i) {
            if (prop != listProperties[i]) continue;
            return true;
        }
        return false;
    }

    private static class AppletParameter {
        private static final Class<?> clazz = AppletParameter.getClass("java.applet.Applet");
        private static final Method getMethod = AppletParameter.getMethod(clazz, "getParameter", String.class);

        private AppletParameter() {
        }

        private static Class<?> getClass(String name) {
            try {
                return Class.forName(name, true, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(name, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return null;
        }

        static Object get(Object applet, String name) {
            if (clazz == null || !clazz.isInstance(applet)) {
                throw new ClassCastException(applet.getClass().getName());
            }
            try {
                return getMethod.invoke(applet, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

