// Copyright (c) 2015 INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
// You can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL$
// $Id$
//
//
// Author(s)     : Sven Oesau, Yannick Verdie, Clément Jamin, Pierre Alliez
//

/**
* \ingroup PkgPointSetShapeDetection3
* \file CGAL/Shape_detection_3.h
* Convenience header file including the headers of this package.
*/


#ifndef CGAL_SHAPE_DETECTION_3_H
#define CGAL_SHAPE_DETECTION_3_H

#include <CGAL/license/Point_set_shape_detection_3.h>


#include <CGAL/Shape_detection_3/Efficient_RANSAC.h>
#include <CGAL/Shape_detection_3/Efficient_RANSAC_traits.h>
#include <CGAL/Shape_detection_3/Plane.h>
#include <CGAL/Shape_detection_3/Cylinder.h>
#include <CGAL/Shape_detection_3/Cone.h>
#include <CGAL/Shape_detection_3/Torus.h>
#include <CGAL/Shape_detection_3/Sphere.h>

#endif //CGAL_SHAPE_DETECTION_3_H
