;;;FillUpMeasure
(let ((appending (Appending?)) (position (GetPosition)))
(define (play-rhythm) 
	(let ((channel (d-StaffProperties "query=midi_channel")) (ticks #f) (time 0)
	      (prognum (d-StaffProperties "query=midi_prognum")))
	      (define command (number->string (logior (string->number channel) #xC0)))
		(d-OutputMidiBytes (string-append command  " " prognum))
		(apply d-GoToPosition position) ;(d-MoveCursorRight)
		(let loop ()
		    (set! ticks (d-GetDurationInTicks))
		    (d-OneShotTimer time (string-append "(d-PlayMidiNote  60 127 9 " (number->string ticks) ")"))
		    (set! time (+ time ticks))
		    (if (d-NextChordInMeasure)
		        (loop)))))
(define (play)	
	(let ((channel (d-StaffProperties "query=midi_channel")) (ticks #f) (time 0)(key #f)
	      (prognum (d-StaffProperties "query=midi_prognum")))
	      (define command (number->string (logior (string->number channel) #xC0)))
	    (d-OutputMidiBytes (string-append command  " " prognum))
	    (apply d-GoToPosition position) ;(d-MoveCursorRight)
	    (let loop ()
		(set! ticks (d-GetDurationInTicks))
		(set! key (d-GetNoteAsMidi))
		(if (and ticks key)
		    (begin
		        (d-OneShotTimer time (string-append "(d-PlayMidiNote  " (number->string key) " 127 " channel " " (number->string ticks) ")"))
		        (set! time (+ time ticks))))
		(if (d-NextChordInMeasure)
		    (loop)))))		        
		        
    (if (FullDurationMeasure?)
        (d-AddDuplicateMeasure 'play)
        (if (ZeroDurationMeasure?)
            (d-PutNote #f)
            (begin
               (while (d-PrevChordInMeasure))
               (d-SetMark)
               (while (d-NextChordInMeasure))
               (d-SetPoint)
               (d-Copy)
               (d-MoveCursorRight)
               (while (UnderfullMeasure?)
                    (d-Paste))
                    (if (d-GetNonprinting)
                    	(play-rhythm)
                    	(play))
                    (d-MoveCursorRight)))))
              