/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortCircuitingErrorHandlerBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortCircuitingErrorHandlerBuildCacheServiceDecorator.class);
    private final int maxErrorCount;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicInteger remainingErrorCount;

    public ShortCircuitingErrorHandlerBuildCacheServiceDecorator(int maxErrorCount, RoleAwareBuildCacheService delegate) {
        super(delegate);
        this.maxErrorCount = maxErrorCount;
        this.remainingErrorCount = new AtomicInteger(maxErrorCount);
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) {
        if (this.enabled.get()) {
            try {
                return super.load(key, reader);
            }
            catch (BuildCacheException e) {
                this.recordFailure();
            }
        }
        return false;
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) {
        if (this.enabled.get()) {
            try {
                super.store(key, writer);
            }
            catch (BuildCacheException e) {
                this.recordFailure();
            }
        }
    }

    public void close() throws IOException {
        if (!this.enabled.get()) {
            LOGGER.warn("The {} build cache was disabled during the build after encountering {} errors.", (Object)this.getRole(), (Object)this.maxErrorCount);
        }
        super.close();
    }

    private void recordFailure() {
        if (this.remainingErrorCount.decrementAndGet() <= 0 && this.enabled.compareAndSet(true, false)) {
            LOGGER.warn("The {} build cache is now disabled because {} errors were encountered", (Object)this.getRole(), (Object)this.maxErrorCount);
        }
    }
}

