/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.BuildCancellationToken;

public class TaskPathProjectEvaluator
implements ProjectConfigurer {
    private final BuildCancellationToken cancellationToken;

    public TaskPathProjectEvaluator(BuildCancellationToken cancellationToken) {
        this.cancellationToken = cancellationToken;
    }

    public void configure(ProjectInternal project) {
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        project.evaluate();
    }

    public void configureFully(ProjectInternal project) {
        this.configure(project);
        this.discoverTasks(project);
        this.bindAllModelRules(project);
    }

    private void discoverTasks(ProjectInternal project) {
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        project.getTasks().discoverTasks();
    }

    private void bindAllModelRules(ProjectInternal project) {
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException();
        }
        project.bindAllModelRules();
    }

    public void configureHierarchy(ProjectInternal project) {
        this.configure(project);
        for (Project sub : project.getSubprojects()) {
            this.configure((ProjectInternal)sub);
        }
    }

    public void configureHierarchyFully(ProjectInternal project) {
        this.configureFully(project);
        for (Project sub : project.getSubprojects()) {
            this.configureFully((ProjectInternal)sub);
        }
    }
}

