/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.util.GUtil;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemon;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonProtocol;

public class InProcessCompilerDaemonFactory
implements WorkerDaemonFactory {
    private final ClassLoaderFactory classLoaderFactory;
    private final File gradleUserHomeDir;
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();

    public InProcessCompilerDaemonFactory(ClassLoaderFactory classLoaderFactory, File gradleUserHomeDir) {
        this.classLoaderFactory = classLoaderFactory;
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    public WorkerDaemon getDaemon(Class<? extends WorkerDaemonProtocol> serverImplementationClass, File workingDir, final DaemonForkOptions forkOptions) {
        return new WorkerDaemon(){

            public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> compiler, T spec) {
                ClassLoader groovyClassLoader = InProcessCompilerDaemonFactory.this.classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath(forkOptions.getClasspath()));
                GroovySystemLoader groovyLoader = InProcessCompilerDaemonFactory.this.groovySystemLoaderFactory.forClassLoader(groovyClassLoader);
                FilteringClassLoader.Spec filteredGroovySpec = new FilteringClassLoader.Spec();
                for (String packageName : forkOptions.getSharedPackages()) {
                    filteredGroovySpec.allowPackage(packageName);
                }
                ClassLoader filteredGroovy = InProcessCompilerDaemonFactory.this.classLoaderFactory.createFilteringClassLoader(groovyClassLoader, filteredGroovySpec);
                FilteringClassLoader.Spec loggingSpec = new FilteringClassLoader.Spec();
                loggingSpec.allowPackage("org.slf4j");
                loggingSpec.allowClass(Logger.class);
                loggingSpec.allowClass(LogLevel.class);
                ClassLoader loggingClassLoader = InProcessCompilerDaemonFactory.this.classLoaderFactory.createFilteringClassLoader(compiler.getClass().getClassLoader(), loggingSpec);
                CachingClassLoader groovyAndLoggingClassLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{loggingClassLoader, filteredGroovy}));
                VisitableURLClassLoader workerClassLoader = new VisitableURLClassLoader((ClassLoader)groovyAndLoggingClassLoader, ClasspathUtil.getClasspath((ClassLoader)compiler.getClass().getClassLoader()));
                try {
                    byte[] serializedWorker = GUtil.serialize(new Worker(compiler, spec, InProcessCompilerDaemonFactory.this.gradleUserHomeDir, null));
                    ClassLoaderObjectInputStream inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), (ClassLoader)workerClassLoader);
                    Callable worker = (Callable)inputStream.readObject();
                    Object result = worker.call();
                    byte[] serializedResult = GUtil.serialize(result);
                    inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedResult), this.getClass().getClassLoader());
                    DefaultWorkResult defaultWorkResult = (DefaultWorkResult)inputStream.readObject();
                    return defaultWorkResult;
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                finally {
                    groovyLoader.shutdown();
                }
            }

            public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec, BuildOperationWorkerRegistry.Operation parentWorkerOperation, BuildOperationExecutor.Operation parentBuildOperation) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class Worker<T extends WorkSpec>
    implements Callable<Object>,
    Serializable {
        private final WorkerDaemonAction<T> compiler;
        private final T spec;
        private final File gradleUserHome;

        private Worker(WorkerDaemonAction<T> compiler, T spec, File gradleUserHome) {
            this.compiler = compiler;
            this.spec = spec;
            this.gradleUserHome = gradleUserHome;
        }

        @Override
        public Object call() throws Exception {
            NativeServices.initialize((File)this.gradleUserHome);
            return this.compiler.execute(this.spec);
        }

        /* synthetic */ Worker(WorkerDaemonAction x0, WorkSpec x1, File x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

