/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.attributes.DefaultArtifactAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;

public class LocalFileDependencyBackedArtifactSet
implements ResolvedArtifactSet {
    private final LocalFileDependencyMetadata dependencyMetadata;
    private final Spec<? super ComponentIdentifier> componentFilter;
    private final Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector;
    private final ImmutableAttributesFactory attributesFactory;

    public LocalFileDependencyBackedArtifactSet(LocalFileDependencyMetadata dependencyMetadata, Spec<? super ComponentIdentifier> componentFilter, Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector, ImmutableAttributesFactory attributesFactory) {
        this.dependencyMetadata = dependencyMetadata;
        this.componentFilter = componentFilter;
        this.selector = selector;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        return Collections.emptySet();
    }

    @Override
    public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
        dest.add((TaskDependency)this.dependencyMetadata.getFiles().getBuildDependencies());
    }

    @Override
    public void visit(ArtifactVisitor visitor) {
        Set files;
        if (!visitor.includeFiles()) {
            return;
        }
        ComponentIdentifier componentIdentifier = this.dependencyMetadata.getComponentId();
        if (componentIdentifier != null && !this.componentFilter.isSatisfiedBy((Object)componentIdentifier)) {
            return;
        }
        try {
            files = this.dependencyMetadata.getFiles().getFiles();
        }
        catch (Throwable throwable) {
            visitor.visitFailure(throwable);
            return;
        }
        for (File file : files) {
            Object artifactIdentifier;
            if (componentIdentifier == null) {
                artifactIdentifier = new OpaqueComponentArtifactIdentifier(file);
                if (!this.componentFilter.isSatisfiedBy((Object)artifactIdentifier.getComponentIdentifier())) {
                    continue;
                }
            } else {
                artifactIdentifier = new ComponentFileArtifactIdentifier(componentIdentifier, file.getName());
            }
            AttributeContainerInternal variantAttributes = DefaultArtifactAttributes.forFile(file, this.attributesFactory);
            DefaultResolvedVariant variant = new DefaultResolvedVariant(file, (ComponentArtifactIdentifier)artifactIdentifier, variantAttributes);
            ((ResolvedArtifactSet)this.selector.transform(Collections.singleton(variant))).visit(visitor);
        }
    }

    private static class DefaultResolvedVariant
    implements ResolvedVariant {
        private final File file;
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final AttributeContainerInternal variantAttributes;

        DefaultResolvedVariant(File file, ComponentArtifactIdentifier artifactIdentifier, AttributeContainerInternal variantAttributes) {
            this.file = file;
            this.artifactIdentifier = artifactIdentifier;
            this.variantAttributes = variantAttributes;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return new SingletonFileResolvedArtifactSet(this.file, this.artifactIdentifier, (AttributeContainer)this.variantAttributes);
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.variantAttributes;
        }
    }

    private static class SingletonFileResolvedArtifactSet
    implements ResolvedArtifactSet {
        private final File file;
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final AttributeContainer variantAttributes;

        SingletonFileResolvedArtifactSet(File file, ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variantAttributes) {
            this.file = file;
            this.artifactIdentifier = artifactIdentifier;
            this.variantAttributes = variantAttributes;
        }

        @Override
        public Set<ResolvedArtifact> getArtifacts() {
            return Collections.emptySet();
        }

        @Override
        public void collectBuildDependencies(Collection<? super TaskDependency> dest) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            if (visitor.includeFiles()) {
                visitor.visitFile(this.artifactIdentifier, this.variantAttributes, this.file);
            }
        }
    }
}

