/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.internal.type.ModelType;

class ArtifactTransformBackedTransformer
implements BiFunction<List<File>, File, File> {
    private final Class<? extends ArtifactTransform> implementationClass;
    private final Object[] parameters;

    ArtifactTransformBackedTransformer(Class<? extends ArtifactTransform> implementationClass, Object[] parameters) {
        this.implementationClass = implementationClass;
        this.parameters = parameters;
    }

    public List<File> apply(File file, File outputDir) {
        ArtifactTransform artifactTransform = this.create();
        artifactTransform.setOutputDirectory(outputDir);
        List outputs = artifactTransform.transform(file);
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        String inputFilePrefix = file.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            if (!output.exists()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " does not exist.");
            }
            if (output.equals(file) || output.equals(outputDir) || output.getPath().startsWith(outputDirPrefix) || output.getPath().startsWith(inputFilePrefix)) continue;
            throw new InvalidUserDataException("Transform output file " + output.getPath() + " is not a child of the transform's input file or output directory.");
        }
        return outputs;
    }

    private ArtifactTransform create() {
        try {
            return (ArtifactTransform)DirectInstantiator.INSTANCE.newInstance(this.implementationClass, this.parameters);
        }
        catch (ObjectInstantiationException e) {
            throw new VariantTransformConfigurationException("Could not create instance of " + ModelType.of(this.implementationClass).getDisplayName() + ".", e.getCause());
        }
        catch (RuntimeException e) {
            throw new VariantTransformConfigurationException("Could not create instance of " + ModelType.of(this.implementationClass).getDisplayName() + ".", (Throwable)e);
        }
    }
}

