/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantMetadata;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ModuleDescriptorState descriptor;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final String status;
    private final List<String> statusScheme;
    @Nullable
    private final ModuleSource moduleSource;
    private final Map<String, Configuration> configurationDefinitions;
    private final Map<String, DefaultConfigurationMetadata> configurations;
    @Nullable
    private final List<ModuleComponentArtifactMetadata> artifacts;
    private final List<? extends DependencyMetadata> dependencies;
    private final List<Exclude> excludes;

    protected AbstractModuleComponentResolveMetadata(MutableModuleComponentResolveMetadata metadata) {
        this.descriptor = metadata.getDescriptor();
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.dependencies = metadata.getDependencies();
        this.excludes = this.descriptor.getExcludes();
        this.artifacts = metadata.getArtifacts();
        this.configurations = this.populateConfigurationsFromDescriptor();
        if (this.artifacts != null) {
            this.populateArtifacts(this.artifacts);
        } else {
            this.populateArtifactsFromDescriptor();
        }
    }

    protected AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, @Nullable ModuleSource source) {
        this.descriptor = metadata.getDescriptor();
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = source;
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.dependencies = metadata.getDependencies();
        this.excludes = metadata.excludes;
        this.artifacts = metadata.artifacts;
        this.configurations = metadata.configurations;
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return null;
    }

    @Override
    public ModuleDescriptorState getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isGenerated() {
        return this.descriptor.isGenerated();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurations.keySet();
    }

    @Override
    public List<? extends ConfigurationMetadata> getConsumableConfigurationsHavingAttributes() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    private void populateArtifacts(List<ModuleComponentArtifactMetadata> artifacts) {
        for (DefaultConfigurationMetadata configuration : this.configurations.values()) {
            configuration.artifacts.addAll(artifacts);
        }
    }

    private void populateArtifactsFromDescriptor() {
        for (Artifact artifact : this.descriptor.getArtifacts()) {
            DefaultModuleComponentArtifactMetadata artifactMetadata = new DefaultModuleComponentArtifactMetadata(this.componentIdentifier, artifact.getArtifactName());
            for (String configuration : artifact.getConfigurations()) {
                this.configurations.get(configuration).artifacts.add(artifactMetadata);
            }
        }
        HashSet<ConfigurationMetadata> visited = new HashSet<ConfigurationMetadata>();
        for (DefaultConfigurationMetadata configuration : this.configurations.values()) {
            configuration.collectInheritedArtifacts(visited);
        }
    }

    @Override
    @Nullable
    public List<ModuleComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    public DefaultConfigurationMetadata getConfiguration(String name) {
        return this.configurations.get(name);
    }

    private Map<String, DefaultConfigurationMetadata> populateConfigurationsFromDescriptor() {
        Set<String> configurationsNames = this.configurationDefinitions.keySet();
        HashMap<String, DefaultConfigurationMetadata> configurations = new HashMap<String, DefaultConfigurationMetadata>(configurationsNames.size());
        for (String configName : configurationsNames) {
            DefaultConfigurationMetadata configuration = this.populateConfigurationFromDescriptor(configName, this.configurationDefinitions, configurations);
            configuration.populateDependencies(this.dependencies);
        }
        return configurations;
    }

    private DefaultConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions, Map<String, DefaultConfigurationMetadata> configurations) {
        DefaultConfigurationMetadata populated = configurations.get(name);
        if (populated != null) {
            return populated;
        }
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        List<String> extendsFrom = descriptorConfiguration.getExtendsFrom();
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        if (extendsFrom.isEmpty()) {
            populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, this.excludes);
            configurations.put(name, populated);
            return populated;
        }
        if (extendsFrom.size() == 1) {
            populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, Collections.singletonList(this.populateConfigurationFromDescriptor(extendsFrom.get(0), configurationDefinitions, configurations)), this.excludes);
            configurations.put(name, populated);
            return populated;
        }
        ArrayList<DefaultConfigurationMetadata> hierarchy = new ArrayList<DefaultConfigurationMetadata>(extendsFrom.size());
        for (String confName : extendsFrom) {
            hierarchy.add(this.populateConfigurationFromDescriptor(confName, configurationDefinitions, configurations));
        }
        populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, hierarchy, this.excludes);
        configurations.put(name, populated);
        return populated;
    }

    private static class DefaultConfigurationMetadata
    implements ConfigurationMetadata {
        private final ModuleComponentIdentifier componentId;
        private final String name;
        private final List<DefaultConfigurationMetadata> parents;
        private final List<DependencyMetadata> configDependencies = new ArrayList<DependencyMetadata>();
        private final Set<ComponentArtifactMetadata> artifacts = new LinkedHashSet<ComponentArtifactMetadata>();
        private final boolean transitive;
        private final boolean visible;
        private final Set<String> hierarchy;
        private final List<Exclude> excludes;
        private ModuleExclusion exclusions;

        private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, List<DefaultConfigurationMetadata> parents, List<Exclude> excludes) {
            this.componentId = componentId;
            this.name = name;
            this.parents = parents;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = this.calculateHierarchy();
            this.excludes = excludes;
        }

        private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, List<Exclude> excludes) {
            this(componentId, name, transitive, visible, null, excludes);
        }

        public String toString() {
            return this.componentId + ":" + this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getHierarchy() {
            return this.hierarchy;
        }

        private Set<String> calculateHierarchy() {
            if (this.parents == null) {
                return Collections.singleton(this.name);
            }
            LinkedHashSet<String> hierarchy = new LinkedHashSet<String>(1 + this.parents.size());
            this.populateHierarchy(hierarchy);
            return hierarchy;
        }

        private void populateHierarchy(Set<String> accumulator) {
            accumulator.add(this.name);
            if (this.parents != null) {
                for (DefaultConfigurationMetadata parent : this.parents) {
                    parent.populateHierarchy(accumulator);
                }
            }
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public boolean isCanBeConsumed() {
            return true;
        }

        @Override
        public boolean isCanBeResolved() {
            return false;
        }

        public List<DependencyMetadata> getDependencies() {
            return this.configDependencies;
        }

        private void populateDependencies(Iterable<? extends DependencyMetadata> dependencies) {
            for (DependencyMetadata dependencyMetadata : dependencies) {
                if (!this.include(dependencyMetadata)) continue;
                this.configDependencies.add(dependencyMetadata);
            }
        }

        private boolean include(DependencyMetadata dependency) {
            Set<String> hierarchy = this.getHierarchy();
            for (String moduleConfiguration : dependency.getModuleConfigurations()) {
                if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                    return true;
                }
                if (!moduleConfiguration.equals("*")) continue;
                boolean include = true;
                for (String conf2 : dependency.getModuleConfigurations()) {
                    if (!conf2.startsWith("!") || !conf2.substring(1).equals(this.getName())) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                return true;
            }
            return false;
        }

        @Override
        public ModuleExclusion getExclusions(ModuleExclusions moduleExclusions) {
            if (this.exclusions == null) {
                this.exclusions = this.filterExcludes(moduleExclusions, this.excludes);
            }
            return this.exclusions;
        }

        private ModuleExclusion filterExcludes(ModuleExclusions exclusions, Iterable<Exclude> excludes) {
            Set<String> hierarchy = this.getHierarchy();
            ArrayList filtered = Lists.newArrayList();
            block0: for (Exclude exclude : excludes) {
                for (String config : exclude.getConfigurations()) {
                    if (!hierarchy.contains(config)) continue;
                    filtered.add(exclude);
                    continue block0;
                }
            }
            return exclusions.excludeAny(filtered);
        }

        public Set<ComponentArtifactMetadata> getArtifacts() {
            return this.artifacts;
        }

        @Override
        public Set<? extends VariantMetadata> getVariants() {
            return ImmutableSet.of((Object)new DefaultVariantMetadata(this.getAttributes(), this.getArtifacts()));
        }

        @Override
        public ModuleComponentArtifactMetadata artifact(IvyArtifactName artifact) {
            return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
        }

        public void collectInheritedArtifacts(Set<ConfigurationMetadata> visited) {
            if (!visited.add(this)) {
                return;
            }
            if (this.parents == null) {
                return;
            }
            for (DefaultConfigurationMetadata parent : this.parents) {
                parent.collectInheritedArtifacts(visited);
                this.artifacts.addAll(parent.artifacts);
            }
        }
    }
}

