/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.internal.Actions;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.ErrorResponse;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;
import org.gradle.util.GradleVersion;

public class HttpPluginResolutionServiceClient
implements PluginResolutionServiceClient {
    private static final Escaper PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private static final String CLIENT_REQUEST_BASE = String.format("%s", PATH_SEGMENT_ESCAPER.escape(GradleVersion.current().getVersion()));
    private static final String PLUGIN_USE_REQUEST_URL = "/plugin/use/%s/%s";
    private static final String JSON = "application/json";
    public static final String CLIENT_STATUS_CHECKSUM_HEADER = "X-Gradle-Client-Status-Checksum";
    private final SslContextFactory sslContextFactory;
    private HttpResourceAccessor resourceAccessor;

    public HttpPluginResolutionServiceClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null);
    }

    public HttpPluginResolutionServiceClient(SslContextFactory sslContextFactory, HttpResourceAccessor resourceAccessor) {
        this.sslContextFactory = sslContextFactory;
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    @Nullable
    public PluginResolutionServiceClient.Response<PluginUseMetaData> queryPluginMetadata(String portalUrl, boolean shouldValidate, PluginRequestInternal pluginRequest) {
        String escapedId = PATH_SEGMENT_ESCAPER.escape(pluginRequest.getId().toString());
        String escapedPluginVersion = PATH_SEGMENT_ESCAPER.escape(pluginRequest.getVersion());
        final String requestUrl = this.toRequestUrl(portalUrl, String.format(PLUGIN_USE_REQUEST_URL, escapedId, escapedPluginVersion));
        return this.request(requestUrl, PluginUseMetaData.class, new Action<PluginUseMetaData>(){

            public void execute(PluginUseMetaData pluginUseMetaData) {
                HttpPluginResolutionServiceClient.this.validate(requestUrl, pluginUseMetaData);
            }
        });
    }

    @Override
    public PluginResolutionServiceClient.Response<ClientStatus> queryClientStatus(String portalUrl, boolean shouldValidate, String checksum) {
        String requestUrl = this.toRequestUrl(portalUrl, "");
        return this.request(requestUrl, ClientStatus.class, Actions.doNothing());
    }

    private String toRequestUrl(String portalUrl, String path) {
        return portalUrl + "/" + CLIENT_REQUEST_BASE + path;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> PluginResolutionServiceClient.Response<T> request(String requestUrl, Class<T> type, Action<? super T> validator) {
        URI requestUri = this.toUri(requestUrl, "plugin request");
        try (HttpResponseResource response = this.getResourceAccessor().getRawResource(requestUri, false);){
            int statusCode = response.getStatusCode();
            String contentType = response.getContentType();
            if (contentType == null || !contentType.equalsIgnoreCase(JSON)) {
                String message = String.format("content type is '%s', expected '%s' (status code: %s)", contentType == null ? "" : contentType, JSON, statusCode);
                throw new OutOfProtocolException(requestUrl, message);
            }
            String clientStatusChecksum = response.getHeaderValue(CLIENT_STATUS_CHECKSUM_HEADER);
            InputStreamReader reader = new InputStreamReader(response.openStream(), "utf-8");
            try {
                if (statusCode == 200) {
                    Object payload = new Gson().fromJson((Reader)reader, type);
                    validator.execute(payload);
                    PluginResolutionServiceClient.SuccessResponse<Object> successResponse = new PluginResolutionServiceClient.SuccessResponse<Object>(payload, statusCode, requestUrl, clientStatusChecksum);
                    return successResponse;
                }
                if (statusCode < 400 || statusCode >= 600) throw new OutOfProtocolException(requestUrl, "unexpected HTTP response status " + statusCode);
                ErrorResponse errorResponse = this.validate(requestUrl, (ErrorResponse)new Gson().fromJson((Reader)reader, ErrorResponse.class));
                PluginResolutionServiceClient.ErrorResponseResponse errorResponseResponse = new PluginResolutionServiceClient.ErrorResponseResponse(errorResponse, statusCode, requestUrl, clientStatusChecksum);
                return errorResponseResponse;
            }
            catch (JsonSyntaxException e) {
                throw new OutOfProtocolException(requestUrl, "could not parse response JSON", e);
            }
            catch (JsonIOException e) {
                throw new OutOfProtocolException(requestUrl, "could not parse response JSON", e);
            }
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed((URI)requestUri, (Throwable)e);
        }
    }

    @Override
    public void close() {
    }

    private PluginUseMetaData validate(String url, PluginUseMetaData pluginUseMetaData) {
        if (pluginUseMetaData.implementationType == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no implementation type specified");
        }
        if (!pluginUseMetaData.implementationType.equals("M2_JAR")) {
            throw new OutOfProtocolException(url, String.format("invalid plugin metadata - unsupported implementation type '%s'", pluginUseMetaData.implementationType));
        }
        if (pluginUseMetaData.implementation == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no implementation specified");
        }
        if (pluginUseMetaData.implementation.get("gav") == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no module coordinates specified");
        }
        if (pluginUseMetaData.implementation.get("repo") == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no module repository specified");
        }
        return pluginUseMetaData;
    }

    private ErrorResponse validate(String url, ErrorResponse errorResponse) {
        if (errorResponse.errorCode == null) {
            throw new OutOfProtocolException(url, "invalid error response - no error code specified");
        }
        if (errorResponse.message == null) {
            throw new OutOfProtocolException(url, "invalid error response - no message specified");
        }
        return errorResponse;
    }

    private URI toUri(String url, String kind) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GradleException(String.format("Invalid %s URL: %s", kind, url), (Throwable)e);
        }
    }

    private HttpResourceAccessor getResourceAccessor() {
        if (this.resourceAccessor == null) {
            this.resourceAccessor = new HttpResourceAccessor(new HttpClientHelper((HttpSettings)new DefaultHttpSettings(Collections.emptyList(), this.sslContextFactory)));
        }
        return this.resourceAccessor;
    }

    private static class OutOfProtocolException
    extends GradleException {
        private OutOfProtocolException(String requestUrl, String message) {
            super(OutOfProtocolException.toMessage(requestUrl, message));
        }

        private OutOfProtocolException(String requestUrl, String message, Throwable cause) {
            super(OutOfProtocolException.toMessage(requestUrl, message), cause);
        }

        private static String toMessage(String requestUrl, String message) {
            return String.format("The response from %s was not a valid response from a Gradle Plugin Resolution Service: %s", requestUrl, message);
        }
    }
}

