/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDetector;
import org.gradle.api.internal.tasks.compile.CleaningGroovyCompiler;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.daemon.InProcessCompilerDaemonFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GFileUtils;
import org.gradle.workers.internal.WorkerDaemonManager;

@CacheableTask
public class GroovyCompile
extends AbstractCompile {
    private Compiler<GroovyJavaJointCompileSpec> compiler;
    private FileCollection groovyClasspath;
    private final CompileOptions compileOptions = new CompileOptions();
    private final GroovyCompileOptions groovyCompileOptions = new GroovyCompileOptions();

    @TaskAction
    protected void compile() {
        this.checkGroovyClasspathIsNonEmpty();
        DefaultGroovyJavaJointCompileSpec spec = this.createSpec();
        WorkResult result = this.getCompiler(spec).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<GroovyJavaJointCompileSpec> getCompiler(GroovyJavaJointCompileSpec spec) {
        if (this.compiler == null) {
            ProjectInternal projectInternal = (ProjectInternal)this.getProject();
            WorkerDaemonManager compilerDaemonManager = (WorkerDaemonManager)this.getServices().get(WorkerDaemonManager.class);
            InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory = (InProcessCompilerDaemonFactory)this.getServices().get(InProcessCompilerDaemonFactory.class);
            JavaCompilerFactory javaCompilerFactory = (JavaCompilerFactory)this.getServices().get(JavaCompilerFactory.class);
            GroovyCompilerFactory groovyCompilerFactory = new GroovyCompilerFactory(projectInternal, javaCompilerFactory, compilerDaemonManager, inProcessCompilerDaemonFactory);
            Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
            this.compiler = new CleaningGroovyCompiler(delegatingCompiler, this.getOutputs());
        }
        return this.compiler;
    }

    private DefaultGroovyJavaJointCompileSpec createSpec() {
        DefaultGroovyJavaJointCompileSpec spec = (DefaultGroovyJavaJointCompileSpec)new DefaultGroovyJavaJointCompileSpecFactory(this.compileOptions).create();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setAnnotationProcessorPath(this.calculateAnnotationProcessorClasspath());
        spec.setGroovyClasspath(Lists.newArrayList((Iterable)this.getGroovyClasspath()));
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(this.groovyCompileOptions);
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs((File)dir);
            spec.getGroovyCompileOptions().setStubDir(dir);
        }
        return spec;
    }

    private List<File> calculateAnnotationProcessorClasspath() {
        AnnotationProcessorDetector annotationProcessorDetector = (AnnotationProcessorDetector)this.getServices().get(AnnotationProcessorDetector.class);
        FileCollection processorClasspath = annotationProcessorDetector.getEffectiveAnnotationProcessorClasspath(this.compileOptions, this.getClasspath());
        return Lists.newArrayList((Iterable)processorClasspath);
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, " + "the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Classpath
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Internal
    public Compiler<GroovyJavaJointCompileSpec> getCompiler() {
        return this.getCompiler(this.createSpec());
    }

    public void setCompiler(Compiler<GroovyJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }
}

