/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.PT;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MSRdr;

public class MSCifParser
extends MSRdr {
    private String field;
    private static final int FWV_ID = 0;
    private static final int WV_ID = 1;
    private static final int WV_X = 2;
    private static final int WV_Y = 3;
    private static final int WV_Z = 4;
    private static final int FWV_X = 5;
    private static final int FWV_Y = 6;
    private static final int FWV_Z = 7;
    private static final int JANA_FWV_Q1_COEF = 8;
    private static final int JANA_FWV_Q2_COEF = 9;
    private static final int JANA_FWV_Q3_COEF = 10;
    private static final int FWV_DISP_LABEL = 11;
    private static final int FWV_DISP_AXIS = 12;
    private static final int FWV_DISP_SEQ_ID = 13;
    private static final int FWV_DISP_COS = 14;
    private static final int FWV_DISP_SIN = 15;
    private static final int FWV_DISP_MODULUS = 16;
    private static final int FWV_DISP_PHASE = 17;
    private static final int DISP_SPEC_LABEL = 18;
    private static final int DISP_SAW_AX = 19;
    private static final int DISP_SAW_AY = 20;
    private static final int DISP_SAW_AZ = 21;
    private static final int DISP_SAW_C = 22;
    private static final int DISP_SAW_W = 23;
    private static final int FWV_OCC_LABEL = 24;
    private static final int FWV_OCC_SEQ_ID = 25;
    private static final int FWV_OCC_COS = 26;
    private static final int FWV_OCC_SIN = 27;
    private static final int FWV_OCC_MODULUS = 28;
    private static final int FWV_OCC_PHASE = 29;
    private static final int OCC_SPECIAL_LABEL = 30;
    private static final int OCC_CRENEL_C = 31;
    private static final int OCC_CRENEL_W = 32;
    private static final int FWV_U_LABEL = 33;
    private static final int FWV_U_TENS = 34;
    private static final int FWV_U_SEQ_ID = 35;
    private static final int FWV_U_COS = 36;
    private static final int FWV_U_SIN = 37;
    private static final int FWV_U_MODULUS = 38;
    private static final int FWV_U_PHASE = 39;
    private static final int FD_ID = 40;
    private static final int FO_ID = 41;
    private static final int FU_ID = 42;
    private static final int FDP_ID = 43;
    private static final int FOP_ID = 44;
    private static final int FUP_ID = 45;
    private static final int JANA_OCC_ABS_LABEL = 46;
    private static final int JANA_OCC_ABS_O_0 = 47;
    private static final int FWV_SPIN_LABEL = 48;
    private static final int FWV_SPIN_AXIS = 49;
    private static final int FWV_SPIN_SEQ_ID = 50;
    private static final int FWV_SPIN_COS = 51;
    private static final int FWV_SPIN_SIN = 52;
    private static final int FWV_SPIN_MODULUS = 53;
    private static final int FWV_SPIN_PHASE = 54;
    private static final int SPIN_SPEC_LABEL = 55;
    private static final int SPIN_SAW_AX = 56;
    private static final int SPIN_SAW_AY = 57;
    private static final int SPIN_SAW_AZ = 58;
    private static final int SPIN_SAW_C = 59;
    private static final int SPIN_SAW_W = 60;
    private static final int LEG_DISP_LABEL = 61;
    private static final int LEG_DISP_AXIS = 62;
    private static final int LEG_DISP_ORDER = 63;
    private static final int LEG_DISP_COEF = 64;
    private static final int LEG_U_LABEL = 65;
    private static final int LEG_U_TENS = 66;
    private static final int LEG_U_ORDER = 67;
    private static final int LEG_U_COEF = 68;
    private static final int LEG_OCC_LABEL = 69;
    private static final int LEG_OCC_ORDER = 70;
    private static final int LEG_OCC_COEF = 71;
    private static final int DEPR_FD_COS = 72;
    private static final int DEPR_FD_SIN = 73;
    private static final int DEPR_FO_COS = 74;
    private static final int DEPR_FO_SIN = 75;
    private static final int DEPR_FU_COS = 76;
    private static final int DEPR_FU_SIN = 77;
    private static final String[] modulationFields = new String[]{"*_fourier_wave_vector_seq_id", "_cell_wave_vector_seq_id", "_cell_wave_vector_x", "_cell_wave_vector_y", "_cell_wave_vector_z", "*_fourier_wave_vector_x", "*_fourier_wave_vector_y", "*_fourier_wave_vector_z", "*_fourier_wave_vector_q1_coeff", "*_fourier_wave_vector_q2_coeff", "*_fourier_wave_vector_q3_coeff", "*_displace_fourier_atom_site_label", "*_displace_fourier_axis", "*_displace_fourier_wave_vector_seq_id", "*_displace_fourier_param_cos", "*_displace_fourier_param_sin", "*_displace_fourier_param_modulus", "*_displace_fourier_param_phase", "*_displace_special_func_atom_site_label", "*_displace_special_func_sawtooth_ax", "*_displace_special_func_sawtooth_ay", "*_displace_special_func_sawtooth_az", "*_displace_special_func_sawtooth_c", "*_displace_special_func_sawtooth_w", "*_occ_fourier_atom_site_label", "*_occ_fourier_wave_vector_seq_id", "*_occ_fourier_param_cos", "*_occ_fourier_param_sin", "*_occ_fourier_param_modulus", "*_occ_fourier_param_phase", "*_occ_special_func_atom_site_label", "*_occ_special_func_crenel_c", "*_occ_special_func_crenel_w", "*_u_fourier_atom_site_label", "*_u_fourier_tens_elem", "*_u_fourier_wave_vector_seq_id", "*_u_fourier_param_cos", "*_u_fourier_param_sin", "*_u_fourier_param_modulus", "*_u_fourier_param_phase", "*_displace_fourier_id", "*_occ_fourier_id", "*_u_fourier_id", "*_displace_fourier_param_id", "*_occ_fourier_param_id", "*_u_fourier_param_id", "*_occ_fourier_absolute_site_label", "*_occ_fourier_absolute", "*_moment_fourier_atom_site_label", "*_moment_fourier_axis", "*_moment_fourier_wave_vector_seq_id", "*_moment_fourier_param_cos", "*_moment_fourier_param_sin", "*_moment_fourier_param_modulus", "*_moment_fourier_param_phase", "*_moment_special_func_atom_site_label", "*_moment_special_func_sawtooth_ax", "*_moment_special_func_sawtooth_ay", "*_moment_special_func_sawtooth_az", "*_moment_special_func_sawtooth_c", "*_moment_special_func_sawtooth_w", "*_displace_legendre_atom_site_label", "*_displace_legendre_axis", "*_displace_legendre_param_order", "*_displace_legendre_param_coeff", "*_u_legendre_atom_site_label", "*_u_legendre_tens_elem", "*_u_legendre_param_order", "*_u_legendre_param_coeff", "*_occ_legendre_atom_site_label", "*_occ_legendre_param_order", "*_occ_legendre_param_coeff", "*_displace_fourier_cos", "*_displace_fourier_sin", "*_occ_fourier_cos", "*_occ_fourier_sin", "*_u_fourier_cos", "*_u_fourier_sin"};
    private static final int NONE = -1;
    private M3 comSSMat;

    public void processEntry() throws Exception {
        CifReader cr = (CifReader)this.cr;
        if (cr.key.equals("_cell_commen_t_section_1")) {
            this.isCommensurate = true;
            this.commensurateSection1 = cr.parseIntStr(cr.data);
        }
        if (cr.key.startsWith("_cell_commen_supercell_matrix")) {
            this.isCommensurate = true;
            if (this.comSSMat == null) {
                this.comSSMat = M3.newM3(null);
            }
            String[] tokens = PT.split((String)cr.key, (String)"_");
            int r = cr.parseIntStr(tokens[tokens.length - 2]);
            int c = cr.parseIntStr(tokens[tokens.length - 1]);
            if (r > 0 && c > 0) {
                this.comSSMat.setElement(r - 1, c - 1, cr.parseFloatStr(cr.data));
            }
        }
    }

    public int processLoopBlock() throws Exception {
        CifReader cr = (CifReader)this.cr;
        String key = cr.key;
        if (key.equals("_cell_subsystem_code")) {
            return this.processSubsystemLoopBlock();
        }
        if (!(key.startsWith("_cell_wave") || key.contains("fourier") || key.contains("legendre") || key.contains("_special_func"))) {
            if (key.contains("crenel_ortho")) {
                cr.appendLoadNote("WARNING: Orthogonalized non-Legendre functions not supported.\nThe following block has been ignored. Use Legendre functions instead.\n\n" + cr.parser.skipLoop(true) + "=================================\n");
            }
            return 0;
        }
        if (cr.asc.iSet < 0) {
            cr.asc.newAtomSet();
        }
        cr.parseLoopParametersFor("_atom_site", modulationFields);
        if (cr.key2col[8] != -1) {
            cr.key2col[7] = -1;
            cr.key2col[6] = -1;
            cr.key2col[5] = -1;
        }
        block37: while (cr.parser.getData()) {
            boolean ignore = false;
            String type_id = null;
            String atomLabel = null;
            String axis = null;
            double[] pt = new double[]{Double.NaN, Double.NaN, Double.NaN};
            double c = Double.NaN;
            double w = Double.NaN;
            String fid = null;
            int n = cr.parser.getColumnCount();
            block38: for (int i = 0; i < n; ++i) {
                int tok = this.fieldProperty(cr, i);
                switch (tok) {
                    case 1: {
                        cr.haveCellWaveVector = true;
                    }
                    case 0: 
                    case 40: 
                    case 41: 
                    case 42: {
                        pt[2] = 0.0;
                        pt[1] = 0.0;
                        pt[0] = 0.0;
                    }
                    case 13: 
                    case 25: 
                    case 35: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 50: {
                        switch (tok) {
                            case 1: {
                                type_id = "W_";
                                break;
                            }
                            case 0: {
                                type_id = "F_";
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 42: {
                                fid = "?" + this.field;
                                pt[2] = 1.0;
                                continue block38;
                            }
                            case 43: 
                            case 44: 
                            case 45: {
                                axis = "*";
                                atomLabel = "*";
                            }
                            case 13: 
                            case 25: 
                            case 35: 
                            case 50: {
                                type_id = Character.toUpperCase(modulationFields[tok].charAt(11)) + "_";
                            }
                        }
                        type_id = type_id + this.field;
                        continue block38;
                    }
                    case 46: {
                        type_id = "J_O";
                        pt[2] = 1.0;
                        pt[0] = 1.0;
                        axis = "0";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 30: {
                        type_id = "O_0";
                        axis = "0";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 18: {
                        type_id = "D_S";
                        axis = "0";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 55: {
                        type_id = "M_T";
                        axis = "0";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 61: {
                        type_id = "D_L";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 65: {
                        type_id = "U_L";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 69: {
                        type_id = "O_L";
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 11: 
                    case 24: 
                    case 33: 
                    case 48: {
                        atomLabel = this.field;
                        continue block38;
                    }
                    case 12: 
                    case 49: 
                    case 62: {
                        axis = this.field;
                        if (this.modAxes == null || this.modAxes.indexOf(axis.toUpperCase()) >= 0) continue block38;
                        ignore = true;
                        continue block38;
                    }
                    case 34: 
                    case 66: {
                        axis = this.field.toUpperCase();
                        continue block38;
                    }
                    default: {
                        float f = cr.parseFloatStr(this.field);
                        switch (tok) {
                            case 64: 
                            case 68: 
                            case 71: {
                                pt[0] = f;
                                if (f == 0.0f) continue block38;
                                pt[2] = 0.0;
                                continue block38;
                            }
                            case 15: 
                            case 27: 
                            case 31: 
                            case 37: 
                            case 52: 
                            case 73: 
                            case 75: 
                            case 77: {
                                pt[2] = 0.0;
                            }
                            case 2: 
                            case 5: 
                            case 19: 
                            case 56: {
                                pt[0] = f;
                                continue block38;
                            }
                            case 8: {
                                type_id = type_id + "_coefs_";
                                pt = new double[this.modDim];
                                pt[0] = f;
                                continue block38;
                            }
                            case 16: 
                            case 28: 
                            case 38: 
                            case 53: {
                                pt[0] = f;
                                pt[2] = 1.0;
                                continue block38;
                            }
                            case 26: 
                            case 70: 
                            case 74: {
                                axis = "0";
                            }
                            case 3: 
                            case 6: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 20: 
                            case 29: 
                            case 32: 
                            case 36: 
                            case 39: 
                            case 47: 
                            case 51: 
                            case 54: 
                            case 57: 
                            case 63: 
                            case 67: 
                            case 72: 
                            case 76: {
                                pt[1] = f;
                                continue block38;
                            }
                            case 4: 
                            case 7: 
                            case 10: 
                            case 21: 
                            case 58: {
                                pt[2] = f;
                                continue block38;
                            }
                            case 22: 
                            case 59: {
                                c = f;
                                continue block38;
                            }
                            case 23: 
                            case 60: {
                                w = f;
                            }
                        }
                    }
                }
            }
            if (ignore || type_id == null || atomLabel != null && !atomLabel.equals("*") && cr.rejectAtomName(atomLabel)) continue;
            boolean ok = true;
            int nzero = pt.length;
            for (int j = 0; j < pt.length; ++j) {
                if (!Double.isNaN(pt[j]) && !(pt[j] > 1.0E100) && (pt[j] != 0.0 || --nzero != 0)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            switch (type_id.charAt(0)) {
                case 'C': 
                case 'D': 
                case 'J': 
                case 'M': 
                case 'O': 
                case 'U': {
                    if (atomLabel == null || axis == null) continue block37;
                    if (type_id.equals("D_S") || type_id.equals("M_T")) {
                        if (Double.isNaN(c) || Double.isNaN(w)) continue block37;
                        if (pt[0] != 0.0) {
                            this.addMod(type_id + "#x;" + atomLabel, fid, new double[]{c, w, pt[0]});
                        }
                        if (pt[1] != 0.0) {
                            this.addMod(type_id + "#y;" + atomLabel, fid, new double[]{c, w, pt[1]});
                        }
                        if (pt[2] == 0.0) continue block37;
                        this.addMod(type_id + "#z;" + atomLabel, fid, new double[]{c, w, pt[2]});
                        continue block37;
                    }
                    if (type_id.indexOf("_L") == 1) {
                        if (type_id.startsWith("U")) {
                            type_id = type_id + (int)pt[1];
                        } else {
                            axis = axis + (int)pt[1];
                        }
                    }
                    type_id = type_id + "#" + axis + ";" + atomLabel;
                }
            }
            this.addMod(type_id, fid, pt);
        }
        return 1;
    }

    private void addMod(String id, String fid, double[] params) {
        if (fid != null) {
            id = id + fid;
        }
        this.addModulation(null, id, params, -1);
    }

    private int processSubsystemLoopBlock() throws Exception {
        CifReader cr = (CifReader)this.cr;
        cr.parseLoopParameters(null);
        while (cr.parser.getData()) {
            this.fieldProperty(cr, 0);
            String id = this.field;
            this.addSubsystem(id, this.getSparseMatrix(cr, "_w_", 1, 3 + this.modDim));
        }
        return 1;
    }

    private Matrix getSparseMatrix(CifReader cr, String term, int i, int dim) {
        Matrix m = new Matrix((double[][])null, dim, dim);
        double[][] a = m.getArray();
        int n = cr.parser.getColumnCount();
        while (i < n) {
            String key;
            int p = this.fieldProperty(cr, i);
            if (p >= 0 && (key = cr.parser.getColumnName(p)).contains(term)) {
                String[] tokens = PT.split((String)key, (String)"_");
                int r = cr.parseIntStr(tokens[tokens.length - 2]);
                int c = cr.parseIntStr(tokens[tokens.length - 1]);
                if (r > 0 && c > 0) {
                    a[r - 1][c - 1] = cr.parseFloatStr(this.field);
                }
            }
            ++i;
        }
        return m;
    }

    private int fieldProperty(CifReader cr, int i) {
        this.field = (String)cr.parser.getColumnData(i);
        return this.field.length() > 0 && this.field.charAt(0) != '\u0000' ? cr.col2key[i] : -1;
    }
}

