/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

class ModelManager {
    private final Viewer vwr;
    ModelSet modelSet;
    String modelSetPathName;
    String fileName;

    ModelManager(Viewer vwr) {
        this.vwr = vwr;
    }

    void zap() {
        this.fileName = null;
        this.modelSetPathName = null;
        new ModelLoader(this.vwr, this.vwr.getZapName(), null, null, null, null);
    }

    void createModelSet(String fullPathName, String fileName, SB loadScript, Object atomSetCollection, BS bsNew, boolean isAppend) {
        String modelSetName = null;
        if (isAppend) {
            modelSetName = this.modelSet.modelSetName;
            if (modelSetName.equals("zapped")) {
                modelSetName = null;
            } else if (modelSetName.indexOf(" (modified)") < 0) {
                modelSetName = modelSetName + " (modified)";
            }
        } else if (atomSetCollection == null) {
            this.zap();
        } else {
            this.modelSetPathName = fullPathName;
            this.fileName = fileName;
        }
        if (atomSetCollection != null) {
            if (modelSetName == null) {
                modelSetName = this.vwr.getModelAdapter().getAtomSetCollectionName(atomSetCollection);
                if (modelSetName != null && (modelSetName = modelSetName.trim()).length() == 0) {
                    modelSetName = null;
                }
                if (modelSetName == null) {
                    modelSetName = ModelManager.reduceFilename(fileName);
                }
            }
            new ModelLoader(this.vwr, modelSetName, loadScript, atomSetCollection, isAppend ? this.modelSet : null, bsNew);
        }
        if (this.modelSet.ac == 0 && !this.modelSet.getMSInfoB("isPyMOL")) {
            this.zap();
        }
    }

    private static String reduceFilename(String fileName) {
        if (fileName == null) {
            return null;
        }
        int ichDot = fileName.indexOf(46);
        if (ichDot > 0) {
            fileName = fileName.substring(0, ichDot);
        }
        if (fileName.length() > 24) {
            fileName = fileName.substring(0, 20) + " ...";
        }
        return fileName;
    }

    String createAtomDataSet(Object atomSetCollection, int tokType) {
        return ModelLoader.createAtomDataSet(this.vwr, this.modelSet, tokType, atomSetCollection, this.vwr.bsA());
    }
}

