/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;

public final class MapPaintSettings
implements Preferences.PreferenceChangedListener {
    public static final MapPaintSettings INSTANCE = new MapPaintSettings();
    private boolean useRealWidth;
    private boolean showDirectionArrow;
    private boolean showOnewayArrow;
    private int defaultSegmentWidth;
    private boolean showOrderNumber;
    private boolean showOrderNumberOnSelectedWay;
    private boolean showHeadArrowOnly;
    private int showNamesDistance;
    private int useStrokesDistance;
    private int showIconsDistance;
    private int selectedNodeSize;
    private int connectionNodeSize;
    private int unselectedNodeSize;
    private int taggedNodeSize;
    private boolean fillSelectedNode;
    private boolean fillUnselectedNode;
    private boolean fillTaggedNode;
    private boolean fillConnectionNode;
    private boolean outlineOnly;
    private Color selectedColor;
    private Color relationSelectedColor;
    private Color highlightColor;
    private Color inactiveColor;
    private Color nodeColor;
    private Color taggedColor;
    private Color connectionColor;
    private Color taggedConnectionColor;

    private MapPaintSettings() {
        this.load();
        Main.pref.addPreferenceChangeListener(this);
    }

    private void load() {
        this.showDirectionArrow = Main.pref.getBoolean("draw.segment.direction", false);
        this.showOnewayArrow = Main.pref.getBoolean("draw.oneway", true);
        this.useRealWidth = Main.pref.getBoolean("mappaint.useRealWidth", false);
        this.defaultSegmentWidth = Main.pref.getInteger("mappaint.segment.default-width", 2);
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.nodeColor = PaintColors.NODE.get();
        this.taggedColor = PaintColors.TAGGED.get();
        this.connectionColor = PaintColors.CONNECTION.get();
        this.taggedConnectionColor = this.taggedColor != this.nodeColor ? this.taggedColor : this.connectionColor;
        this.showOrderNumber = Main.pref.getBoolean("draw.segment.order_number", false);
        this.showOrderNumberOnSelectedWay = Main.pref.getBoolean("draw.segment.order_number.on_selected", false);
        this.showHeadArrowOnly = Main.pref.getBoolean("draw.segment.head_only", false);
        this.showNamesDistance = Main.pref.getInteger("mappaint.shownames", 10000000);
        this.useStrokesDistance = Main.pref.getInteger("mappaint.strokes", 10000000);
        this.showIconsDistance = Main.pref.getInteger("mappaint.showicons", 10000000);
        this.selectedNodeSize = Main.pref.getInteger("mappaint.node.selected-size", 5);
        this.unselectedNodeSize = Main.pref.getInteger("mappaint.node.unselected-size", 3);
        this.connectionNodeSize = Main.pref.getInteger("mappaint.node.connection-size", 5);
        this.taggedNodeSize = Main.pref.getInteger("mappaint.node.tagged-size", 3);
        this.fillSelectedNode = Main.pref.getBoolean("mappaint.node.fill-selected", true);
        this.fillUnselectedNode = Main.pref.getBoolean("mappaint.node.fill-unselected", false);
        this.fillTaggedNode = Main.pref.getBoolean("mappaint.node.fill-tagged", true);
        this.fillConnectionNode = Main.pref.getBoolean("mappaint.node.fill-connection", false);
        this.outlineOnly = Main.pref.getBoolean("draw.data.area_outline_only", false);
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        this.load();
    }

    public boolean isUseRealWidth() {
        return this.useRealWidth;
    }

    public boolean isShowDirectionArrow() {
        return this.showDirectionArrow;
    }

    public boolean isShowOnewayArrow() {
        return this.showOnewayArrow;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getSelectedColor(int n) {
        return new Color(this.selectedColor.getRGB() & 0xFFFFFF | n << 24, true);
    }

    public int getDefaultSegmentWidth() {
        return this.defaultSegmentWidth;
    }

    public Color getRelationSelectedColor() {
        return this.relationSelectedColor;
    }

    public Color getRelationSelectedColor(int n) {
        return new Color(this.relationSelectedColor.getRGB() & 0xFFFFFF | n << 24, true);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public Color getTaggedColor() {
        return this.taggedColor;
    }

    public Color getConnectionColor() {
        return this.connectionColor;
    }

    public Color getTaggedConnectionColor() {
        return this.taggedConnectionColor;
    }

    public boolean isShowOrderNumber() {
        return this.showOrderNumber;
    }

    public boolean isShowOrderNumberOnSelectedWay() {
        return this.showOrderNumberOnSelectedWay;
    }

    public void setShowHeadArrowOnly(boolean bl) {
        this.showHeadArrowOnly = bl;
    }

    public boolean isShowHeadArrowOnly() {
        return this.showHeadArrowOnly;
    }

    public int getShowNamesDistance() {
        return this.showNamesDistance;
    }

    public int getUseStrokesDistance() {
        return this.useStrokesDistance;
    }

    public int getShowIconsDistance() {
        return this.showIconsDistance;
    }

    public int getSelectedNodeSize() {
        return this.selectedNodeSize;
    }

    public int getConnectionNodeSize() {
        return this.connectionNodeSize;
    }

    public int getUnselectedNodeSize() {
        return this.unselectedNodeSize;
    }

    public int getTaggedNodeSize() {
        return this.taggedNodeSize;
    }

    public boolean isFillSelectedNode() {
        return this.fillSelectedNode;
    }

    public boolean isFillUnselectedNode() {
        return this.fillUnselectedNode;
    }

    public boolean isFillConnectionNode() {
        return this.fillConnectionNode;
    }

    public boolean isFillTaggedNode() {
        return this.fillTaggedNode;
    }

    public boolean isOutlineOnly() {
        return this.outlineOnly;
    }

    public String toString() {
        return "MapPaintSettings [useRealWidth=" + this.useRealWidth + ", showDirectionArrow=" + this.showDirectionArrow + ", showOnewayArrow=" + this.showOnewayArrow + ", defaultSegmentWidth=" + this.defaultSegmentWidth + ", showOrderNumber=" + this.showOrderNumber + ", showHeadArrowOnly=" + this.showHeadArrowOnly + ", showNamesDistance=" + this.showNamesDistance + ", useStrokesDistance=" + this.useStrokesDistance + ", showIconsDistance=" + this.showIconsDistance + ", selectedNodeSize=" + this.selectedNodeSize + ", connectionNodeSize=" + this.connectionNodeSize + ", unselectedNodeSize=" + this.unselectedNodeSize + ", taggedNodeSize=" + this.taggedNodeSize + ", fillSelectedNode=" + this.fillSelectedNode + ", fillUnselectedNode=" + this.fillUnselectedNode + ", fillTaggedNode=" + this.fillTaggedNode + ", fillConnectionNode=" + this.fillConnectionNode + ", outlineOnly=" + this.outlineOnly + ", selectedColor=" + this.selectedColor + ", relationSelectedColor=" + this.relationSelectedColor + ", highlightColor=" + this.highlightColor + ", inactiveColor=" + this.inactiveColor + ", nodeColor=" + this.nodeColor + ", taggedColor=" + this.taggedColor + ", connectionColor=" + this.connectionColor + ", taggedConnectionColor=" + this.taggedConnectionColor + "]";
    }
}

