/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationRuntimeException;
import org.jetbrains.kotlin.js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PackageDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.ModuleWrapperTranslation;
import org.jetbrains.kotlin.js.translate.test.CommonUnitTester;
import org.jetbrains.kotlin.js.translate.test.JSRhinoUnitTester;
import org.jetbrains.kotlin.js.translate.test.JSTestGenerator;
import org.jetbrains.kotlin.js.translate.test.QUnitTester;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public final class Translation {
    private Translation() {
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            Translation.$$$reportNull$$$0(0);
        }
        PatternTranslator patternTranslator = PatternTranslator.newInstance(context);
        if (patternTranslator == null) {
            Translation.$$$reportNull$$$0(1);
        }
        return patternTranslator;
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(3);
        }
        JsNode jsNode = Translation.translateExpression(expression, context, context.dynamicContext().jsBlock());
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(4);
        }
        return jsNode;
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsExpression constantResult;
        KotlinType type2;
        JsExpression aliasForExpression;
        if (expression == null) {
            Translation.$$$reportNull$$$0(5);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(6);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(7);
        }
        if ((aliasForExpression = context.aliasingContext().getAliasForExpression(expression)) != null) {
            JsExpression jsExpression = aliasForExpression;
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(8);
            }
            return jsExpression;
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context.bindingContext());
        if (compileTimeValue != null && (type2 = context.bindingContext().getType(expression)) != null && (KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isInt(type2) && expression instanceof KtUnaryExpression) && (constantResult = Translation.translateConstant(compileTimeValue, expression, context)) != null) {
            JsExpression jsExpression = constantResult;
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(9);
            }
            return jsExpression;
        }
        TranslationContext innerContext = context.innerBlock();
        JsNode result2 = Translation.doTranslateExpression(expression, innerContext);
        context.moveVarsFrom(innerContext);
        block.getStatements().addAll(innerContext.dynamicContext().jsBlock().getStatements());
        JsNode jsNode = result2;
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(10);
        }
        return jsNode;
    }

    @Nullable
    public static JsExpression translateConstant(@NotNull CompileTimeConstant compileTimeValue, @NotNull KtExpression expression, @NotNull TranslationContext context) {
        KotlinType expectedType;
        ConstantValue constant;
        if (compileTimeValue == null) {
            Translation.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            Translation.$$$reportNull$$$0(12);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(13);
        }
        if ((constant = compileTimeValue.toConstantValue((expectedType = context.bindingContext().getType(expression)) != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE)) instanceof NullValue) {
            return JsLiteral.NULL;
        }
        Object value = constant.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return context.program().getNumberLiteral(((Number)value).intValue());
        }
        if (value instanceof Long) {
            return JsAstUtils.newLong((Long)value, context);
        }
        if (value instanceof Float) {
            float floatValue = ((Float)value).floatValue();
            double doubleValue = Float.isInfinite(floatValue) || Float.isNaN(floatValue) ? (double)floatValue : Double.parseDouble(Float.toString(floatValue));
            return context.program().getNumberLiteral(doubleValue);
        }
        if (value instanceof Number) {
            return context.program().getNumberLiteral(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return JsLiteral.getBoolean((Boolean)value);
        }
        if (value instanceof String) {
            return context.program().getStringLiteral((String)value);
        }
        if (value instanceof Character) {
            return context.program().getNumberLiteral(((Character)value).charValue());
        }
        return null;
    }

    @NotNull
    private static JsNode doTranslateExpression(KtExpression expression, TranslationContext context) {
        JsNode jsNode;
        try {
            jsNode = expression.accept(new ExpressionVisitor(), context);
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TranslationRuntimeException(expression, (Throwable)e);
        }
        catch (AssertionError e) {
            throw new TranslationRuntimeException(expression, (Throwable)((Object)e));
        }
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(14);
        }
        return jsNode;
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(15);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(16);
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression, context, context.dynamicContext().jsBlock());
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(17);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsNode jsNode;
        if (expression == null) {
            Translation.$$$reportNull$$$0(18);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(19);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(20);
        }
        if ((jsNode = Translation.translateExpression(expression, context, block)) instanceof JsExpression) {
            KotlinType expressionType = context.bindingContext().getType(expression);
            JsExpression jsExpression = Translation.unboxIfNeeded((JsExpression)jsNode, expressionType != null && KotlinBuiltIns.isCharOrNullableChar(expressionType));
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(21);
            }
            return jsExpression;
        }
        assert (jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext())) {
            TemporaryVariable result2 = context.declareTemporary(null);
            AssignToExpressionMutator saveResultToTemporaryMutator = new AssignToExpressionMutator(result2.reference());
            block.getStatements().add(LastExpressionMutator.mutateLastExpression(jsNode, saveResultToTemporaryMutator));
            JsNameRef jsNameRef = result2.reference();
            if (jsNameRef == null) {
                Translation.$$$reportNull$$$0(22);
            }
            return jsNameRef;
        }
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsNullLiteral jsNullLiteral = JsLiteral.NULL;
        if (jsNullLiteral == null) {
            Translation.$$$reportNull$$$0(23);
        }
        return jsNullLiteral;
    }

    @NotNull
    public static JsExpression unboxIfNeeded(@NotNull JsExpression expression, boolean charOrNullableChar) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(24);
        }
        if (charOrNullableChar && (expression instanceof JsInvocation || expression instanceof JsNameRef || expression instanceof JsArrayAccess)) {
            expression = JsAstUtils.boxedCharToChar(expression);
        }
        JsExpression jsExpression = expression;
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(25);
        }
        return jsExpression;
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(26);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(27);
        }
        JsStatement jsStatement = Translation.translateAsStatement(expression, context, context.dynamicContext().jsBlock());
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(28);
        }
        return jsStatement;
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression, @NotNull TranslationContext context, @NotNull JsBlock block) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(29);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(30);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(31);
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(Translation.translateExpression(expression, context, block));
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(32);
        }
        return jsStatement;
    }

    @NotNull
    public static JsStatement translateAsStatementAndMergeInBlockIfNeeded(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            Translation.$$$reportNull$$$0(33);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(34);
        }
        JsBlock block = new JsBlock();
        JsNode node = Translation.translateExpression(expression, context, block);
        JsStatement jsStatement = JsAstUtils.mergeStatementInBlockIfNeeded(JsAstUtils.convertToStatement(node), block);
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(35);
        }
        return jsStatement;
    }

    @NotNull
    public static TranslationContext generateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config) throws TranslationException {
        TranslationContext translationContext;
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(36);
        }
        if (files2 == null) {
            Translation.$$$reportNull$$$0(37);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(38);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(39);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(40);
        }
        try {
            translationContext = Translation.doGenerateAst(bindingTrace, files2, mainCallParameters, moduleDescriptor, config);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        if (translationContext == null) {
            Translation.$$$reportNull$$$0(41);
        }
        return translationContext;
    }

    @NotNull
    private static TranslationContext doGenerateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config) {
        JsStatement statement;
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(42);
        }
        if (files2 == null) {
            Translation.$$$reportNull$$$0(43);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(44);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(45);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(46);
        }
        StaticContext staticContext = StaticContext.generateStaticContext(bindingTrace, config, moduleDescriptor);
        JsProgram program = staticContext.getProgram();
        JsName rootPackageName = program.getRootScope().declareName(Namer.getRootPackageName());
        JsFunction rootFunction = staticContext.getRootFunction();
        JsBlock rootBlock = rootFunction.getBody();
        List<JsStatement> statements = rootBlock.getStatements();
        program.getScope().declareName("_");
        TranslationContext context = TranslationContext.rootContext(staticContext, rootFunction);
        PackageDeclarationTranslator.translateFiles(files2, context);
        staticContext.postProcess();
        statements.add(0, program.getStringLiteral("use strict").makeStmt());
        if (!staticContext.isBuiltinModule()) {
            Translation.defineModule(context, statements, config.getModuleId());
        }
        Translation.mayBeGenerateTests(files2, config, rootBlock, context);
        rootFunction.getParameters().add(new JsParameter(rootPackageName));
        ArrayList<StaticContext.ImportedModule> importedModuleList = new ArrayList<StaticContext.ImportedModule>();
        for (StaticContext.ImportedModule importedModule : staticContext.getImportedModules()) {
            rootFunction.getParameters().add(new JsParameter(importedModule.getInternalName()));
            importedModuleList.add(importedModule);
        }
        if (mainCallParameters.shouldBeGenerated() && (statement = Translation.generateCallToMain(context, files2, mainCallParameters.arguments())) != null) {
            statements.add(statement);
        }
        statements.add(new JsReturn(rootPackageName.makeRef()));
        JsBlock block = program.getGlobalBlock();
        block.getStatements().addAll(ModuleWrapperTranslation.wrapIfNecessary(config.getModuleId(), rootFunction, importedModuleList, program, config.getModuleKind()));
        TranslationContext translationContext = context;
        if (translationContext == null) {
            Translation.$$$reportNull$$$0(47);
        }
        return translationContext;
    }

    private static void defineModule(@NotNull TranslationContext context, @NotNull List<JsStatement> statements, @NotNull String moduleId) {
        JsName rootPackageName;
        if (context == null) {
            Translation.$$$reportNull$$$0(48);
        }
        if (statements == null) {
            Translation.$$$reportNull$$$0(49);
        }
        if (moduleId == null) {
            Translation.$$$reportNull$$$0(50);
        }
        if ((rootPackageName = context.scope().findName(Namer.getRootPackageName())) != null) {
            statements.add(new JsInvocation((JsExpression)context.namer().kotlin("defineModule"), context.program().getStringLiteral(moduleId), rootPackageName.makeRef()).makeStmt());
        }
    }

    private static void mayBeGenerateTests(@NotNull Collection<KtFile> files2, @NotNull JsConfig config, @NotNull JsBlock rootBlock, @NotNull TranslationContext context) {
        if (files2 == null) {
            Translation.$$$reportNull$$$0(51);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(52);
        }
        if (rootBlock == null) {
            Translation.$$$reportNull$$$0(53);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(54);
        }
        CommonUnitTester tester = config.getConfiguration().getBoolean(JSConfigurationKeys.UNIT_TEST_CONFIG) ? new JSRhinoUnitTester() : new QUnitTester();
        tester.initialize(context, rootBlock);
        JSTestGenerator.generateTestCalls(context, files2, tester);
        tester.deinitialize();
    }

    @Nullable
    private static JsStatement generateCallToMain(@NotNull TranslationContext context, @NotNull Collection<KtFile> files2, @NotNull List<String> arguments2) {
        MainFunctionDetector mainFunctionDetector;
        KtNamedFunction mainFunction;
        if (context == null) {
            Translation.$$$reportNull$$$0(55);
        }
        if (files2 == null) {
            Translation.$$$reportNull$$$0(56);
        }
        if (arguments2 == null) {
            Translation.$$$reportNull$$$0(57);
        }
        if ((mainFunction = (mainFunctionDetector = new MainFunctionDetector(context.bindingContext())).getMainFunction(files2)) == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), mainFunction);
        JsArrayLiteral argument = new JsArrayLiteral(JsAstUtils.toStringLiteralList(arguments2, context.program()));
        return CallTranslator.INSTANCE.buildCall(context, functionDescriptor, Collections.singletonList(argument), null).makeStmt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 24: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileTimeValue";
                break;
            }
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 37: 
            case 43: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 40: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "patternTranslator";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doTranslateExpression";
                break;
            }
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsExpression";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxIfNeeded";
                break;
            }
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAst";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateAst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patternTranslator";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translateExpression";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "translateConstant";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "translateAsExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unboxIfNeeded";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateAst";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateAst";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "defineModule";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "mayBeGenerateTests";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateCallToMain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

