/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.VoidParameter;

public class IntParameter
extends VoidParameter {
    protected int value;
    protected int defValue;
    protected int minValue;
    protected int maxValue;

    public IntParameter(String string, String string2, int n, int n2, int n3, Configuration.ConfigurationObject configurationObject) {
        super(string, string2, configurationObject);
        this.value = n;
        this.defValue = n;
        this.minValue = n2;
        this.maxValue = n3;
    }

    public IntParameter(String string, String string2, int n) {
        this(string, string2, n, Integer.MIN_VALUE, Integer.MAX_VALUE, Configuration.ConfigurationObject.ConfGlobal);
    }

    @Override
    public boolean setParam(String string) {
        if (this.immutable) {
            return true;
        }
        vlog.debug("set " + this.getName() + "(Int) to " + string);
        try {
            int n = Integer.parseInt(string);
            if (n < this.minValue || n > this.maxValue) {
                return false;
            }
            this.value = n;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(numberFormatException.toString());
        }
    }

    public boolean setParam(int n) {
        if (this.immutable) {
            return true;
        }
        vlog.debug("set " + this.getName() + "(Int) to " + n);
        if (n < this.minValue || n > this.maxValue) {
            return false;
        }
        this.value = n;
        return true;
    }

    @Override
    public String getDefaultStr() {
        return Integer.toString(this.defValue);
    }

    @Override
    public String getValueStr() {
        return Integer.toString(this.value);
    }

    public int getValue() {
        return this.value;
    }
}

