/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantODataIdQuery
implements Variant {
    private static final Logger log = Logger.getLogger(VariantODataIdQuery.class);
    public static final String RESOURCE_ID_PREFIX = "__ID__";
    private ResourceParameter resourceParameter = null;
    private static final Pattern patternResourceIdentifierUnquoted = Pattern.compile("/(\\w*)\\(([\\w']*)\\)");
    private static final Pattern patternResourceMultipleIdentifier = Pattern.compile("/\\w*\\((.*)\\)");
    private static final Pattern patternResourceMultipleIdentifierDetail = Pattern.compile("(\\w*)=([\\w']*)");
    private String beforeMultipleIDs = null;
    private String afterMultipleIDs = null;
    private List<NameValuePair> listParams = null;

    @Override
    public void setMessage(HttpMessage httpMessage) {
        URI uRI = httpMessage.getRequestHeader().getURI();
        this.parse(uRI);
    }

    private void parse(URI uRI) {
        try {
            this.resourceParameter = null;
            this.beforeMultipleIDs = null;
            this.afterMultipleIDs = null;
            this.listParams = null;
            String string = uRI.getPath();
            if (string != null) {
                String string2 = "";
                Matcher matcher = patternResourceIdentifierUnquoted.matcher(string);
                if (matcher.find()) {
                    string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    String string4 = string2 + "(" + string3 + ")";
                    int n = string.indexOf(string4);
                    int n2 = n + string4.length();
                    String string5 = string.substring(0, n);
                    String string6 = string.substring(n2);
                    this.resourceParameter = new ResourceParameter(string2, string3, string5, string6);
                } else {
                    matcher = patternResourceMultipleIdentifier.matcher(string);
                    if (matcher.find()) {
                        String string7 = matcher.group(1);
                        int n = string.indexOf(string7);
                        int n3 = n + string7.length();
                        this.beforeMultipleIDs = string.substring(0, n);
                        this.afterMultipleIDs = string.substring(n3);
                        this.listParams = new ArrayList<NameValuePair>();
                        matcher = patternResourceMultipleIdentifierDetail.matcher(string7);
                        int n4 = 1;
                        while (matcher.find()) {
                            String string8 = matcher.group(1);
                            String string9 = matcher.group(2);
                            NameValuePair nameValuePair = new NameValuePair(1, string8, string9, n4++);
                            this.listParams.add(nameValuePair);
                        }
                    }
                }
            }
        }
        catch (URIException uRIException) {
            log.error((Object)(uRIException.getMessage() + uRI), (Throwable)uRIException);
        }
    }

    public Vector<NameValuePair> getParamList() {
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        if (this.resourceParameter != null) {
            vector.add(new NameValuePair(1, this.resourceParameter.getParameterName(), this.resourceParameter.getValue(), 1));
        }
        if (this.listParams != null) {
            vector.addAll(this.listParams);
        }
        return vector;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        if (this.resourceParameter != null && this.resourceParameter.getParameterName().equals(string)) {
            String string3 = string2;
            String string4 = this.resourceParameter.getModifiedPath(string2);
            try {
                httpMessage.getRequestHeader().getURI().setPath(string4);
            }
            catch (URIException uRIException) {
                throw new RuntimeException("Error with uri " + string4, uRIException);
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException("Error with uri " + string4, nullPointerException);
            }
            return string3;
        }
        if (this.listParams != null) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder.append(this.beforeMultipleIDs);
            boolean bl = true;
            for (NameValuePair object2 : this.listParams) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append(object2.getName()).append("=");
                if (object2.getName().equals(string)) {
                    stringBuilder2.append(string2);
                    continue;
                }
                stringBuilder2.append(object2.getValue());
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(this.afterMultipleIDs);
            String string5 = stringBuilder.toString();
            String string3 = stringBuilder2.toString();
            try {
                httpMessage.getRequestHeader().getURI().setPath(string5);
            }
            catch (NullPointerException | URIException throwable) {
                throw new RuntimeException("Error with uri " + (String)string5, throwable);
            }
            return string3;
        }
        return "";
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2);
    }

    static class ResourceParameter {
        private String parameterName;
        private String resourceName;
        private String originalValue;
        private String pathBeforeParameter;
        private String pathAfterParamter;

        public ResourceParameter(String string, String string2, String string3, String string4) {
            this.resourceName = string;
            this.parameterName = VariantODataIdQuery.RESOURCE_ID_PREFIX + string;
            this.originalValue = string2;
            this.pathBeforeParameter = string3;
            this.pathAfterParamter = string4;
        }

        public String getValue() {
            return this.originalValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getModifiedPath(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.pathBeforeParameter).append(this.resourceName).append("(").append(string).append(")").append(this.pathAfterParamter);
            return stringBuilder.toString();
        }
    }
}

