/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigTableModel;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class DialogEditRuleConfig
extends StandardFieldsDialog {
    private static final String FIELD_KEY = "ruleconfig.dialog.label.key";
    private static final String FIELD_VALUE = "ruleconfig.dialog.label.value";
    private static final String FIELD_DEFAULT = "ruleconfig.dialog.label.default";
    private static final String FIELD_DESC = "ruleconfig.dialog.label.desc";
    private static final long serialVersionUID = 1L;
    private JButton resetButton;
    private RuleConfig rc;
    private RuleConfigTableModel model;

    public DialogEditRuleConfig(Window window) {
        super(window, "ruleconfig.dialog.title", new Dimension(400, 300), true);
    }

    public void init(RuleConfig ruleConfig, RuleConfigTableModel ruleConfigTableModel) {
        this.rc = ruleConfig;
        this.model = ruleConfigTableModel;
        this.removeAllFields();
        this.addReadOnlyField(FIELD_KEY, ruleConfig.getKey(), false);
        this.addReadOnlyField(FIELD_DEFAULT, ruleConfig.getDefaultValue(), false);
        this.addTextField(FIELD_VALUE, ruleConfig.getValue());
        String string = "";
        if (Constant.messages.containsKey(ruleConfig.getKey())) {
            string = Constant.messages.getString(ruleConfig.getKey());
        }
        this.addMultilineField(FIELD_DESC, string);
        ZapTextArea zapTextArea = (ZapTextArea)this.getField(FIELD_DESC);
        zapTextArea.setEditable(false);
        zapTextArea.setWrapStyleWord(true);
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton(Constant.messages.getString("ruleconfig.dialog.button.reset"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogEditRuleConfig.this.setFieldValue(DialogEditRuleConfig.FIELD_VALUE, DialogEditRuleConfig.this.rc.getDefaultValue());
                }
            });
        }
        return this.resetButton;
    }

    @Override
    public JButton[] getExtraButtons() {
        return new JButton[]{this.getResetButton()};
    }

    @Override
    public void save() {
        if (!this.getStringValue(FIELD_VALUE).equals(this.rc.getValue())) {
            this.model.setRuleConfigValue(this.rc.getKey(), this.getStringValue(FIELD_VALUE));
        }
    }

    @Override
    public String validateFields() {
        return null;
    }
}

