/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskInputsListener taskInputsListener;
    private final TaskExecuter executer;

    public SkipEmptySourceFilesTaskExecuter(TaskInputsListener taskInputsListener, TaskExecuter executer) {
        this.taskInputsListener = taskInputsListener;
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        FileCollection sourceFiles = task.getInputs().getSourceFiles();
        if (task.getInputs().getHasSourceFiles() && sourceFiles.isEmpty()) {
            TaskArtifactState taskArtifactState = context.getTaskArtifactState();
            FileCollection outputFiles = taskArtifactState.getExecutionHistory().getOutputFiles();
            if (outputFiles == null) {
                state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                LOGGER.info("Skipping {} as it has no source files and no history of previous output files.", (Object)task);
            } else if (outputFiles.isEmpty()) {
                state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)task);
            } else {
                Set<File> outputFileSet = outputFiles.getFiles();
                boolean deletedFiles = false;
                boolean debugEnabled = LOGGER.isDebugEnabled();
                for (File file : outputFileSet) {
                    if (!file.isFile()) continue;
                    if (file.delete()) {
                        if (debugEnabled) {
                            LOGGER.debug("Deleted stale output file '{}'.", (Object)file.getAbsolutePath());
                        }
                    } else {
                        state.setOutcome(new GradleException(String.format("Could not delete file: '%s'.", file.getAbsolutePath())));
                        return;
                    }
                    deletedFiles = true;
                }
                if (deletedFiles) {
                    LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)task);
                    state.setOutcome(TaskExecutionOutcome.EXECUTED);
                } else {
                    state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                }
            }
            this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)sourceFiles));
            return;
        }
        this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)task.getInputs().getFiles()));
        this.executer.execute(task, state, context);
    }
}

