/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J!\u0010%\u001a\u0002H)\"\u0004\b\u0000\u0010)2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0*H\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010.\u001a\u00020/H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/ConditionalJumpInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/AbstractJumpInstruction;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "onTrue", "", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "conditionValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtElement;ZLorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "_nextOnFalse", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "_nextOnTrue", "getConditionValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "inputValues", "", "getInputValues", "()Ljava/util/List;", "nextInstructions", "", "getNextInstructions", "()Ljava/util/Collection;", "value", "nextOnFalse", "getNextOnFalse", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "setNextOnFalse", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;)V", "nextOnTrue", "getNextOnTrue", "setNextOnTrue", "getOnTrue", "()Z", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "createCopy", "newLabel", "toString", "", "kotlin-compiler"})
public final class ConditionalJumpInstruction
extends AbstractJumpInstruction {
    private Instruction _nextOnTrue;
    private Instruction _nextOnFalse;
    private final boolean onTrue;
    @Nullable
    private final PseudoValue conditionValue;

    @NotNull
    public final Instruction getNextOnTrue() {
        Instruction instruction = this._nextOnTrue;
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        return instruction;
    }

    public final void setNextOnTrue(@NotNull Instruction value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this._nextOnTrue = this.outgoingEdgeTo(value);
    }

    @NotNull
    public final Instruction getNextOnFalse() {
        Instruction instruction = this._nextOnFalse;
        if (instruction == null) {
            Intrinsics.throwNpe();
        }
        return instruction;
    }

    public final void setNextOnFalse(@NotNull Instruction value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this._nextOnFalse = this.outgoingEdgeTo(value);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        List<Instruction> list2 = Arrays.asList(this.getNextOnFalse(), this.getNextOnTrue());
        Intrinsics.checkExpressionValueIsNotNull(list2, "Arrays.asList(nextOnFalse, nextOnTrue)");
        return list2;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        return CollectionsKt.emptyOrSingletonList(this.conditionValue);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        visitor2.visitConditionalJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitConditionalJump(this);
    }

    @NotNull
    public String toString() {
        Object object;
        String instr;
        block3: {
            block2: {
                PseudoValue pseudoValue;
                instr = this.onTrue ? "jt" : "jf";
                object = this.conditionValue;
                if (object == null) break block2;
                PseudoValue it = pseudoValue = object;
                object = "|" + it;
                if (object != null) break block3;
            }
            object = "";
        }
        Object inValue = object;
        return instr + "(" + this.getTargetLabel().getName() + (String)inValue + ")";
    }

    @Override
    @NotNull
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull BlockScope blockScope) {
        Intrinsics.checkParameterIsNotNull(newLabel, "newLabel");
        Intrinsics.checkParameterIsNotNull(blockScope, "blockScope");
        return new ConditionalJumpInstruction(this.getElement(), this.onTrue, blockScope, newLabel, this.conditionValue);
    }

    public final boolean getOnTrue() {
        return this.onTrue;
    }

    @Nullable
    public final PseudoValue getConditionValue() {
        return this.conditionValue;
    }

    public ConditionalJumpInstruction(@NotNull KtElement element, boolean onTrue, @NotNull BlockScope blockScope, @NotNull Label targetLabel, @Nullable PseudoValue conditionValue) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(blockScope, "blockScope");
        Intrinsics.checkParameterIsNotNull(targetLabel, "targetLabel");
        super(element, targetLabel, blockScope);
        this.onTrue = onTrue;
        this.conditionValue = conditionValue;
    }
}

