/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.navigation.ColoredItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProvider;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.CodeInsightColors;
import org.jetbrains.kotlin.com.intellij.openapi.editor.colors.TextAttributesKey;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.presentation.java.ClassPresentationUtil;

public class ClassPresentationProvider
implements ItemPresentationProvider<PsiClass> {
    @Override
    public ItemPresentation getPresentation(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/ClassPresentationProvider", "getPresentation"));
        }
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            public String getLocationString() {
                PsiFile file2 = psiClass.getContainingFile();
                if (file2 instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file2;
                    String packageName = classOwner.getPackageName();
                    if (packageName.isEmpty()) {
                        return null;
                    }
                    return "(" + packageName + ")";
                }
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiClass.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiClass.getIcon(3);
            }
        };
    }
}

