/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(@NotNull TextRange o1, @NotNull TextRange o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils$1", "compare"));
            }
            if (o1.getStartOffset() != o2.getStartOffset()) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
            return o1.getEndOffset() - o2.getEndOffset();
        }
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = DiagnosticUtils.getClosestPsiElement((ASTNode)((Object)descriptor2));
        }
        if (element != null) {
            return DiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    public static String atLocation(KtExpression expression) {
        return DiagnosticUtils.atLocation(expression.getNode());
    }

    public static String atLocation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return DiagnosticUtils.atLocation(element.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        int startOffset = node.getStartOffset();
        PsiElement element = DiagnosticUtils.getClosestPsiElement(node);
        if (element != null && element.isValid()) {
            return DiagnosticUtils.atLocation(element.getContainingFile(), element.getTextRange());
        }
        return "' at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @Nullable
    public static PsiElement getClosestPsiElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getClosestPsiElement"));
        }
        while (node.getPsi() == null) {
            node = node.getTreeParent();
        }
        return node.getPsi();
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getContainingFile"));
        }
        PsiElement closestPsiElement = DiagnosticUtils.getClosestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        PsiFile psiFile = closestPsiElement.getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getContainingFile"));
        }
        return psiFile;
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        Document document = file2.getViewProvider().getDocument();
        String string = DiagnosticUtils.atLocation(file2, textRange, document);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return string;
    }

    @NotNull
    public static String atLocation(PsiFile file2, TextRange textRange, Document document) {
        int offset2 = textRange.getStartOffset();
        VirtualFile virtualFile = file2.getVirtualFile();
        String pathSuffix = " in " + (virtualFile == null ? file2.getName() : virtualFile.getPath());
        String string = DiagnosticUtils.offsetToLineAndColumn(document, offset2).toString() + pathSuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "atLocation"));
        }
        return string;
    }

    @NotNull
    public static LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getLineAndColumn"));
        }
        PsiFile file2 = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            LineAndColumn lineAndColumn = LineAndColumn.NONE;
            if (lineAndColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getLineAndColumn"));
            }
            return lineAndColumn;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(file2, firstRange);
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getLineAndColumn"));
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn getLineAndColumnInPsiFile(PsiFile file2, TextRange range) {
        Document document = file2.getViewProvider().getDocument();
        LineAndColumn lineAndColumn = DiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "getLineAndColumnInPsiFile"));
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(@Nullable Document document, int offset2) {
        if (document == null) {
            LineAndColumn lineAndColumn = new LineAndColumn(-1, offset2, null);
            if (lineAndColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "offsetToLineAndColumn"));
            }
            return lineAndColumn;
        }
        int lineNumber = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset2 - lineStartOffset;
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        LineAndColumn lineAndColumn = new LineAndColumn(lineNumber + 1, column + 1, ((Object)lineContent).toString());
        if (lineAndColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "offsetToLineAndColumn"));
        }
        return lineAndColumn;
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges2) {
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "firstRange"));
        }
        TextRange textRange = Collections.min(ranges2, TEXT_RANGE_COMPARATOR);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "firstRange"));
        }
        return textRange;
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "sortedDiagnostics"));
        }
        Comparator<Diagnostic> diagnosticComparator = new Comparator<Diagnostic>(){

            @Override
            public int compare(@NotNull Diagnostic d1, @NotNull Diagnostic d2) {
                TextRange range2;
                String path2;
                if (d1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d1", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils$2", "compare"));
                }
                if (d2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d2", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils$2", "compare"));
                }
                String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
                if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                    return path1.compareTo(path2);
                }
                TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
                if (!range1.equals(range2 = DiagnosticUtils.firstRange(d2.getTextRanges()))) {
                    return TEXT_RANGE_COMPARATOR.compare(range1, range2);
                }
                return d1.getFactory().getName().compareTo(d2.getFactory().getName());
            }
        };
        ArrayList<Diagnostic> result2 = Lists.newArrayList(diagnostics);
        Collections.sort(result2, diagnosticComparator);
        ArrayList<Diagnostic> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/DiagnosticUtils", "sortedDiagnostics"));
        }
        return arrayList;
    }

    public static boolean hasError(Diagnostics diagnostics) {
        for (Diagnostic diagnostic : diagnostics.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1, null);
        private final int line;
        private final int column;
        private final String lineContent;

        public LineAndColumn(int line, int column, @Nullable String lineContent) {
            this.line = line;
            this.column = column;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        @Nullable
        public String getLineContent() {
            return this.lineContent;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

