#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: aeson
version: 1.1.2.0
id: aeson-1.1.2.0-H9d5B7Pgw9tIbOpl8Ot3sY
key: aeson-1.1.2.0-H9d5B7Pgw9tIbOpl8Ot3sY
license: BSD3
copyright: (c) 2011-2016 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Adam Bergmark <adam@bergmark.nl>
stability: experimental
homepage: https://github.com/bos/aeson
synopsis: Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.
    .
    To get started, see the documentation for the @Data.Aeson@ module
    below.
    .
    Parsing performance on a late 2013 MacBook Pro (2.6GHz Core i7),
    running 64-bit GHC 7.10.1, for mostly-English tweets from Twitter'\''s
    JSON search API:
    .
    * 6.4 KB payloads, English: 7570 msg\/sec (47.6 MB\/sec)
    .
    * 14.6 KB payloads, Japanese: 3261 msg\/sec (46.6 MB\/sec)
    .
    Encoding performance on the same machine and data:
    .
    * 6.4 KB payloads, English: 22738 msg\/sec (142.9 MB\/sec)
    .
    * 14.6 KB payloads, Japanese: 15911 msg\/sec (227.4 MB\/sec)
    .
    (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
exposed-modules:
    Data.Aeson Data.Aeson.Encoding Data.Aeson.Parser Data.Aeson.Text
    Data.Aeson.Types Data.Aeson.TH Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Encode
hidden-modules: Data.Aeson.Encoding.Builder
                Data.Aeson.Internal.Functions Data.Aeson.Parser.Internal
                Data.Aeson.Parser.Unescape Data.Aeson.Parser.Time
                Data.Aeson.Types.FromJSON Data.Aeson.Types.Generic
                Data.Aeson.Types.ToJSON Data.Aeson.Types.Class
                Data.Aeson.Types.Internal Data.Aeson.Parser.UnescapeFFI
abi: c23feef60967d79fc7abcac0ad831376
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/aeson-1.1.2.0
library-dirs: /usr/lib/ghc-8.0.2/site-local/aeson-1.1.2.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/aeson-1.1.2.0
hs-libraries: HSaeson-1.1.2.0-H9d5B7Pgw9tIbOpl8Ot3sY
depends:
    attoparsec-0.13.1.0-ETec0FJZJHgARrgZXhaej9 base-4.9.1.0
    base-compat-0.9.3-KeJp8zYMpcS9WibvTcxU22 bytestring-0.10.8.1
    containers-0.5.7.1 deepseq-1.4.2.0
    dlist-0.8.0.2-6Wnps4GD7EFnRucVzXIFD ghc-prim-0.5.0.0
    hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr
    scientific-0.3.4.15-Is44CvKqXBF5ugVqyS94hI
    tagged-0.8.5-DG0qxw3gXxx4NfDcDx4Iai template-haskell-2.11.1.0
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    time-locale-compat-0.1.1.3-KZ1jqNx8uhlHjmuPPj6V1Y
    unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    uuid-types-1.0.3-I7xNINqiSgy8XiSgWjW585
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
haddock-interfaces: /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html: /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
