#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: generic-deriving
version: 1.11.2
id: generic-deriving-1.11.2-4IqNNV2tInHIhujA71Vlml
key: generic-deriving-1.11.2-4IqNNV2tInHIhujA71Vlml
license: BSD3
copyright: 2011-2013 Universiteit Utrecht, University of Oxford
maintainer: generics@haskell.org
stability: experimental
homepage: https://github.com/dreixel/generic-deriving
synopsis: Generic programming library for generalised deriving.
description:
    This package provides functionality for generalising the deriving mechanism
    in Haskell to arbitrary classes. It was first described in the paper:
    .
    *  /A generic deriving mechanism for Haskell/.
    Jose Pedro Magalhaes, Atze Dijkstra, Johan Jeuring, and Andres Loeh.
    Haskell'\''10.
    .
    The current implementation integrates with the new GHC Generics. See
    <http://www.haskell.org/haskellwiki/GHC.Generics> for more information.
    Template Haskell code is provided for supporting older GHCs.
category: Generics
author: José Pedro Magalhães
exposed: True
exposed-modules:
    Generics.Deriving Generics.Deriving.Base
    Generics.Deriving.Instances Generics.Deriving.Copoint
    Generics.Deriving.ConNames Generics.Deriving.Enum
    Generics.Deriving.Eq Generics.Deriving.Foldable
    Generics.Deriving.Functor Generics.Deriving.Monoid
    Generics.Deriving.Semigroup Generics.Deriving.Show
    Generics.Deriving.Traversable Generics.Deriving.Uniplate
    Generics.Deriving.TH
hidden-modules: Generics.Deriving.Base.Internal
                Generics.Deriving.TH.Internal Paths_generic_deriving
                Generics.Deriving.TH.Post4_9
abi: a77285fb36d0c86cf14df104ffc810ca
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/generic-deriving-1.11.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/generic-deriving-1.11.2
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/generic-deriving-1.11.2
hs-libraries: HSgeneric-deriving-1.11.2-4IqNNV2tInHIhujA71Vlml
depends:
    base-4.9.1.0 containers-0.5.7.1 ghc-prim-0.5.0.0
    template-haskell-2.11.1.0
haddock-interfaces: /usr/share/doc/haskell-generic-deriving/html/generic-deriving.haddock
haddock-html: /usr/share/doc/haskell-generic-deriving/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
