#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-lib
version: 1.2
id: hledger-lib-1.2-DzG8YyYq6sICyb0Ier8sSX
key: hledger-lib-1.2-DzG8YyYq6sICyb0Ier8sSX
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Core data types, parsers and functionality for the hledger accounting tools
description:
    This is a reusable library containing hledger'\''s core functionality.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
author: Simon Michael <simon@joyful.com>
exposed: True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Commodity Hledger.Data.Dates
    Hledger.Data.Journal Hledger.Data.Ledger Hledger.Data.MarketPrice
    Hledger.Data.Period Hledger.Data.StringFormat Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.Timeclock
    Hledger.Data.Transaction Hledger.Data.AutoTransaction
    Hledger.Data.Types Hledger.Query Hledger.Read Hledger.Read.Common
    Hledger.Read.CsvReader Hledger.Read.JournalReader
    Hledger.Read.TimedotReader Hledger.Read.TimeclockReader
    Hledger.Reports Hledger.Reports.ReportOptions
    Hledger.Reports.BalanceHistoryReport Hledger.Reports.BalanceReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReports
    Hledger.Reports.PostingsReport Hledger.Reports.TransactionsReports
    Hledger.Utils Hledger.Utils.Debug Hledger.Utils.Parse
    Hledger.Utils.Regex Hledger.Utils.String Hledger.Utils.Test
    Hledger.Utils.Text Hledger.Utils.Tree Hledger.Utils.UTF8IOCompat
hidden-modules: Paths_hledger_lib
abi: 92a46558349b17cd9838112e66a7b9b5
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-lib-1.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-lib-1.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/hledger-lib-1.2
hs-libraries: HShledger-lib-1.2-DzG8YyYq6sICyb0Ier8sSX
depends:
    Decimal-0.4.2-HO1LSU7IWQc9gAaO60ocX0
    HUnit-1.6.0.0-60ZLMGxowdyCquCGGOoE3I array-0.5.1.1 base-4.9.1.0
    base-compat-0.9.3-KeJp8zYMpcS9WibvTcxU22
    blaze-markup-0.7.1.1-Amik95gvtJH76XeEGEdOV0 bytestring-0.10.8.1
    cmdargs-0.10.17-gTr0lzwrHbBcQQ47pfTGo containers-0.5.7.1
    csv-0.1.2-IUnXEueXED9ELeVORJac7R
    data-default-0.7.1.1-CyM3k1XLfwb41mPgt03rCT deepseq-1.4.2.0
    directory-1.3.0.0 filepath-1.4.1.1
    hashtables-1.2.1.1-1Rx9CynCW0SHv3JyARxq31
    megaparsec-5.3.1-EuBhiFLipVpCArDKS8Wu9b
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    old-time-1.1.0.3-EZzkBJ4NQxX4hHavrKxgaT
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR
    pretty-show-1.6.13-LSgpbeg7Zcd2id7s8ra4bM
    regex-tdfa-1.2.2-JFeutuWiS2vGBM4qXQlqio
    safe-0.3.15-2Yd45VWFfdcKqKyispOifY
    semigroups-0.18.3-5xL9BgkWQsCGwo6YahyMCM
    split-0.2.3.2-CJl40zTyCIV16Pr60nb7CT
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0 uglymemo-0.1.0.1-DfyiVfAgNISEaPTZDn8jSB
    utf8-string-1.0.1.1-1DpjxLeTvGg7ttZZojxJR5
haddock-interfaces: /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html: /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
