#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.9.2
id: QuickCheck-2.9.2-8nJqNls0Q836oDXpGGg3LD
key: QuickCheck-2.9.2-8nJqNls0Q836oDXpGGg3LD
license: BSD3
copyright: 2000-2016 Koen Claessen, 2006-2008 Björn Bringert, 2009-2016 Nick Smallbone
maintainer: QuickCheck developers <quickcheck@projects.haskell.org>
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    .
    The programmer provides a specification of the program, in
    the form of properties which functions should satisfy, and
    QuickCheck then tests that the properties hold in a large number
    of randomly generated cases.
    .
    Specifications are expressed in
    Haskell, using combinators defined in the QuickCheck library.
    QuickCheck provides combinators to define properties, observe
    the distribution of test data, and define test
    data generators.
    .
    You can find a (slightly out-of-date but useful) manual at
    <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html>.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
exposed-modules:
    Test.QuickCheck Test.QuickCheck.Arbitrary Test.QuickCheck.Gen
    Test.QuickCheck.Gen.Unsafe Test.QuickCheck.Monadic
    Test.QuickCheck.Modifiers Test.QuickCheck.Property
    Test.QuickCheck.Test Test.QuickCheck.Text Test.QuickCheck.Poly
    Test.QuickCheck.State Test.QuickCheck.Random
    Test.QuickCheck.Exception Test.QuickCheck.Function
    Test.QuickCheck.All
abi: e4bc6615c47522c350c719b54f1f50b8
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/QuickCheck-2.9.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/QuickCheck-2.9.2
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/QuickCheck-2.9.2
hs-libraries: HSQuickCheck-2.9.2-8nJqNls0Q836oDXpGGg3LD
depends:
    base-4.9.1.0 containers-0.5.7.1 random-1.1-9tceXaeYIMZ4JrKq20Egog
    template-haskell-2.11.1.0 tf-random-0.5-CJZw1ZWS5MOJlR60HqKEZL
    transformers-0.5.2.0
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
