#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: texmath
version: 0.9.4
id: texmath-0.9.4-5gHgQZ6t6rX3Vweup3LHkD
key: texmath-0.9.4-5gHgQZ6t6rX3Vweup3LHkD
license: GPL
maintainer: jgm@berkeley.edu
stability: Experimental
homepage: http://github.com/jgm/texmath
synopsis: Conversion between formats used to represent mathematics.
description:
    The texmath library provides functions to read and
    write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).
    Support is also included for converting math formats
    to Gnu eqn and to pandoc'\''s native format (allowing
    conversion, via pandoc, to a variety of different
    markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX
    macros.  (See <http://johnmacfarlane.net/texmath here>
    for a live demo of bidirectional conversion between LaTeX
    and MathML.)
    .
    The package also includes several utility modules which
    may be useful for anyone looking to manipulate either
    TeX math or MathML.  For example, a copy of the MathML
    operator dictionary is included.
    .
    Use the @executable@ flag to install a standalone
    executable, @texmath@, that by default reads a LaTeX
    formula from @stdin@ and writes MathML to @stdout@.
    With flags all the functionality exposed by
    '\''Text.TeXMath'\'' can be accessed through this executable.
    (Use the @--help@ flag for a description of all
    functionality)
    .
    The @texmath@ executable can also be used as a CGI
    script, when renamed as @texmath-cgi@.
    It will expect query parameters for @from@, @to@,
    @input@, and optionally @inline@, and return a JSON
    object with either @error@ and a message or
    @success@ and the converted result.
category: Text
author: John MacFarlane, Matthew Pickering
exposed: True
exposed-modules:
    Text.TeXMath Text.TeXMath.Types Text.TeXMath.Readers.TeX
    Text.TeXMath.Readers.TeX.Macros Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.MMLDict
    Text.TeXMath.Readers.MathML.EntityMap Text.TeXMath.Readers.OMML
    Text.TeXMath.Writers.MathML Text.TeXMath.Writers.OMML
    Text.TeXMath.Writers.Pandoc Text.TeXMath.Writers.TeX
    Text.TeXMath.Writers.Eqn Text.TeXMath.Unicode.ToUnicode
    Text.TeXMath.Unicode.ToTeX Text.TeXMath.Unicode.ToASCII
    Text.TeXMath.Unicode.Fonts
hidden-modules: Text.TeXMath.Compat Text.TeXMath.Shared
                Text.TeXMath.TeX Paths_texmath
abi: ddaddebcfded34079790dc109ae192c1
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/texmath-0.9.4
library-dirs: /usr/lib/ghc-8.0.2/site-local/texmath-0.9.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/texmath-0.9.4
hs-libraries: HStexmath-0.9.4-5gHgQZ6t6rX3Vweup3LHkD
depends:
    base-4.9.1.0 containers-0.5.7.1 mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6
    pandoc-types-1.17.0.5-4qcloVxwAGy4cbH965XfQL
    parsec-3.1.11-1CA7c0vSU7tJHGhveOjoXR syb-0.6-IcoSwlPi2Nx4zSqMmorFPS
    xml-1.3.14-FVnE0jAbj4fGGraldXZwwG
haddock-interfaces: /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html: /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
