#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: wai-extra
version: 3.0.20.0
id: wai-extra-3.0.20.0-JraNACb1YkGLHzGPVSUQtd
key: wai-extra-3.0.20.0-JraNACb1YkGLHzGPVSUQtd
license: MIT
maintainer: michael@snoyman.com
stability: Stable
homepage: http://github.com/yesodweb/wai
synopsis: Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:
    .
    * WAI Testing Framework
    .
    Hspec testing facilities and helpers for WAI.
    .
    * Event Source/Event Stream
    .
    Send server events to the client. Compatible with the JavaScript
    EventSource API.
    .
    * Accept Override
    .
    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).
    .
    * Add Headers
    .
    WAI Middleware for adding arbitrary headers to an HTTP request.
    .
    * Clean Path
    .
    Clean a request path to a canonical form.
    .
    * GZip Compression
    .
    Negotiate HTTP payload gzip compression.
    .
    * HTTP Basic Authentication
    .
    WAI Basic Authentication Middleware which uses Authorization header.
    .
    * JSONP
    .
    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.
    .
    * Method Override / Post
    .
    Allows overriding of the HTTP request method via the _method query string
    parameter.
    .
    * Request Logging
    .
    Request logging middleware for development and production environments
    .
    * Request Rewrite
    .
    Rewrite request path info based on a custom conversion rules.
    .
    * Stream Files
    .
    Convert ResponseFile type responses into ResponseStream type.
    .
    * Virtual Host
    .
    Redirect incoming requests to a new host based on custom rules.
    .
    .
    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.
category: Web
author: Michael Snoyman
exposed: True
exposed-modules:
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.Local Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.StripHeaders
    Network.Wai.Middleware.Vhost Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Routed Network.Wai.Parse Network.Wai.Request
    Network.Wai.UrlMap Network.Wai.Test Network.Wai.Test.Internal
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
hidden-modules: Network.Wai.Middleware.RequestLogger.Internal
abi: d1513d30195189d529d2932c71419445
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/wai-extra-3.0.20.0
library-dirs: /usr/lib/ghc-8.0.2/site-local/wai-extra-3.0.20.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/wai-extra-3.0.20.0
hs-libraries: HSwai-extra-3.0.20.0-JraNACb1YkGLHzGPVSUQtd
depends:
    aeson-1.1.2.0-H9d5B7Pgw9tIbOpl8Ot3sY
    ansi-terminal-0.6.3.1-59sjf9WqHYuFAo9gQw9Bhp base-4.9.1.0
    base64-bytestring-1.0.0.1-4O9TExPPz6eI82Yj7L4SIj
    blaze-builder-0.4.0.2-EbETJDFSQ4b6W7B283dutO bytestring-0.10.8.1
    case-insensitive-1.2.0.10-3Sa52nt2lVR6gZGQE5fZZw containers-0.5.7.1
    cookie-0.4.2.1-5x7MNzUkNoMGYE9M5Up3Qp
    data-default-class-0.1.2.0-N42RtcTZUUAlapzICmPz4 deepseq-1.4.2.0
    directory-1.3.0.0 fast-logger-2.4.10-2euPaz22smb5hHUbwH6fvd
    http-types-0.9.1-IqlxYYwrFhNBj6J7ATsByJ
    iproute-1.7.1-EJjAtfniBUorobFQnk7lR
    lifted-base-0.2.3.11-797F0GSRM4GHiCBSQ3AJmQ
    network-2.6.3.2-IsLM4TXcLoRI0fmmBYVyQz
    old-locale-1.0.0.7-KGBP1BSKxH5GCm0LnZP04j
    resourcet-1.1.9-8dcH1R5asu46j8AjnoNKK5
    streaming-commons-0.1.18-KZl1SWhWop6Ksa4IiFWi6P
    stringsearch-0.3.6.6-8anNeXolBRk4a9DV14i2Be
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0 unix-2.7.2.1
    unix-compat-0.4.3.1-Ausmw6d7KIwA7sl52mzqxC
    vault-0.3.0.7-E4lXhyEMoKrEIYQFhBY3rZ
    void-0.7.2-2kaNlnbmZo5LCwbtPDXIQb
    wai-3.2.1.1-8mpSdlQN10CC3im2R8JJP4
    wai-logger-2.3.0-JsYl94dk2DB2fjpqHDT8kd
    word8-0.1.2-9WDPGCTpW7JJnsiAQavtd1
    zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
haddock-interfaces: /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html: /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
