#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-web
version: 1.2
id: hledger-web-1.2-5rbYPTkDQSE7RcAz5IiIxb
key: hledger-web-1.2-5rbYPTkDQSE7RcAz5IiIxb
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Web interface for the hledger accounting tool
description:
    This is hledger'\''s web interface.
    It provides a more user-friendly and collaborative UI than the
    command-line or curses-style interfaces.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
author: Simon Michael <simon@joyful.com>
exposed: True
exposed-modules:
    Application Foundation Handler.AddForm Handler.Common
    Handler.JournalR Handler.RegisterR Handler.RootR Handler.SidebarR
    Handler.Utils Hledger.Web Hledger.Web.Main Hledger.Web.WebOptions
    Import Settings Settings.Development Settings.StaticFiles
hidden-modules: Paths_hledger_web
abi: a002b444e2b63f3f327a85fd8837d986
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-web-1.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/hledger-web-1.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger-web
hs-libraries: HShledger-web-1.2-5rbYPTkDQSE7RcAz5IiIxb
depends:
    HUnit-1.6.0.0-60ZLMGxowdyCquCGGOoE3I base-4.9.1.0
    base-compat-0.9.3-KeJp8zYMpcS9WibvTcxU22
    blaze-html-0.8.1.3-EHw0sCLFL6JKZx2lFkE5O8
    blaze-markup-0.7.1.1-Amik95gvtJH76XeEGEdOV0 bytestring-0.10.8.1
    clientsession-0.9.1.2-LkXBCWfLM2c649c8EV2Hv6
    cmdargs-0.10.17-gTr0lzwrHbBcQQ47pfTGo
    conduit-extra-1.1.16-C3xWe88KfHvD9kiG2dJ0pk
    data-default-0.7.1.1-CyM3k1XLfwb41mPgt03rCT directory-1.3.0.0
    filepath-1.4.1.1 hjsmin-0.2.0.2-KVIZEO0GpxR4sKyr7sGnCY
    hledger-1.2-Gdf0i2kepxPGgUkfVRtrgs
    hledger-lib-1.2-DzG8YyYq6sICyb0Ier8sSX
    http-client-0.5.7.0-8CqgjLtDELe98Oo6kiK06v
    http-conduit-2.2.3.1-EmVWdcVb4pg4No1uLRZwYO
    json-0.9.1-G9lxq5WdrzUDT7HRdlHQ5I
    megaparsec-5.3.1-EuBhiFLipVpCArDKS8Wu9b
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6 safe-0.3.15-2Yd45VWFfdcKqKyispOifY
    shakespeare-2.0.13-G69XrHREitm2CYuiavYCAg template-haskell-2.11.1.0
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0 wai-3.2.1.1-8mpSdlQN10CC3im2R8JJP4
    wai-extra-3.0.20.0-JraNACb1YkGLHzGPVSUQtd
    wai-handler-launch-3.0.2.2-4oaCII0tPHo3ynt6RxleJ9
    warp-3.2.12-I48cwxl3zkoEHofxH09Q0X
    yaml-0.8.23.1-C7vpXDxLo3D8PgWvqzFNuE
    yesod-1.4.5-5DRnlawCNkXKkQ5qeLMN4g
    yesod-core-1.4.35-XU6KYBGLG4DMcteOMA6PS
    yesod-form-1.4.12-1IFOgeifRJ5K3n5kRKYZbj
    yesod-static-1.5.3-5zyrBfoNAsfGqSvo7Bn2tc
haddock-interfaces: /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html: /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
