/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaIconElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextElement;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ComputeStyleListWorker
extends RecursiveTask<List<StyledMapRenderer.StyleRecord>>
implements Visitor {
    private final transient List<? extends OsmPrimitive> input;
    private final transient List<StyledMapRenderer.StyleRecord> output;
    private final transient ElemStyles styles = MapPaintStyles.getStyles();
    private final int directExecutionTaskSize;
    private final double circum;
    private final NavigatableComponent nc;
    private final boolean drawArea;
    private final boolean drawMultipolygon;
    private final boolean drawRestriction;

    ComputeStyleListWorker(double d, NavigatableComponent navigatableComponent, List<? extends OsmPrimitive> list, List<StyledMapRenderer.StyleRecord> list2, int n) {
        this.circum = d;
        this.nc = navigatableComponent;
        this.input = list;
        this.output = list2;
        this.directExecutionTaskSize = n;
        this.drawArea = d <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
        this.drawMultipolygon = this.drawArea && Main.pref.getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
        this.styles.setDrawMultipolygon(this.drawMultipolygon);
    }

    @Override
    protected List<StyledMapRenderer.StyleRecord> compute() {
        if (this.input.size() <= this.directExecutionTaskSize) {
            return this.computeDirectly();
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.input.size(); i += this.directExecutionTaskSize) {
            int n = Math.min(i + this.directExecutionTaskSize, this.input.size());
            arrayList.add(new ComputeStyleListWorker(this.circum, this.nc, this.input.subList(i, n), new ArrayList<StyledMapRenderer.StyleRecord>(this.directExecutionTaskSize), this.directExecutionTaskSize).fork());
        }
        for (ForkJoinTask forkJoinTask : arrayList) {
            this.output.addAll((Collection)forkJoinTask.join());
        }
        return this.output;
    }

    public List<StyledMapRenderer.StyleRecord> computeDirectly() {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (OsmPrimitive osmPrimitive : this.input) {
                this.acceptDrawable(osmPrimitive);
            }
            List<StyledMapRenderer.StyleRecord> list = this.output;
            return list;
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("input-size", this.input.size()).put("output-size", this.output.size());
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    private void acceptDrawable(OsmPrimitive osmPrimitive) {
        try {
            if (osmPrimitive.isDrawable()) {
                osmPrimitive.accept(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("osm", osmPrimitive);
        }
    }

    @Override
    public void visit(Node node) {
        this.add(node, StyledMapRenderer.computeFlags(node, false));
    }

    @Override
    public void visit(Way way) {
        this.add(way, StyledMapRenderer.computeFlags(way, true));
    }

    @Override
    public void visit(Relation relation) {
        this.add(relation, StyledMapRenderer.computeFlags(relation, true));
    }

    @Override
    public void visit(Changeset changeset) {
        throw new UnsupportedOperationException();
    }

    public void add(Node node, int n) {
        StyleElementList styleElementList = this.styles.get(node, this.circum, this.nc);
        for (StyleElement styleElement : styleElementList) {
            this.output.add(new StyledMapRenderer.StyleRecord(styleElement, node, n));
        }
    }

    public void add(Way way, int n) {
        StyleElementList styleElementList = this.styles.get(way, this.circum, this.nc);
        for (StyleElement styleElement : styleElementList) {
            if ((!this.drawArea || (n & 1) != 0) && styleElement instanceof AreaElement) continue;
            this.output.add(new StyledMapRenderer.StyleRecord(styleElement, way, n));
        }
    }

    public void add(Relation relation, int n) {
        StyleElementList styleElementList = this.styles.get(relation, this.circum, this.nc);
        for (StyleElement styleElement : styleElementList) {
            if (!this.drawAreaElement(n, styleElement) && (!this.drawMultipolygon || !this.drawArea || !(styleElement instanceof TextElement)) && (!this.drawRestriction || !(styleElement instanceof NodeElement))) continue;
            this.output.add(new StyledMapRenderer.StyleRecord(styleElement, relation, n));
        }
    }

    private boolean drawAreaElement(int n, StyleElement styleElement) {
        return this.drawMultipolygon && this.drawArea && (styleElement instanceof AreaElement || styleElement instanceof AreaIconElement) && (n & 1) == 0;
    }
}

