/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CollectionLiteralResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TraceEntryFilter;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create(KtTokens.AS_KEYWORD, KtTokens.AS_SAFE);
    private static final Pattern FP_LITERAL_PARTS = Pattern.compile("(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[f]?");

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(0);
        }
        super(facade);
    }

    private static boolean isLValueOrUnsafeReceiver(@NotNull KtSimpleNameExpression expression) {
        PsiElement parent2;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(1);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(expression, KtParenthesizedExpression.class)) instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            return qualifiedExpression.getOperationSign() == KtTokens.DOT && qualifiedExpression.getReceiverExpression() == KtPsiUtil.deparenthesize(expression);
        }
        if (parent2 instanceof KtBinaryExpression) {
            KtBinaryExpression binaryExpression = (KtBinaryExpression)parent2;
            if (!OperatorConventions.BINARY_OPERATION_NAMES.containsKey(binaryExpression.getOperationToken()) && !KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            return PsiTreeUtil.isAncestor(binaryExpression.getLeft(), expression, false);
        }
        return false;
    }

    private static boolean isDangerousWithNull(@NotNull KtSimpleNameExpression expression, @NotNull ExpressionTypingContext context) {
        PsiElement parent2;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(3);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(expression, KtParenthesizedExpression.class)) instanceof KtUnaryExpression) {
            KtUnaryExpression unaryExpression = (KtUnaryExpression)parent2;
            return unaryExpression.getOperationToken() == KtTokens.EXCLEXCL;
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            KtBinaryExpressionWithTypeRHS binaryExpression = (KtBinaryExpressionWithTypeRHS)parent2;
            KotlinType type2 = context.trace.get(BindingContext.TYPE, binaryExpression.getRight());
            return type2 != null && !type2.isMarkedNullable() && binaryExpression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
        }
        return false;
    }

    private static void checkNull(@NotNull KtSimpleNameExpression expression, @NotNull ExpressionTypingContext context, @Nullable KotlinType type2) {
        DataFlowValue dataFlowValue;
        Nullability nullability;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(5);
        }
        if (type2 != null && !type2.isError() && !BasicExpressionTypingVisitor.isLValueOrUnsafeReceiver(expression) && !(nullability = context.dataFlowInfo.getStableNullability(dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context))).canBeNonNull() && nullability.canBeNull()) {
            if (BasicExpressionTypingVisitor.isDangerousWithNull(expression, context)) {
                context.trace.report(Errors.ALWAYS_NULL.on(expression));
            } else {
                context.trace.record(BindingContext.SMARTCAST_NULL, expression);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(6);
        }
        KtPsiUtilKt.checkReservedYield(expression, context.trace);
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        KotlinTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression, null, null, context);
        BasicExpressionTypingVisitor.checkNull(expression, context, typeInfo.getType());
        this.components.constantExpressionEvaluator.evaluateExpression(expression, context.trace, context.expectedType);
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (KtExpression)expression, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, ExpressionTypingContext context) {
        KtExpression innerExpression;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(7);
        }
        if ((innerExpression = expression.getExpression()) == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KotlinTypeInfo result2 = this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context.replaceScope(context.scope));
        KotlinType resultType = result2.getType();
        if (resultType != null) {
            DataFlowValue innerValue = DataFlowValueFactory.createDataFlowValue(innerExpression, resultType, context);
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(expression, resultType, context);
            result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(resultValue, innerValue, this.components.languageVersionSettings));
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression, ExpressionTypingContext context) {
        ConstantValue constantValue;
        CompileTimeConstantChecker constantChecker;
        boolean hasError;
        CompileTimeConstant<?> compileTimeConstant;
        IElementType elementType;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(8);
        }
        if ((elementType = expression.getNode().getElementType()) == KtNodeTypes.CHARACTER_CONSTANT || elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression, context);
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            this.checkUnderscores(expression, elementType, context);
        }
        if (!((compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression, context.trace, context.expectedType)) instanceof IntegerValueTypeConstant) && (hasError = (constantChecker = new CompileTimeConstantChecker(context, this.components.builtIns, false)).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression, context.expectedType))) {
            return TypeInfoFactoryKt.createTypeInfo(constantValue != null ? constantValue.getType() : this.getDefaultType(elementType), context);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression, context);
    }

    private void checkUnderscores(@NotNull KtConstantExpression expression, @NotNull IElementType elementType, @NotNull ExpressionTypingContext context) {
        List<String> parts;
        String text2;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(9);
        }
        if (elementType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(10);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(11);
        }
        if (!(text2 = expression.getText().toLowerCase()).contains("_")) {
            return;
        }
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.UnderscoresInNumericLiterals)) {
            context.trace.report(Errors.UNSUPPORTED_FEATURE.on(expression, TuplesKt.to(LanguageFeature.UnderscoresInNumericLiterals, this.components.languageVersionSettings)));
            return;
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            int start = 0;
            int end = expression.getText().length();
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            if (StringUtil.endsWithChar(text2, 'l')) {
                --end;
            }
            parts = Collections.singletonList(text2.substring(start, end));
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text2);
            parts = new ArrayList<String>();
            if (matcher.matches()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts.add(matcher.group(i + 1));
                }
            }
        }
        for (String part : parts) {
            if (part == null || !part.startsWith("_") && !part.endsWith("_")) continue;
            context.trace.report(Errors.ILLEGAL_UNDERSCORE.on(expression));
            return;
        }
    }

    @NotNull
    public KotlinType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == KtNodeTypes.INTEGER_CONSTANT) {
            SimpleType simpleType2 = builtIns.getIntType();
            if (simpleType2 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(12);
            }
            return simpleType2;
        }
        if (constantType == KtNodeTypes.FLOAT_CONSTANT) {
            SimpleType simpleType3 = builtIns.getDoubleType();
            if (simpleType3 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(13);
            }
            return simpleType3;
        }
        if (constantType == KtNodeTypes.BOOLEAN_CONSTANT) {
            SimpleType simpleType4 = builtIns.getBooleanType();
            if (simpleType4 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(14);
            }
            return simpleType4;
        }
        if (constantType == KtNodeTypes.CHARACTER_CONSTANT) {
            SimpleType simpleType5 = builtIns.getCharType();
            if (simpleType5 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(15);
            }
            return simpleType5;
        }
        if (constantType == KtNodeTypes.NULL) {
            SimpleType simpleType6 = builtIns.getNullableNothingType();
            if (simpleType6 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(16);
            }
            return simpleType6;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(17);
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression left = expression.getLeft();
        KtTypeReference right = expression.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, allowBareTypes, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        KotlinType subjectType = typeInfo.getType();
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression, contextWithNoExpectedType, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == KtTokens.AS_KEYWORD) {
                DataFlowValue value = DataFlowValueFactory.createDataFlowValue(left, subjectType, context);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value, targetType, this.components.languageVersionSettings));
            }
        }
        KotlinType result2 = operationType == KtTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression, (ResolutionContext)context);
        RttiExpressionInformation rttiInformation = new RttiExpressionInformation(expression.getLeft(), subjectType, result2, operationType == KtTokens.AS_SAFE ? RttiOperation.SAFE_AS : RttiOperation.AS);
        for (RttiExpressionChecker checker : this.components.rttiExpressionCheckers) {
            checker.check(rttiInformation, expression, context.trace);
        }
        return resultTypeInfo;
    }

    private void checkBinaryWithTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS expression, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @Nullable KotlinType actualType) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(18);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(19);
        }
        if (targetType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(20);
        }
        if (actualType == null) {
            return;
        }
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType != KtTokens.AS_KEYWORD && operationType != KtTokens.AS_SAFE) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression, actualType, targetType, context);
    }

    private void checkForCastImpossibilityOrRedundancy(KtBinaryExpressionWithTypeRHS expression, KotlinType actualType, KotlinType targetType, ExpressionTypingContext context) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || targetType.isError()) {
            return;
        }
        if (DynamicTypesKt.isDynamic(targetType)) {
            KtTypeReference right = expression.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationReference()));
            return;
        }
        KotlinTypeChecker typeChecker = KotlinTypeChecker.DEFAULT;
        if (BasicExpressionTypingVisitor.isExactTypeCast(actualType, targetType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression));
            return;
        }
        DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
        Collection<KotlinType> possibleTypes = DataFlowAnalyzer.getAllPossibleTypes(expression.getLeft(), context.dataFlowInfo, actualType, context);
        boolean checkExactType = BasicExpressionTypingVisitor.checkExactTypeForUselessCast(expression);
        for (KotlinType possibleType : possibleTypes) {
            boolean castIsUseless = checkExactType ? BasicExpressionTypingVisitor.isExactTypeCast(possibleType, targetType) : BasicExpressionTypingVisitor.isUpcast(possibleType, targetType, typeChecker);
            if (!castIsUseless) continue;
            context.trace.report(Errors.USELESS_CAST.on(expression));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
        }
    }

    private static boolean isExactTypeCast(KotlinType candidateType, KotlinType targetType) {
        return candidateType.equals(targetType) && FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
    }

    private static boolean isUpcast(KotlinType candidateType, KotlinType targetType, KotlinTypeChecker typeChecker) {
        if (KotlinBuiltIns.isNullableNothing(candidateType)) {
            return false;
        }
        if (!typeChecker.isSubtypeOf(candidateType, targetType)) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(candidateType) && FunctionTypesKt.isFunctionType(targetType)) {
            return FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
        }
        return true;
    }

    private static boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression) {
        PsiElement parent2 = expression.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof KtValueArgument) {
            return true;
        }
        if (parent2 instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            return PsiTreeUtil.isAncestor(receiver, expression, false);
        }
        return parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression;
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(21);
        }
        KotlinType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.recordType(expression.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(22);
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression, context, true);
        if (!KtPsiUtil.isLHSOfDot(expression)) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
            return this.errorInSuper(expression, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                return this.errorInSuper(expression, context);
            }
            case SUCCESS: {
                KotlinType result2 = this.checkPossiblyQualifiedSuper(expression, context, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context.trace.recordType(expression.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context, expression);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private KotlinTypeInfo errorInSuper(KtSuperExpression expression, ExpressionTypingContext context) {
        KtTypeReference superTypeQualifier = expression.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    private KotlinType checkPossiblyQualifiedSuper(KtSuperExpression expression, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver) {
        KtTypeReference superTypeQualifier;
        KotlinType thisType;
        KotlinType result2;
        block22: {
            TypeSubstitutor substitutor2;
            Collection<KotlinType> supertypes2;
            block19: {
                boolean validType;
                KtTypeArgumentList redundantTypeArguments;
                KotlinType supertype;
                ClassifierDescriptor classifierCandidate;
                block21: {
                    block20: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor2 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block19;
                        KtTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof KtUserType) {
                            KtUserType userType = (KtUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context.scope, userType, context.trace, context.isDebuggerContext);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (classifierCandidate instanceof TypeAliasDescriptor) {
                            classifierCandidate = ((TypeAliasDescriptor)classifierCandidate).getClassDescriptor();
                        }
                        if (supertype == null) break block20;
                        if (!supertypes2.contains(supertype)) break block21;
                        result2 = supertype;
                        break block21;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassifierDescriptor superclass = classifierCandidate;
                        for (KotlinType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor2.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !supertype.isError();
                if (result2 == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                if (result2 != null && (validClassifier || validType)) {
                    BasicExpressionTypingVisitor.checkResolvedExplicitlyQualifiedSupertype(context.trace, result2, supertypes2, superTypeQualifier);
                }
                break block22;
            }
            if (UnqualifiedSuperKt.isPossiblyAmbiguousUnqualifiedSuper(expression, supertypes2)) {
                Collection<KotlinType> supertypesResolvedFromContext = UnqualifiedSuperKt.resolveUnqualifiedSuperFromExpressionContext(expression, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    KotlinType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor2.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
                }
            } else {
                KotlinType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor2.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isInterface(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE.on(expression));
            }
            context.trace.recordType(expression.getInstanceReference(), result2);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
            context.trace.record(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression, thisType);
        }
        BindingContextUtilsKt.recordScope(context.trace, context.scope, superTypeQualifier);
        return result2;
    }

    private static void checkResolvedExplicitlyQualifiedSupertype(@NotNull BindingTrace trace, @NotNull KotlinType result2, @NotNull Collection<KotlinType> supertypes2, @NotNull KtTypeReference superTypeQualifier) {
        if (trace == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(24);
        }
        if (supertypes2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(25);
        }
        if (superTypeQualifier == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(26);
        }
        if (supertypes2.size() > 1) {
            ClassifierDescriptor resultClassifierDescriptor = result2.getConstructor().getDeclarationDescriptor();
            for (KotlinType otherSupertype : supertypes2) {
                ClassifierDescriptor otherSupertypeClassifierDescriptor = otherSupertype.getConstructor().getDeclarationDescriptor();
                if (otherSupertypeClassifierDescriptor == resultClassifierDescriptor || !KotlinTypeChecker.DEFAULT.isSubtypeOf(otherSupertype, result2)) continue;
                trace.report(Errors.QUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE.on(superTypeQualifier, otherSupertype));
                break;
            }
        }
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(KtInstanceExpressionWithLabel expression, ExpressionTypingContext context, boolean onlyClassReceivers) {
        Name labelName = expression.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression, context, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context, receiverParameterDescriptor, expression);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(null);
                    if (labeledReceiverResolutionResult == null) {
                        BasicExpressionTypingVisitor.$$$reportNull$$$0(27);
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(28);
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = ScopeUtilsKt.getImplicitReceiversHierarchy(context.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context, result2, expression);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(29);
        }
        return labeledReceiverResolutionResult;
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context, ReceiverParameterDescriptor descriptor2, KtExpression expression) {
        BindingTrace trace = context.trace;
        Call call2 = CallMaker.makeCall(expression, null, null, expression, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(context.dataFlowInfo, call2));
        resolvedCall2.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
        trace.record(BindingContext.CALL, expression, call2);
        if (context.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.components.languageVersionSettings);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression, callCheckerContext);
            }
        }
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(30);
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context, false);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, ExpressionTypingContext c) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(31);
        }
        return this.components.doubleColonExpressionResolver.visitClassLiteralExpression(expression, c);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, ExpressionTypingContext c) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(32);
        }
        return this.components.doubleColonExpressionResolver.visitCallableReferenceExpression(expression, c);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(final @NotNull KtObjectLiteralExpression expression, final ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(33);
        }
        final KotlinType[] result2 = new KotlinType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve object literal expression", expression);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler2 = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor2) {
                if (slice == BindingContext.CLASS && declaration == expression.getObjectDeclaration()) {
                    KotlinType defaultType2;
                    result2[0] = defaultType2 = BasicExpressionTypingVisitor.this.components.wrappedTypeFactory.createRecursionIntolerantDeferredType(context.trace, (Function0<? extends KotlinType>)new Function0<KotlinType>(){

                        @Override
                        public KotlinType invoke() {
                            return descriptor2.getDefaultType();
                        }
                    });
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler2);
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), expression.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context.dataFlowInfo;
        for (KtSuperTypeListEntry specifier : expression.getObjectDeclaration().getSuperTypeListEntries()) {
            KtSuperTypeCallEntry delegator;
            KotlinTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof KtSuperTypeCallEntry) || (delegatorTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (KtSuperTypeCallEntry)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryKt.createTypeInfo(result2[0], resultFlowInfo), (KtExpression)expression, (ResolutionContext)context);
        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, resultTypeInfo);
        context.trace.record(BindingContext.PROCESSED, expression);
        return resultTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(34);
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression, context);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(35);
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression, null, null, context);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        KotlinType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(36);
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression, context);
        }
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context);
        KotlinType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(baseExpression, type2, context.trace.getBindingContext());
        Call call2 = CallMaker.makeCall((ReceiverValue)receiver, expression);
        Name name = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && baseExpression instanceof KtArrayAccessExpression) {
            KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(temporaryBindingTrace);
            this.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)baseExpression, stubExpression, newContext, context.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context, call2, expression.getOperationReference(), name)).isSuccess()) {
            return typeInfo.clearType();
        }
        KotlinType returnType = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) {
            assert (returnType != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                KotlinType receiverType = receiver.getType();
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "e", type2);
                    this.checkLValue(context.trace, context, baseExpression, stubExpression, expression);
                }
                DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue((ReceiverValue)call2.getExplicitReceiver(), contextWithExpectedType);
                if (expression instanceof KtPrefixExpression) {
                    result2 = returnType;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = DataFlowValueFactory.createDataFlowValue(expression, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue, this.components.languageVersionSettings));
                }
            }
        } else {
            result2 = returnType;
        }
        CompileTimeConstant<?> value = this.components.constantExpressionEvaluator.evaluateExpression(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private KotlinTypeInfo visitExclExclExpression(@NotNull KtUnaryExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(37);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(38);
        }
        KtExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        KtSimpleNameExpression operationSign = expression.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == KtTokens.EXCLEXCL);
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Collections.singletonList(baseExpression));
        this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL, Collections.singletonList("baseExpr"), Collections.singletonList(true), context, null);
        KotlinTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context)) {
            context.trace.report(Errors.NOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION.on(operationSign));
            if (baseTypeInfo == null) {
                return TypeInfoFactoryKt.createTypeInfo((KotlinType)ErrorUtils.createErrorType("Unresolved lambda expression"), context);
            }
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression;
        KotlinType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, baseType, context)) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, TypeUtils.makeNotNullable(baseType)));
        } else {
            DataFlowValue value = DataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value, DataFlowValue.nullValue(this.components.builtIns), this.components.languageVersionSettings));
        }
        KotlinType resultingType = TypeUtils.makeNotNullable(baseType);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (KtExpression)expression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(39);
        }
        return this.visitLabeledExpression(expression, context, false);
    }

    @NotNull
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression, @NotNull ExpressionTypingContext context, boolean isStatement) {
        KtExpression baseExpression;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(40);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(41);
        }
        KtSimpleNameExpression labelExpression = expression.getTargetLabel();
        KtPsiUtilKt.checkReservedYield(labelExpression, context.trace);
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE.checkIdentifier(labelIdentifier, context.trace, this.components.languageVersionSettings);
        }
        if ((baseExpression = expression.getBaseExpression()) == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(42);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(baseExpression, context, isStatement);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(43);
        }
        return kotlinTypeInfo;
    }

    private static boolean isKnownToBeNotNull(@NotNull KtExpression expression, @Nullable KotlinType ktType, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(44);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(45);
        }
        if (ktType == null) {
            return false;
        }
        if (ktType.isError() && !ErrorUtils.isUninferredParameter(ktType)) {
            return false;
        }
        if (!TypeUtils.isNullableType(ktType)) {
            return true;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, ktType, context);
        return context.dataFlowInfo.getStableNullability(dataFlowValue) == Nullability.NOT_NULL;
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context, @NotNull KtExpression expressionWithParenthesis, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression) {
        KtExpression selector;
        KtExpression reportOn;
        KtExpression expression;
        if (trace == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(46);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(47);
        }
        if (expressionWithParenthesis == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(48);
        }
        if (operationExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(49);
        }
        if ((expression = KtPsiUtil.deparenthesize(expressionWithParenthesis)) instanceof KtArrayAccessExpression) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)expression;
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context.replaceBindingTrace(ignoreReportsTrace);
            KotlinTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
            IElementType operationType = operationExpression.getOperationReference().getReferencedNameElementType();
            if ((KtTokens.AUGMENTED_ASSIGNMENTS.contains(operationType) || operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && (resolvedCall2 = ignoreReportsTrace.get(BindingContext.INDEXED_LVALUE_SET, expression)) != null && trace.wantsDiagnostics()) {
                CallCheckerContext callCheckerContext = new CallCheckerContext(context, trace, this.components.languageVersionSettings);
                for (CallChecker checker : this.components.callCheckers) {
                    checker.check(resolvedCall2, expression, callCheckerContext);
                }
            }
            return info.getType() != null;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorFromReference(trace.getBindingContext(), expression);
        boolean result2 = true;
        KtExpression ktExpression = reportOn = expression != null ? expression : expressionWithParenthesis;
        if (reportOn instanceof KtQualifiedExpression && (selector = ((KtQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable;
            PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter2 != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(expressionWithParenthesis, context.trace.getBindingContext());
                assert (resolvedCall3 != null) : "Call is not resolved for property setter: " + PsiUtilsKt.getElementTextWithContext(expressionWithParenthesis);
                this.checkPropertySetterCall((ExpressionTypingContext)context.replaceBindingTrace(trace), setter2, resolvedCall3, reportOn);
            }
        }
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable.isVar()) {
            result2 = false;
        }
        return result2;
    }

    private void checkPropertySetterCall(@NotNull ExpressionTypingContext context, @NotNull PropertySetterDescriptor descriptor2, @NotNull ResolvedCall<?> propertyResolvedCall, @NotNull KtExpression expression) {
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(50);
        }
        if (descriptor2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(51);
        }
        if (propertyResolvedCall == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(52);
        }
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(53);
        }
        Call call2 = propertyResolvedCall.getCall();
        ResolutionCandidate<PropertySetterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, propertyResolvedCall.getDispatchReceiver(), propertyResolvedCall.getExplicitReceiverKind(), null);
        ResolvedCallImpl<PropertySetterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(context.trace, "Trace for fake property setter resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(propertyResolvedCall.getDataFlowInfoForArguments().getResultInfo(), call2));
        resolvedCall2.markCallAsCompleted();
        if (context.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.components.languageVersionSettings);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression, callCheckerContext);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo result2;
        Name referencedName;
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(54);
        }
        ExpressionTypingContext context = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtOperationReferenceExpression operationSign = expression.getOperationReference();
        KtExpression left = expression.getLeft();
        KtExpression right = expression.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context, expression);
        } else {
            if (operationType == KtTokens.ELVIS) {
                return this.visitElvisExpression(expression, context);
            }
            if (operationType == KtTokens.EQ) {
                result2 = this.visitAssignment(expression, context);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitAssignmentOperation(expression, context);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result2 = this.visitComparison(expression, context, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result2 = this.visitEquality(expression, context, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(operationType)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                result2 = TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context);
                BasicExpressionTypingVisitor.checkIdentityOnPrimitiveTypes(expression, context);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression, operationSign, leftArgument, right, context);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context);
            } else {
                context.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryKt.noTypeInfo(context);
            }
        }
        CompileTimeConstant<?> value = this.components.constantExpressionEvaluator.evaluateExpression(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkIdentityOnPrimitiveTypes(@NotNull KtBinaryExpression expression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(55);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(56);
        }
        if (expression.getLeft() == null || expression.getRight() == null) {
            return;
        }
        KotlinType leftType = context.trace.getType(expression.getLeft());
        KotlinType rightType = context.trace.getType(expression.getRight());
        if (leftType == null || rightType == null) {
            return;
        }
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType) && KotlinBuiltIns.isPrimitiveType(leftType)) {
            context.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on(expression, leftType, rightType));
        } else if (BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(leftType, rightType) || BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on(expression, leftType, rightType));
        }
    }

    private static boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private KotlinTypeInfo visitEquality(KtBinaryExpression expression, ExpressionTypingContext context, KtSimpleNameExpression operationSign, final KtExpression left, final KtExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context);
        }
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        TemporaryBindingTrace traceInterpretingRightAsNullableAny = TemporaryBindingTrace.create(context.trace, "trace to resolve 'equals(Any?)' interpreting as of type Any? an expression:", right);
        traceInterpretingRightAsNullableAny.recordType(right, this.components.builtIns.getNullableAnyType());
        KotlinType leftType = leftTypeInfo.getType();
        if (leftType != null && KotlinBuiltIns.isNothingOrNullableNothing(leftType)) {
            traceInterpretingRightAsNullableAny.recordType(left, this.components.builtIns.getNullableAnyType());
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)context.replaceBindingTrace(traceInterpretingRightAsNullableAny);
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, newContext);
        Call call2 = CallMaker.makeCallWithExpressions(expression, receiver, new KtPsiFactory(expression.getProject(), false).createSafeCallNode(), operationSign, Collections.singletonList(right));
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveCallWithGivenName(newContext, call2, operationSign, OperatorNameConventions.EQUALS);
        traceInterpretingRightAsNullableAny.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                return key != right && key != left || slice != BindingContext.EXPRESSION_TYPE_INFO;
            }
        }, true);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorNameConventions.EQUALS, equals.getReturnType(), context)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    @NotNull
    private KotlinTypeInfo visitComparison(@NotNull KtBinaryExpression expression, @NotNull ExpressionTypingContext context, @NotNull KtSimpleNameExpression operationSign) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(57);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(58);
        }
        if (operationSign == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(59);
        }
        KotlinTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorNameConventions.COMPARE_TO, context, expression);
        KotlinType compareToReturnType = typeInfo.getType();
        SimpleType type2 = null;
        if (compareToReturnType != null && !compareToReturnType.isError()) {
            if (KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(type2);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(60);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable KtExpression left, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(61);
        }
        SimpleType booleanType = this.components.builtIns.getBooleanType();
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.LEFT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        boolean isAnd = operationType == KtTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.RIGHT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        KotlinTypeInfo kotlinTypeInfo = leftTypeInfo.replaceType(booleanType);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(62);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitElvisExpression(@NotNull KtBinaryExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(63);
        }
        if (contextWithExpectedType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(64);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression left = expression.getLeft();
        KtExpression right = expression.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(65);
            }
            return kotlinTypeInfo;
        }
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.ELVIS, Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        KotlinTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context.trace.getBindingContext());
        if (ArgumentTypeResolver.isFunctionLiteralArgument(left, context)) {
            context.trace.report(Errors.USELESS_ELVIS_ON_LAMBDA_EXPRESSION.on(expression.getOperationReference()));
            if (leftTypeInfo == null) {
                KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
                if (kotlinTypeInfo == null) {
                    BasicExpressionTypingVisitor.$$$reportNull$$$0(66);
                }
                return kotlinTypeInfo;
            }
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression;
        KotlinType leftType = leftTypeInfo.getType();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context)) {
            context.trace.report(Errors.USELESS_ELVIS.on(expression, leftType));
        } else if (KtPsiUtil.isNullConstant(right) && leftType != null && !FlexibleTypesKt.isNullabilityFlexible(leftType)) {
            context.trace.report(Errors.USELESS_ELVIS_RIGHT_IS_NULL.on(expression));
        }
        KotlinTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context.trace.getBindingContext());
        if (rightTypeInfo == null && ArgumentTypeResolver.isFunctionLiteralArgument(right, context)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(67);
            }
            return kotlinTypeInfo;
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        KotlinType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getInfo(call2.getValueArguments().get(1));
        KotlinType type2 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (type2 == null || rightType == null || leftType == null && KotlinBuiltIns.isNothing(rightType)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(dataFlowInfo);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(68);
            }
            return kotlinTypeInfo;
        }
        if (leftType != null) {
            DataFlowValue leftValue = DataFlowValueFactory.createDataFlowValue(left, leftType, context);
            DataFlowInfo rightDataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpInRight = KotlinBuiltIns.isNothing(rightType);
            DataFlowValue nullValue = DataFlowValue.nullValue(this.components.builtIns);
            if (jumpInRight || !rightDataFlowInfo.getStableNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, nullValue, this.components.languageVersionSettings);
                if (left instanceof KtBinaryExpressionWithTypeRHS) {
                    dataFlowInfo = BasicExpressionTypingVisitor.establishSubtypingForTypeRHS((KtBinaryExpressionWithTypeRHS)left, dataFlowInfo, context, this.components.languageVersionSettings);
                }
            }
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context);
            dataFlowInfo = dataFlowInfo.assign(resultValue, leftValue, this.components.languageVersionSettings).disequate(resultValue, nullValue, this.components.languageVersionSettings);
            if (!jumpInRight) {
                DataFlowValue rightValue = DataFlowValueFactory.createDataFlowValue(right, rightType, context);
                rightDataFlowInfo = rightDataFlowInfo.assign(resultValue, rightValue, this.components.languageVersionSettings);
                dataFlowInfo = dataFlowInfo.or(rightDataFlowInfo);
            }
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(69);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (KtExpression)expression, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context.dataFlowInfo);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(70);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private static DataFlowInfo establishSubtypingForTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS left, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionTypingContext context, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtExpression underSafeAs;
        KotlinType underSafeAsType;
        IElementType operationType;
        if (left == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(71);
        }
        if (dataFlowInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(72);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(73);
        }
        if (languageVersionSettings == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(74);
        }
        if ((operationType = left.getOperationReference().getReferencedNameElementType()) == KtTokens.AS_SAFE && (underSafeAsType = context.trace.getType(underSafeAs = left.getLeft())) != null) {
            DataFlowValue underSafeAsValue = DataFlowValueFactory.createDataFlowValue(underSafeAs, underSafeAsType, context);
            KotlinType targetType = context.trace.get(BindingContext.TYPE, left.getRight());
            if (targetType != null) {
                DataFlowInfo dataFlowInfo2 = dataFlowInfo.establishSubtyping(underSafeAsValue, targetType, languageVersionSettings);
                if (dataFlowInfo2 == null) {
                    BasicExpressionTypingVisitor.$$$reportNull$$$0(75);
                }
                return dataFlowInfo2;
            }
        }
        DataFlowInfo dataFlowInfo3 = dataFlowInfo;
        if (dataFlowInfo3 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(76);
        }
        return dataFlowInfo3;
    }

    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        if (callElement == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(77);
        }
        if (operationSign == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(78);
        }
        if (leftArgument == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(79);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(80);
        }
        KtExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(81);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorNameConventions.CONTAINS);
        KotlinType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context.contextDependency);
        this.ensureBooleanResult(operationSign, OperatorNameConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(82);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.clearType();
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(83);
        }
        return kotlinTypeInfo;
    }

    private boolean ensureBooleanResult(KtExpression operationSign, Name name, KotlinType resultType, ExpressionTypingContext context) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context);
    }

    private boolean ensureBooleanResultWithCustomSubject(KtExpression operationSign, KotlinType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression, final ExpressionTypingContext context) {
        KotlinType rightType;
        KtExpression left = expression.getLeft();
        if (left == null) {
            return;
        }
        KtExpression right = expression.getRight();
        KotlinType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, expression.getOperationReference(), leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression, left, right, context, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>(){

                @Override
                public KotlinType invoke(KtExpression expression) {
                    return BasicExpressionTypingVisitor.this.facade.getTypeInfo(expression, context).getType();
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(){

                @Override
                public Nullability invoke(DataFlowValue value) {
                    return context.dataFlowInfo.getStableNullability(value);
                }
            });
        }
    }

    @NotNull
    private KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo = this.assignmentIsNotAnExpressionError(expression, context);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(84);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitAssignment(KtBinaryExpression expression, ExpressionTypingContext context) {
        KotlinTypeInfo kotlinTypeInfo = this.assignmentIsNotAnExpressionError(expression, context);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(85);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo assignmentIsNotAnExpressionError(KtBinaryExpression expression, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression, context);
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(86);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(87);
        }
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression, context), (KtExpression)expression, (ResolutionContext)context);
    }

    @Override
    public KotlinTypeInfo visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(88);
        }
        return CollectionLiteralResolver.INSTANCE.resolveCollectionLiteral(expression, context, this.components.callResolver, this.components.builtIns, this.components.languageVersionSettings);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass2, ExpressionTypingContext context) {
        if (klass2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(89);
        }
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getOwnerDescriptor(), klass2);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(klass2, context);
    }

    @NotNull
    private static KotlinTypeInfo declarationInIllegalContext(@NotNull KtDeclaration declaration, @NotNull ExpressionTypingContext context) {
        if (declaration == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(90);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(91);
        }
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(declaration));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(92);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext context) {
        if (property == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(93);
        }
        this.components.localVariableResolver.process(property, context, context.scope, this.facade);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(property, context);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfoForBinaryCall(@NotNull Name name, @NotNull ExpressionTypingContext context, @NotNull KtBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        KtExpression left;
        if (name == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(94);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(95);
        }
        if (binaryExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(96);
        }
        KotlinTypeInfo typeInfo = (left = binaryExpression.getLeft()) != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryKt.noTypeInfo(context);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)contextWithDataFlow.replaceScope(context.scope), receiver, binaryExpression, name);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context.contextDependency));
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(97);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context) {
        if (dcl == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(98);
        }
        return BasicExpressionTypingVisitor.declarationInIllegalContext(dcl, context);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(99);
        }
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression, context);
        class StringTemplateVisitor
        extends KtVisitorVoid {
            private KotlinTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
                KtExpression entryExpression;
                if (entry == null) {
                    StringTemplateVisitor.$$$reportNull$$$0(0);
                }
                if ((entryExpression = entry.getExpression()) != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
                CompileTimeConstantChecker.CharacterWithDiagnostic value;
                Diagnostic diagnostic;
                if (entry == null) {
                    StringTemplateVisitor.$$$reportNull$$$0(1);
                }
                if ((diagnostic = (value = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry)).getDiagnostic()) != null) {
                    context.trace.report(diagnostic);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "entry";
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringTemplateEntryWithExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEscapeStringTemplateEntry";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (KtStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression, context.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (KtExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkLiteralPrefixAndSuffix(@NotNull PsiElement expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(100);
        }
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.prevLeaf(expression), context);
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.nextLeaf(expression), context);
    }

    private static void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, ExpressionTypingContext context) {
        if (BasicExpressionTypingVisitor.illegalLiteralPrefixOrSuffix(prefixOrSuffix)) {
            context.trace.report(Errors.UNSUPPORTED.on(prefixOrSuffix, "literal prefixes and suffixes"));
        }
    }

    private static boolean illegalLiteralPrefixOrSuffix(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(101);
        }
        return this.visitAnnotatedExpression(expression, context, false);
    }

    public KotlinTypeInfo visitAnnotatedExpression(KtAnnotatedExpression expression, ExpressionTypingContext context, boolean isStatement) {
        this.resolveAnnotationsOnExpression(expression, context);
        KtExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        return this.facade.getTypeInfo(baseExpression, context, isStatement);
    }

    protected void resolveAnnotationsOnExpression(KtAnnotatedExpression expression, ExpressionTypingContext context) {
        if (BasicExpressionTypingVisitor.isAnnotatedExpressionInBlockLevelBinary(expression)) {
            context.trace.report(Errors.ANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE.on(expression));
        }
        if (!(expression.getBaseExpression() instanceof KtObjectLiteralExpression)) {
            this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, expression.getAnnotationEntries(), context.trace);
        }
    }

    private static boolean isAnnotatedExpressionInBlockLevelBinary(KtAnnotatedExpression annotatedExpression) {
        PsiElement current = annotatedExpression;
        PsiElement parent2 = current.getParent();
        if (!(parent2 instanceof KtBinaryExpression)) {
            return false;
        }
        while (parent2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)parent2).getLeft() != current) {
                return false;
            }
            current = parent2;
            parent2 = parent2.getParent();
        }
        return KtPsiUtil.isStatementContainer(parent2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element, ExpressionTypingContext context) {
        if (element == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(102);
        }
        context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return TypeInfoFactoryKt.noTypeInfo(context);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(103);
        }
        if (rightHandSide == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(104);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(105);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(106);
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, false);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(107);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    KotlinTypeInfo resolveImplicitArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(108);
        }
        if (rightHandSide == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(109);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(110);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(111);
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false, true);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(112);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessGetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(113);
        }
        if (context == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(114);
        }
        KotlinTypeInfo kotlinTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true, false);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(115);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo resolveArrayAccessSpecialMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @Nullable KtExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet, boolean isImplicit) {
        KtExpression arrayExpression;
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(116);
        }
        if (oldContext == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(117);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(118);
        }
        if ((arrayExpression = arrayAccessExpression.getArrayExpression()) == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(oldContext);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(119);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        KotlinType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(arrayExpression, arrayType, context.trace.getBindingContext());
        if (!isGet) assert (rightHandSide != null);
        Call call2 = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context, call2, arrayAccessExpression, isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        List<KtExpression> indices = arrayAccessExpression.getIndexExpressions();
        KotlinTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context);
        }
        if (isImplicit && !functionResults.isSuccess() || !functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.clearType();
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(120);
            }
            return kotlinTypeInfo;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(121);
        }
        return kotlinTypeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 97: 
            case 107: 
            case 112: 
            case 115: 
            case 119: 
            case 120: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 97: 
            case 107: 
            case 112: 
            case 115: 
            case 119: 
            case 120: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 63: 
            case 87: 
            case 88: 
            case 99: 
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 19: 
            case 38: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 56: 
            case 58: 
            case 61: 
            case 73: 
            case 80: 
            case 91: 
            case 95: 
            case 105: 
            case 110: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 97: 
            case 107: 
            case 112: 
            case 115: 
            case 119: 
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 23: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeQualifier";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionWithParenthesis";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationExpression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyResolvedCall";
                break;
            }
            case 59: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSign";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextWithExpectedType";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftArgument";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dcl";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 103: 
            case 108: 
            case 113: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 104: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHandSide";
                break;
            }
            case 106: 
            case 111: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceForResolveResult";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToReceiver";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "visitLabeledExpression";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "visitComparison";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBooleanOperationExpression";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "visitElvisExpression";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "establishSubtypingForTypeRHS";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInExpression";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "visitAssignmentOperation";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "visitAssignment";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentIsNotAnExpressionError";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationInIllegalContext";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfoForBinaryCall";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArrayAccessSetMethod";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImplicitArrayAccessSetMethod";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArrayAccessGetMethod";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArrayAccessSpecialMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLValueOrUnsafeReceiver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDangerousWithNull";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscores";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 97: 
            case 107: 
            case 112: 
            case 115: 
            case 119: 
            case 120: 
            case 121: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkBinaryWithTypeRHS";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkResolvedExplicitlyQualifiedSupertype";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitExclExclExpression";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isKnownToBeNotNull";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkLValue";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySetterCall";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkIdentityOnPrimitiveTypes";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitComparison";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitBooleanOperationExpression";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitElvisExpression";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "establishSubtypingForTypeRHS";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "checkInExpression";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "visitCollectionLiteralExpression";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "declarationInIllegalContext";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoForBinaryCall";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "checkLiteralPrefixAndSuffix";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessSetMethod";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "resolveImplicitArrayAccessSetMethod";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessGetMethod";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessSpecialMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 43: 
            case 60: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: 
            case 97: 
            case 107: 
            case 112: 
            case 115: 
            case 119: 
            case 120: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

