/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.LegacyNumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyLongFieldMapper;
import org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public class LegacyDateFieldMapper
extends LegacyNumberFieldMapper {
    public static final String CONTENT_TYPE = "date";

    protected LegacyDateFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, includeInAll, indexSettings, multiFields, copyTo);
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String dateAsString = null;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            dateAsString = (String)externalValue;
            if (dateAsString == null) {
                dateAsString = this.fieldType().nullValueAsString();
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.fieldType().nullValueAsString();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                dateAsString = parser.text();
            } else if (token == XContentParser.Token.START_OBJECT && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.fieldType().nullValueAsString();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        Long value = null;
        if (dateAsString != null) {
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().name(), dateAsString, boost);
            }
            value = this.fieldType().parseStringValue(dateAsString);
        }
        if (value != null) {
            if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
                LegacyLongFieldMapper.CustomLongNumericField field = new LegacyLongFieldMapper.CustomLongNumericField(value, (MappedFieldType)this.fieldType());
                if (boost != 1.0f && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                    field.setBoost(boost);
                }
                fields.add((IndexableField)field);
            }
            if (this.fieldType().hasDocValues()) {
                this.addDocValue(context, fields, value);
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 16) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        builder.field("format", this.fieldType().dateTimeFormatter().format());
        if (includeDefaults || this.fieldType().nullValueAsString() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.fieldType().timeUnit() != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.fieldType().timeUnit().name().toLowerCase(Locale.ROOT));
        }
        if (this.fieldType().dateTimeFormatter().locale() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        } else if (includeDefaults) {
            if (this.fieldType().dateTimeFormatter().locale() == null) {
                builder.field("locale", Locale.ROOT);
            } else {
                builder.field("locale", this.fieldType().dateTimeFormatter().locale());
            }
        }
    }

    public static class DateFieldType
    extends LegacyNumberFieldMapper.NumberFieldType {
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected DateMathParser dateMathParser = new DateMathParser(this.dateTimeFormatter);

        public DateFieldType() {
            super(FieldType.LegacyNumericType.LONG);
        }

        protected DateFieldType(DateFieldType ref) {
            super(ref);
            this.dateTimeFormatter = ref.dateTimeFormatter;
            this.timeUnit = ref.timeUnit;
            this.dateMathParser = ref.dateMathParser;
        }

        @Override
        public DateFieldType clone() {
            return new DateFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            DateFieldType that = (DateFieldType)((Object)o);
            return Objects.equals(this.dateTimeFormatter.format(), that.dateTimeFormatter.format()) && Objects.equals(this.dateTimeFormatter.locale(), that.dateTimeFormatter.locale()) && Objects.equals((Object)this.timeUnit, (Object)that.timeUnit);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.dateTimeFormatter.format(), this.timeUnit});
        }

        @Override
        public String typeName() {
            return LegacyDateFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            if (strict) {
                DateFieldType other = (DateFieldType)fieldType;
                if (!Objects.equals(this.dateTimeFormatter().format(), other.dateTimeFormatter().format())) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [format] across all types.");
                }
                if (!Objects.equals(this.dateTimeFormatter().locale(), other.dateTimeFormatter().locale())) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [locale] across all types.");
                }
                if (!Objects.equals((Object)this.timeUnit(), (Object)other.timeUnit())) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [numeric_resolution] across all types.");
                }
            }
        }

        public FormatDateTimeFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = new DateMathParser(dateTimeFormatter);
        }

        public TimeUnit timeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.checkIfFrozen();
            this.timeUnit = timeUnit;
            this.dateMathParser = new DateMathParser(this.dateTimeFormatter);
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        private long parseValue(Object value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                return this.dateTimeFormatter().parser().parseMillis(((BytesRef)value).utf8ToString());
            }
            return this.dateTimeFormatter().parser().parseMillis(value.toString());
        }

        protected long parseStringValue(String value) {
            return this.dateTimeFormatter().parser().parseMillis(value);
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            LegacyNumericUtils.longToPrefixCoded((long)this.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().printer().print(val.longValue());
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, null, null, context);
        }

        @Override
        public FieldStats.Date stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos((IndexReader)reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            Terms terms = MultiFields.getTerms((IndexReader)reader, (String)this.name());
            if (terms == null) {
                return new FieldStats.Date(maxDoc, 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            long minValue = LegacyNumericUtils.getMinLong((Terms)terms);
            long maxValue = LegacyNumericUtils.getMaxLong((Terms)terms);
            return new FieldStats.Date(maxDoc, (long)terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), this.dateTimeFormatter(), minValue, maxValue);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            return this.innerRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser, context);
        }

        private Query innerRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, QueryRewriteContext context) {
            return LegacyNumericRangeQuery.newLongRange((String)this.name(), (int)this.numericPrecisionStep(), lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, !includeLower, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser, context)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, includeUpper, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser, context)), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            Terms terms;
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            if ((terms = MultiFields.getTerms((IndexReader)reader, (String)this.name())) == null) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LegacyNumericUtils.getMinLong((Terms)terms);
            long maxValue = LegacyNumericUtils.getMaxLong((Terms)terms);
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = this.parseToMilliseconds(from, !includeLower, timeZone, dateParser, context);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = this.parseToMilliseconds(to, includeUpper, timeZone, dateParser, context);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        public long parseToMilliseconds(Object value, boolean inclusive, @Nullable DateTimeZone zone, @Nullable DateMathParser forcedDateParser, QueryRewriteContext context) {
            if (value instanceof Long) {
                return (Long)value;
            }
            DateMathParser dateParser = this.dateMathParser();
            if (forcedDateParser != null) {
                dateParser = forcedDateParser;
            }
            String strValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return dateParser.parse(strValue, context::nowInMillis, inclusive, zone);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            FormatDateTimeFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = Joda.forPattern(format);
            }
            if (timeZone == null) {
                timeZone = DateTimeZone.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            boolean configuredFormat = false;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    configuredFormat = true;
                    iterator.remove();
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(LocaleUtils.parse(propNode.toString()));
                iterator.remove();
            }
            if (!configuredFormat) {
                builder.dateTimeFormatter(Defaults.DATE_TIME_FORMATTER);
            }
            return builder;
        }
    }

    public static class Builder
    extends LegacyNumberFieldMapper.Builder<Builder, LegacyDateFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        private Locale locale;

        public Builder(String name) {
            super(name, (MappedFieldType)Defaults.FIELD_TYPE, 16);
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public DateFieldType fieldType() {
            return (DateFieldType)this.fieldType;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.fieldType().setTimeUnit(timeUnit);
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        @Override
        public LegacyDateFieldMapper build(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().onOrAfter(Version.V_5_0_0_alpha2)) {
                throw new IllegalStateException("Cannot use legacy numeric types after 5.0");
            }
            this.setupFieldType(context);
            this.fieldType.setNullValue(this.nullValue);
            return new LegacyDateFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            FormatDateTimeFormatter dateTimeFormatter = this.fieldType().dateTimeFormatter;
            if (!this.locale.equals(dateTimeFormatter.locale())) {
                this.fieldType().setDateTimeFormatter(new FormatDateTimeFormatter(dateTimeFormatter.format(), dateTimeFormatter.parser(), dateTimeFormatter.printer(), this.locale));
            }
            super.setupFieldType(context);
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @Override
        protected int maxPrecisionStep() {
            return 64;
        }
    }

    public static class Defaults
    extends LegacyNumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("strict_date_optional_time||epoch_millis", Locale.ROOT);
        public static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
        public static final DateFieldType FIELD_TYPE = new DateFieldType();
        public static final String NULL_VALUE;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

