/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

public final class ENumeric
extends AExpression {
    private final String value;
    private int radix;

    public ENumeric(Location location, String value, int radix) {
        super(location);
        this.value = Objects.requireNonNull(value);
        this.radix = radix;
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from constant [" + this.value + "]."));
        }
        if (this.value.endsWith("d") || this.value.endsWith("D")) {
            if (this.radix != 10) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                this.constant = Double.parseDouble(this.value.substring(0, this.value.length() - 1));
                this.actual = Definition.DOUBLE_TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid double constant [" + this.value + "]."));
            }
        }
        if (this.value.endsWith("f") || this.value.endsWith("F")) {
            if (this.radix != 10) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            try {
                this.constant = Float.valueOf(Float.parseFloat(this.value.substring(0, this.value.length() - 1)));
                this.actual = Definition.FLOAT_TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid float constant [" + this.value + "]."));
            }
        }
        if (this.value.endsWith("l") || this.value.endsWith("L")) {
            try {
                this.constant = Long.parseLong(this.value.substring(0, this.value.length() - 1), this.radix);
                this.actual = Definition.LONG_TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid long constant [" + this.value + "]."));
            }
        }
        try {
            Definition.Sort sort = this.expected == null ? Definition.Sort.INT : this.expected.sort;
            int integer = Integer.parseInt(this.value, this.radix);
            if (sort == Definition.Sort.BYTE && integer >= -128 && integer <= 127) {
                this.constant = (byte)integer;
                this.actual = Definition.BYTE_TYPE;
            } else if (sort == Definition.Sort.CHAR && integer >= 0 && integer <= 65535) {
                this.constant = Character.valueOf((char)integer);
                this.actual = Definition.CHAR_TYPE;
            } else if (sort == Definition.Sort.SHORT && integer >= Short.MIN_VALUE && integer <= Short.MAX_VALUE) {
                this.constant = (short)integer;
                this.actual = Definition.SHORT_TYPE;
            } else {
                this.constant = integer;
                this.actual = Definition.INT_TYPE;
            }
        }
        catch (NumberFormatException exception) {
            try {
                Long.parseLong(this.value, this.radix);
                throw this.createError(new IllegalArgumentException("Invalid int constant [" + this.value + "]. If you want a long constant then change it to [" + this.value + "L]."));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.createError(new IllegalArgumentException("Invalid int constant [" + this.value + "]."));
            }
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    public String toString() {
        if (this.radix != 10) {
            return this.singleLineToString(this.value, this.radix);
        }
        return this.singleLineToString(this.value);
    }
}

