/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.GraphicalCompositeFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import ch.ehi.basics.types.NlsString;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.SeparatorFigure;
import ch.ehi.umleditor.umlpresentation.Note;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;

public class NoteFigure
extends NodeFigure {
    private TextFigure textFigure;

    public NoteFigure() {
        this(new RectangleFigure());
    }

    private NoteFigure(Figure newPresentationFigure) {
        super(newPresentationFigure);
    }

    @Override
    protected JPopupMenu adaptPopupMenu(JPopupMenu popupMenu) {
        this.addFormatMenu(popupMenu);
        this.addEditMenu(popupMenu);
        popupMenu.setLightWeightPopupEnabled(true);
        return popupMenu;
    }

    @Override
    public void draw(Graphics g) {
        g.setColor((Color)this.getAttribute("FrameColor"));
        super.draw(g);
        Rectangle rectangle = this.displayBox();
        int cutOffWidth = 10;
        int leftX = rectangle.x + rectangle.width - cutOffWidth;
        int rightX = rectangle.x + rectangle.width - 1;
        int bottomY = rectangle.y + cutOffWidth - 1;
        g.drawLine(leftX, rectangle.y, rightX, bottomY);
        g.drawLine(leftX, rectangle.y, leftX, bottomY);
        g.drawLine(leftX, bottomY, rightX, bottomY);
        g.setColor(Color.WHITE);
        g.drawLine(leftX, rectangle.y, rightX, rectangle.y);
        g.drawLine(rightX, rectangle.y, rightX, bottomY);
    }

    @Override
    protected void initialize() {
        this.removeAll();
        this.textFigure = new TextFigure(){

            @Override
            public void setText(String newText) {
                super.setText(newText);
                NoteFigure.this.updateName(newText);
                NoteFigure.this.update();
            }
        };
        this.textFigure.setFont(this.getFont());
        SeparatorFigure separator = new SeparatorFigure();
        separator.setLineVisible(false);
        GraphicalCompositeFigure infoFigure = new GraphicalCompositeFigure(separator);
        infoFigure.add(this.textFigure);
        infoFigure.getLayouter().setInsets(new Insets(10, 2, 2, 2));
        this.add(infoFigure);
        super.initialize();
    }

    @Override
    protected boolean updateName(String newText) {
        if (this.getNode() != null && !newText.equals(ElementUtils.mapNlsString(((Note)this.getNode()).getContent()))) {
            ((Note)this.getNode()).setContent(new NlsString(((Note)this.getNode()).getContent(), newText));
        }
        return true;
    }

    @Override
    public void updateView() {
        super.updateView();
        this.textFigure.setText(ElementUtils.mapNlsString(((Note)this.getNode()).getContent()));
    }
}

