/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.xmiuml.ehi;

import ch.ehi.basics.types.NlsString;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XMLInterlisEncoder {
    private HashMap getters = new HashMap();
    private HashMap iterators = new HashMap();
    private HashMap codelists = new HashMap();
    private int objid = 0;
    private Map object2Id = new HashMap();
    private Set pendingObjects = new HashSet();
    private Writer out;
    private static String nl = null;
    private int lineNumber;

    private void analyzeClass(Class aclass) {
        if (this.getters.containsKey(aclass)) {
            return;
        }
        if (this.iterators.containsKey(aclass)) {
            return;
        }
        if (this.codelists.containsKey(aclass)) {
            return;
        }
        if (aclass.getName().equals("java.lang.String")) {
            return;
        }
        if (XMLInterlisEncoder.isBuiltinClass(aclass)) {
            return;
        }
        if (aclass.isPrimitive()) {
            return;
        }
        HashMap<String, Method> methodSet = new HashMap<String, Method>();
        Method[] methods = aclass.getMethods();
        for (int a = 0; a < methods.length; ++a) {
            methodSet.put(methods[a].getName(), methods[a]);
        }
        ArrayList<GetterEntry> getterList = new ArrayList<GetterEntry>();
        ArrayList<Method> iteratorList = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            String attrName;
            if (methods[i].getName().startsWith("get")) {
                attrName = methods[i].getName().substring(3);
                if (methodSet.containsKey("attach" + attrName)) {
                    if (methodSet.containsKey("attach" + attrName + "Link")) continue;
                    if (attrName.endsWith("Link")) {
                        getterList.add(new GetterEntry(attrName, methods[i], (Method)methodSet.get("contains" + attrName.substring(0, attrName.length() - 4))));
                        continue;
                    }
                    getterList.add(new GetterEntry(attrName, methods[i], (Method)methodSet.get("contains" + attrName)));
                    continue;
                }
                if (methodSet.containsKey("set" + attrName)) {
                    getterList.add(new GetterEntry(attrName, methods[i], null));
                    continue;
                }
                if (!methodSet.containsKey("getList") || !methodSet.containsKey("createBuiltin") || !methods[i].getName().endsWith("Code")) continue;
                this.codelists.put(aclass, methods[i]);
                return;
            }
            if (methods[i].getName().startsWith("iterator")) {
                attrName = methods[i].getName().substring(8);
                if (!methodSet.containsKey("add" + attrName) || methodSet.containsKey("iterator" + attrName + "Link")) continue;
                iteratorList.add(methods[i]);
                continue;
            }
            if (!methods[i].getName().startsWith("is") || methods[i].getReturnType() != Boolean.TYPE) continue;
            attrName = methods[i].getName().substring(2);
            if (!methodSet.containsKey("set" + attrName)) continue;
            getterList.add(new GetterEntry(attrName, methods[i], null));
        }
        this.getters.put(aclass, getterList);
        this.iterators.put(aclass, iteratorList);
    }

    private void visitObject(Object obj) throws IOException, IllegalAccessException, InvocationTargetException {
        int thisobjid = (Integer)this.object2Id.get(obj);
        if (obj instanceof NlsString) {
            return;
        }
        this.analyzeClass(obj.getClass());
        if (this.isCodeList(obj.getClass())) {
            return;
        }
        List getterList = (List)this.getters.get(obj.getClass());
        List iteratorList = (List)this.iterators.get(obj.getClass());
        Object value = null;
        Object bufferedValue = null;
        Object methodName = null;
        Object bufferedIterator = null;
        HashMap containsMap = new HashMap();
        boolean contains = false;
        Object bContains = null;
        Object containsObj = null;
        Object codeValue = null;
        boolean code = false;
        Object linkedObject = null;
        for (GetterEntry getter : getterList) {
            Method method = getter.get;
            if (method.getReturnType().isPrimitive() || method.getReturnType() == String.class || XMLInterlisEncoder.isBuiltinClass(method.getReturnType()) || this.isReturnTypeCodeList(method) || getter.contains != null && !this.executeContains(obj, getter.contains) || (value = method.invoke(obj, null)) == null || this.object2Id.containsKey(value)) continue;
            this.addPendingObject(value);
        }
        for (Method method : iteratorList) {
            value = method.invoke(obj, null);
            Iterator thisit = (Iterator)value;
            while (thisit.hasNext()) {
                value = thisit.next();
                if (XMLInterlisEncoder.isBuiltinClass(value.getClass()) || value.getClass() == String.class || this.isCodeList(value.getClass()) || this.object2Id.containsKey(value)) continue;
                this.addPendingObject(value);
            }
        }
    }

    private void writeObject(Object obj) throws IOException, IllegalAccessException, InvocationTargetException {
        int thisobjid = (Integer)this.object2Id.get(obj);
        if (obj instanceof NlsString) {
            this.out.write("<" + obj.getClass().getName() + " TID=" + '\"' + thisobjid + '\"' + ">");
            this.newline();
            NlsString nlsString = (NlsString)obj;
            Map allValues = nlsString.getAllValues();
            for (String language : allValues.keySet()) {
                String value = (String)allValues.get(language);
                this.out.write("<Entry TID=\"" + this.objid++ + "\" language=\"" + XMLInterlisEncoder.encodeString(language) + "\" translation=\"" + XMLInterlisEncoder.encodeString(value) + "\"/>");
                this.newline();
            }
            this.out.write("</" + obj.getClass().getName() + ">");
            this.newline();
            return;
        }
        List getterList = (List)this.getters.get(obj.getClass());
        List iteratorList = (List)this.iterators.get(obj.getClass());
        Object value = null;
        this.out.write("<" + obj.getClass().getName() + " TID=" + '\"' + thisobjid + '\"' + ">");
        this.newline();
        for (GetterEntry getter : getterList) {
            Method method = getter.get;
            if (getter.contains != null && !this.executeContains(obj, getter.contains) || (value = method.invoke(obj, null)) == null) continue;
            if (this.isReturnTypeCodeList(method)) {
                this.out.write("<" + getter.name + ">" + this.getCodeListValue(value) + "</" + getter.name + ">");
                this.newline();
                continue;
            }
            if (method.getReturnType().isPrimitive() || method.getReturnType() == String.class || XMLInterlisEncoder.isBuiltinClass(method.getReturnType())) {
                this.out.write("<" + getter.name + ">" + XMLInterlisEncoder.encodeString(value.toString()) + "</" + getter.name + ">");
                this.newline();
                continue;
            }
            this.out.write("<" + getter.name + ">" + this.object2Id.get(value) + "</" + getter.name + ">");
            this.newline();
        }
        for (Method method : iteratorList) {
            value = method.invoke(obj, null);
            Iterator thisit = (Iterator)value;
            while (thisit.hasNext()) {
                value = thisit.next();
                if (XMLInterlisEncoder.isBuiltinClass(value.getClass())) {
                    this.out.write("<" + method.getName().substring(8) + ">" + value + "</" + method.getName().substring(8) + ">");
                    this.newline();
                    continue;
                }
                if (value.getClass() == String.class) {
                    this.out.write("<" + method.getName().substring(8) + ">" + value + "</" + method.getName().substring(8) + ">");
                    this.newline();
                    continue;
                }
                if (this.isCodeList(value.getClass())) {
                    this.out.write("<" + method.getName().substring(8) + ">" + this.getCodeListValue(value) + "</" + method.getName().substring(8) + ">");
                    this.newline();
                    continue;
                }
                this.out.write("<" + method.getName().substring(8) + ">" + this.object2Id.get(value) + "</" + method.getName().substring(8) + ">");
                this.newline();
            }
        }
        this.out.write("</" + obj.getClass().getName() + ">");
        this.newline();
    }

    private static String getClassNameOnly(Class aclass) {
        StringBuffer className = new StringBuffer(aclass.getName());
        className.delete(0, aclass.getName().lastIndexOf(46) + 1);
        return className.toString();
    }

    public void encode(Object rootObj, Writer out, String version) throws IOException {
        this.out = out;
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.newline();
        if (version.equals("1.0")) {
            out.write("<ch.ehi.umleditor.1>");
            this.newline();
        } else {
            out.write("<ch.ehi.umleditor xmlns=\"http://schemas.umleditor.org/umleditor/1.1\">");
            this.newline();
        }
        try {
            this.addPendingObject(rootObj);
            while (this.pendingObjects.size() > 0) {
                Object next = this.pendingObjects.iterator().next();
                this.visitObject(next);
                if (next != rootObj) {
                    this.writeObject(next);
                }
                this.pendingObjects.remove(next);
            }
            this.writeObject(rootObj);
            if (version.equals("1.0")) {
                out.write("</ch.ehi.umleditor.1>");
                this.newline();
            } else {
                out.write("</ch.ehi.umleditor>");
                this.newline();
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        catch (InvocationTargetException ex) {
            throw new IOException(ex.getTargetException().getLocalizedMessage());
        }
    }

    public void encode(Object obj, String path) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(path));
        this.encode(obj, out, path.endsWith("-uml1.uml") ? "1.0" : "1.1");
        ((Writer)out).close();
    }

    private static boolean isBuiltinClass(Class aclass) {
        String name = aclass.getName();
        return name.equals("java.lang.Boolean") || name.equals("java.lang.Character") || name.equals("java.lang.Byte") || name.equals("java.lang.Short") || name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Float") || name.equals("java.lang.Double");
    }

    private boolean isReturnTypeCodeList(Method method) {
        return this.isCodeList(method.getReturnType());
    }

    private boolean isCodeList(Class aclass) {
        return this.codelists.containsKey(aclass);
    }

    private void addPendingObject(Object obj) {
        if (this.pendingObjects.contains(obj)) {
            return;
        }
        if (obj.getClass() == String.class) {
            return;
        }
        int thisobjid = this.objid++;
        this.object2Id.put(obj, new Integer(thisobjid));
        this.pendingObjects.add(obj);
    }

    private Object getCodeListValue(Object obj) throws InvocationTargetException, IllegalAccessException {
        Method method = (Method)this.codelists.get(obj.getClass());
        Object codeValue = method.invoke(obj, null);
        return codeValue;
    }

    private boolean executeContains(Object obj, Method containsMethod) throws IllegalAccessException, InvocationTargetException {
        Object containsValue = containsMethod.invoke(obj, null);
        return containsValue.toString() == "true";
    }

    private static String encodeString(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '<') {
                str.append("&lt;");
                continue;
            }
            if (ch == '>') {
                str.append("&gt;");
                continue;
            }
            if (ch == '&') {
                str.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                str.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                str.append("&quot;");
                continue;
            }
            if (ch >= '\u0080' || ch == '\r' || ch == '\n') {
                str.append("&#");
                str.append(Integer.toString(ch));
                str.append(';');
                continue;
            }
            str.append(ch);
        }
        return str.toString();
    }

    private void newline() throws IOException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        this.out.write(nl);
        ++this.lineNumber;
    }

    private class GetterEntry {
        public String name;
        public Method get;
        public Method contains;

        GetterEntry(String name, Method get, Method contains) {
            this.name = name;
            this.get = get;
            this.contains = contains;
        }
    }
}

