/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.util.Arrays;
import org.apache.batik.ext.awt.geom.Segment;

public abstract class AbstractSegment
implements Segment {
    static final double eps = 3.552713678800501E-15;
    static final double tol = 1.4210854715202004E-14;

    protected abstract int findRoots(double var1, double[] var3);

    @Override
    public Segment.SplitResults split(double d) {
        Segment[] segmentArray;
        int n;
        Segment[] segmentArray2;
        double d2;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        int n2 = this.findRoots(d, dArray);
        if (n2 == 0) {
            return null;
        }
        Arrays.sort(dArray, 0, n2);
        double[] dArray2 = new double[n2 + 2];
        int n3 = 0;
        dArray2[n3++] = 0.0;
        for (int i = 0; i < n2; ++i) {
            d2 = dArray[i];
            if (d2 <= 0.0) continue;
            if (d2 >= 1.0) break;
            if (dArray2[n3 - 1] == d2) continue;
            dArray2[n3++] = d2;
        }
        dArray2[n3++] = 1.0;
        if (n3 == 2) {
            return null;
        }
        Segment[] segmentArray3 = new Segment[n3];
        d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 1; i < n3; ++i) {
            segmentArray3[n4] = this.getSegment(dArray2[i - 1], dArray2[i]);
            segmentArray2 = segmentArray3[n4].eval(0.5);
            if (n4 == 0) {
                ++n4;
                n6 = segmentArray2.y < d ? 1 : 0;
                n5 = n6;
                continue;
            }
            int n7 = n = segmentArray2.y < d ? 1 : 0;
            if (n6 == n) {
                segmentArray3[n4 - 1] = this.getSegment(d2, dArray2[i]);
                continue;
            }
            ++n4;
            d2 = dArray2[i - 1];
            n6 = n;
        }
        if (n4 == 1) {
            return null;
        }
        if (n5 != 0) {
            segmentArray2 = new Segment[(n4 + 1) / 2];
            segmentArray = new Segment[n4 / 2];
        } else {
            segmentArray2 = new Segment[n4 / 2];
            segmentArray = new Segment[(n4 + 1) / 2];
        }
        n = 0;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            if (n5 != 0) {
                segmentArray2[n++] = segmentArray3[i];
            } else {
                segmentArray[n8++] = segmentArray3[i];
            }
            n5 = n5 == 0 ? 1 : 0;
        }
        return new Segment.SplitResults(segmentArray, segmentArray2);
    }

    @Override
    public Segment splitBefore(double d) {
        return this.getSegment(0.0, d);
    }

    @Override
    public Segment splitAfter(double d) {
        return this.getSegment(d, 1.0);
    }

    public static int solveLine(double d, double d2, double[] dArray) {
        if (d == 0.0) {
            if (d2 != 0.0) {
                return 0;
            }
            dArray[0] = 0.0;
            return 1;
        }
        dArray[0] = -d2 / d;
        return 1;
    }

    public static int solveQuad(double d, double d2, double d3, double[] dArray) {
        if (d == 0.0) {
            return AbstractSegment.solveLine(d2, d3, dArray);
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (Math.abs(d4) <= 1.4210854715202004E-14 * d2 * d2) {
            dArray[0] = -d2 / (2.0 * d);
            return 1;
        }
        if (d4 < 0.0) {
            return 0;
        }
        d4 = Math.sqrt(d4);
        double d5 = -(d2 + AbstractSegment.matchSign(d4, d2));
        dArray[0] = 2.0 * d3 / d5;
        dArray[1] = d5 / (2.0 * d);
        return 2;
    }

    public static double matchSign(double d, double d2) {
        if (d2 < 0.0) {
            return d < 0.0 ? d : -d;
        }
        return d > 0.0 ? d : -d;
    }

    public static int solveCubic(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        int n = AbstractSegment.solveQuad(3.0 * d, 2.0 * d2, d3, dArray2);
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0, 0.0, 0.0};
        int n2 = 0;
        dArray3[n2] = d4;
        dArray4[n2++] = 0.0;
        switch (n) {
            case 1: {
                double d5 = dArray2[0];
                if (!(d5 > 0.0) || !(d5 < 1.0)) break;
                dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                dArray4[n2++] = d5;
                break;
            }
            case 2: {
                double d5;
                if (dArray2[0] > dArray2[1]) {
                    double d6 = dArray2[0];
                    dArray2[0] = dArray2[1];
                    dArray2[1] = d6;
                }
                if ((d5 = dArray2[0]) > 0.0 && d5 < 1.0) {
                    dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                    dArray4[n2++] = d5;
                }
                if (!((d5 = dArray2[1]) > 0.0) || !(d5 < 1.0)) break;
                dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                dArray4[n2++] = d5;
                break;
            }
        }
        dArray3[n2] = d + d2 + d3 + d4;
        dArray4[n2++] = 1.0;
        int n3 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            int n4;
            double d7;
            double d8 = dArray3[i];
            double d9 = dArray4[i];
            double d10 = dArray3[i + 1];
            double d11 = dArray4[i + 1];
            if (d8 < 0.0 && d10 < 0.0 || d8 > 0.0 && d10 > 0.0) continue;
            if (d8 > d10) {
                d7 = d8;
                d8 = d10;
                d10 = d7;
                d7 = d9;
                d9 = d11;
                d11 = d7;
            }
            if (-d8 < 1.4210854715202004E-14 * d10) {
                dArray[n3++] = d9;
                continue;
            }
            if (d10 < -1.4210854715202004E-14 * d8) {
                dArray[n3++] = d11;
                ++i;
                continue;
            }
            d7 = 1.4210854715202004E-14 * (d10 - d8);
            for (n4 = 0; n4 < 20; ++n4) {
                double d12 = d11 - d9;
                double d13 = d10 - d8;
                double d14 = d9 + (Math.abs(d8 / d13) * 99.0 + 0.5) * d12 / 100.0;
                double d15 = ((d * d14 + d2) * d14 + d3) * d14 + d4;
                if (Math.abs(d15) < d7) {
                    dArray[n3++] = d14;
                    break;
                }
                if (d15 < 0.0) {
                    d9 = d14;
                    d8 = d15;
                    continue;
                }
                d11 = d14;
                d10 = d15;
            }
            if (n4 != 20) continue;
            dArray[n3++] = (d9 + d11) / 2.0;
        }
        return n3;
    }
}

