/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.raw;

import java.awt.Image;
import java.io.IOException;
import java.util.Map;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.namespace.DefaultNamespaceCollection;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.namespace.Namespaces;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.util.AttributeNameGenerator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class XmlPrintReportTarget
implements ReportTarget {
    private ReportJob reportJob;
    private XmlWriter writer;
    private NamespaceCollection namespaces;
    private AttributeNameGenerator namespacePrefixGenerator;

    public XmlPrintReportTarget(ReportJob reportJob, XmlWriter xmlWriter) {
        this.reportJob = reportJob;
        this.writer = xmlWriter;
        NamespaceDefinition[] namespaceDefinitionArray = Namespaces.createFromConfig((Configuration)this.reportJob.getConfiguration(), (String)"org.jfree.report.namespaces.", null);
        NamespaceDefinition[] namespaceDefinitionArray2 = Namespaces.createFromConfig((Configuration)LibLayoutBoot.getInstance().getGlobalConfig(), (String)"org.jfree.layouting.namespaces.", null);
        DefaultNamespaceCollection defaultNamespaceCollection = new DefaultNamespaceCollection();
        defaultNamespaceCollection.addDefinitions(namespaceDefinitionArray);
        defaultNamespaceCollection.addDefinitions(namespaceDefinitionArray2);
        this.namespaces = defaultNamespaceCollection;
        this.namespacePrefixGenerator = new AttributeNameGenerator();
    }

    public ReportJob getReportJob() {
        return this.reportJob;
    }

    public void startReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeComment("starting report");
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IOError", iOException);
        }
    }

    public void startElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        String string = ReportTargetUtil.getNamespaceFromAttribute(attributeMap);
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute(attributeMap);
        try {
            AttributeList attributeList = this.buildAttributeList(attributeMap);
            this.validateNamespace(string, attributeList);
            this.writer.writeTag(string, string2, attributeList, false);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IOError", iOException);
        }
    }

    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        Object object = dataFlags.getValue();
        if (object == null) {
            return;
        }
        if (object instanceof Image) {
            return;
        }
        try {
            String string = String.valueOf(object);
            this.writer.writeTextNormalized(string, false);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("Failed", iOException);
        }
    }

    public void endElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeCloseTag();
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IOError", iOException);
        }
    }

    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeComment("starting report");
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IOError", iOException);
        }
    }

    public NamespaceDefinition getNamespaceByUri(String string) {
        return this.namespaces.getDefinition(string);
    }

    public void processText(String string) throws DataSourceException, ReportProcessingException {
        try {
            this.writer.writeTextNormalized(string, false);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IOError", iOException);
        }
    }

    public void commit() throws ReportProcessingException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("Failed to flush", iOException);
        }
    }

    public String getExportDescriptor() {
        return "raw/text+xml";
    }

    protected AttributeList buildAttributeList(AttributeMap attributeMap) {
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributeMap.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.isInternalNamespace(string)) continue;
            Map map = attributeMap.getAttributes(string);
            for (Map.Entry entry : map.entrySet()) {
                String string2 = String.valueOf(entry.getKey());
                this.validateNamespace(string, attributeList);
                attributeList.setAttribute(string, string2, String.valueOf(entry.getValue()));
            }
        }
        return attributeList;
    }

    private void validateNamespace(String string, AttributeList attributeList) {
        if (this.writer.isNamespaceDefined(string)) {
            return;
        }
        if (attributeList.isNamespaceUriDefined(string)) {
            return;
        }
        NamespaceDefinition namespaceDefinition = this.getNamespaceByUri(string);
        if (namespaceDefinition != null) {
            String string2 = namespaceDefinition.getPreferredPrefix();
            if (!this.writer.isNamespacePrefixDefined(string2) && !attributeList.isNamespacePrefixDefined(string2)) {
                attributeList.addNamespaceDeclaration(string2, string);
            } else {
                attributeList.addNamespaceDeclaration(this.namespacePrefixGenerator.generateName(string2), string);
            }
        } else {
            attributeList.addNamespaceDeclaration(this.namespacePrefixGenerator.generateName("auto"), string);
        }
    }

    private boolean isInternalNamespace(String string) {
        return "http://jfreereport.sourceforge.net/namespaces/engine".equals(string);
    }
}

