/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XOMFontInfo
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 12;
    }

    @Override
    public int getDataSize() {
        return XOMFontInfo.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XOMFontInfo(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XOMFontInfo() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XOMFontInfo.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_num_font() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_num_font(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_font_struct_list(int index) {
        log.finest("");
        return Native.getLong(this.pData + 4L) + (long)(index * Native.getLongSize());
    }

    public long get_font_struct_list() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_font_struct_list(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public long get_font_name_list(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) + (long)(index * Native.getLongSize());
    }

    public long get_font_name_list() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_font_name_list(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    @Override
    String getName() {
        return "XOMFontInfo";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(120);
        ret.append("num_font = ").append(this.get_num_font()).append(", ");
        ret.append("font_struct_list = ").append(this.get_font_struct_list()).append(", ");
        ret.append("font_name_list = ").append(this.get_font_name_list()).append(", ");
        return ret.toString();
    }
}

