/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;

public class JExtendedRadioButton
extends JRadioButton {
    private Icon extraIcon;

    public JExtendedRadioButton(Icon icon) {
        this.setExtraIcon(icon);
    }

    public JExtendedRadioButton(String string) {
        super(string);
    }

    public JExtendedRadioButton(String string, Icon icon) {
        this(string);
        this.setExtraIcon(icon);
    }

    public void setExtraIcon(Icon icon) {
        if (!JExtendedRadioButton.isSupportedLaF()) {
            return;
        }
        this.extraIcon = icon;
        if (icon != null) {
            this.createExtraIcon();
        } else {
            this.resetExtraIcon();
        }
    }

    public Icon getExtraIcon() {
        return this.extraIcon;
    }

    private static Icon getDefaultIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    private static Icon getDisabledIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getDisabledIcon();
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static Icon getDisabledSelectedIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getDisabledSelectedIcon();
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static Icon getIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        return icon != null ? icon : JExtendedRadioButton.getDefaultIcon();
    }

    private static Icon getPressedIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getPressedIcon();
        if (icon2 == null) {
            icon2 = jRadioButton.getSelectedIcon();
        }
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static Icon getRolloverIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getRolloverIcon();
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static Icon getRolloverSelectedIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getRolloverSelectedIcon();
        if (icon2 == null) {
            icon2 = jRadioButton.getSelectedIcon();
        }
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static Icon getSelectedIconSafe(JRadioButton jRadioButton) {
        Icon icon = jRadioButton.getIcon();
        if (icon == null) {
            return JExtendedRadioButton.getDefaultIcon();
        }
        Icon icon2 = jRadioButton.getSelectedIcon();
        return icon2 != null ? icon2 : JExtendedRadioButton.getIconSafe(jRadioButton);
    }

    private static boolean isSupportedLaF() {
        return !UIUtils.isGTKLookAndFeel() && !UIUtils.isAquaLookAndFeel();
    }

    private void createExtraIcon() {
        JRadioButton jRadioButton = new JRadioButton();
        int n = jRadioButton.getIconTextGap();
        Icon icon = JExtendedRadioButton.getDisabledIconSafe(jRadioButton);
        Icon icon2 = JExtendedRadioButton.getDisabledSelectedIconSafe(jRadioButton);
        Icon icon3 = JExtendedRadioButton.getIconSafe(jRadioButton);
        Icon icon4 = JExtendedRadioButton.getPressedIconSafe(jRadioButton);
        Icon icon5 = JExtendedRadioButton.getRolloverIconSafe(jRadioButton);
        Icon icon6 = JExtendedRadioButton.getRolloverSelectedIconSafe(jRadioButton);
        Icon icon7 = JExtendedRadioButton.getSelectedIconSafe(jRadioButton);
        this.setDisabledIcon(icon == null ? this.extraIcon : new DoubleIcon(icon, this.extraIcon, n));
        this.setDisabledSelectedIcon(icon2 == null ? this.extraIcon : new DoubleIcon(icon2, this.extraIcon, n));
        this.setIcon(icon3 == null ? this.extraIcon : new DoubleIcon(icon3, this.extraIcon, n));
        this.setPressedIcon(icon4 == null ? this.extraIcon : new DoubleIcon(icon4, this.extraIcon, n));
        this.setRolloverIcon(icon5 == null ? this.extraIcon : new DoubleIcon(icon5, this.extraIcon, n));
        this.setRolloverSelectedIcon(icon6 == null ? this.extraIcon : new DoubleIcon(icon6, this.extraIcon, n));
        this.setSelectedIcon(icon7 == null ? this.extraIcon : new DoubleIcon(icon7, this.extraIcon, n));
    }

    private void resetExtraIcon() {
        JRadioButton jRadioButton = new JRadioButton();
        this.setDisabledIcon(jRadioButton.getDisabledIcon());
        this.setDisabledSelectedIcon(jRadioButton.getDisabledSelectedIcon());
        this.setIcon(jRadioButton.getIcon());
        this.setPressedIcon(jRadioButton.getPressedIcon());
        this.setRolloverIcon(jRadioButton.getRolloverIcon());
        this.setRolloverSelectedIcon(jRadioButton.getRolloverSelectedIcon());
        this.setSelectedIcon(jRadioButton.getSelectedIcon());
    }

    public static class DoubleIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int icon1VertOffset = 0;
        private int icon2HorzOffset;
        private int icon2VertOffset = 0;
        private int iconHeight;
        private int iconWidth;
        private int iconsGap;

        public DoubleIcon(Icon icon, Icon icon2, int n) {
            this.icon1 = icon;
            this.icon2 = icon2;
            this.iconsGap = n;
            this.initInternals();
        }

        public Icon getIcon1() {
            return this.icon1;
        }

        public Icon getIcon2() {
            return this.icon2;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        public int getIconsGap() {
            return this.iconsGap;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2 + this.icon1VertOffset);
            this.icon2.paintIcon(component, graphics, n + this.icon2HorzOffset, n2 + this.icon2VertOffset);
        }

        private void initInternals() {
            int n = this.icon1.getIconWidth();
            int n2 = this.icon1.getIconHeight();
            int n3 = this.icon2.getIconHeight();
            this.iconWidth = n + this.icon2.getIconWidth() + this.iconsGap;
            this.iconHeight = Math.max(n2, n3);
            if (n2 > n3) {
                this.icon2VertOffset = (int)Math.ceil((float)(n2 - n3) / 2.0f);
            } else if (n2 < n3) {
                this.icon1VertOffset = (int)Math.ceil((float)(n3 - n2) / 2.0f);
            }
            this.icon2HorzOffset = n + this.iconsGap;
        }
    }
}

