/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.BorderedComponent;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class MemoryTab
extends Tab
implements ActionListener,
ItemListener {
    JComboBox<Plotter> plotterChoice;
    TimeComboBox timeComboBox;
    JButton gcButton;
    PlotterPanel plotterPanel;
    JPanel bottomPanel;
    HTMLPane details;
    PoolChart poolChart;
    ArrayList<Plotter> plotterList;
    Plotter heapPlotter;
    Plotter nonHeapPlotter;
    private MemoryOverviewPanel overviewPanel;
    private static final String usedKey = "used";
    private static final String committedKey = "committed";
    private static final String maxKey = "max";
    private static final String thresholdKey = "threshold";
    private static final Color usedColor = Plotter.defaultColor;
    private static final Color committedColor = null;
    private static final Color maxColor = null;
    private static final Color thresholdColor = Color.red;

    public static String getTabName() {
        return Messages.MEMORY;
    }

    public MemoryTab(VMPanel vmPanel) {
        super(vmPanel, MemoryTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel topPanel = new JPanel(new BorderLayout());
        this.plotterPanel = new PlotterPanel(null);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)this.plotterPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(3, 20, 5));
        topPanel.add((Component)controlPanel, "Center");
        this.plotterChoice = new JComboBox();
        this.plotterChoice.addItemListener(this);
        controlPanel.add(new LabeledComponent(Messages.CHART_COLON, Resources.getMnemonicInt(Messages.CHART_COLON), this.plotterChoice));
        this.timeComboBox = new TimeComboBox(new Plotter[0]);
        controlPanel.add(new LabeledComponent(Messages.TIME_RANGE_COLON, Resources.getMnemonicInt(Messages.TIME_RANGE_COLON), this.timeComboBox));
        this.gcButton = new JButton(Messages.PERFORM_GC);
        this.gcButton.setMnemonic(Resources.getMnemonicInt(Messages.PERFORM_GC));
        this.gcButton.addActionListener(this);
        this.gcButton.setToolTipText(Messages.PERFORM_GC_TOOLTIP);
        JPanel topRightPanel = new JPanel();
        topRightPanel.setBorder(new EmptyBorder(0, 57, 0, 70));
        topRightPanel.add(this.gcButton);
        topPanel.add((Component)topRightPanel, "After");
        this.bottomPanel.setBorder(new CompoundBorder(new TitledBorder(Messages.DETAILS), new EmptyBorder(10, 10, 10, 10)));
        this.details = new HTMLPane();
        Utilities.setAccessibleName(this.details, Messages.DETAILS);
        this.bottomPanel.add((Component)new JScrollPane(this.details), "Center");
        this.poolChart = new PoolChart();
        this.bottomPanel.add((Component)this.poolChart, "After");
    }

    private void createPlotters() throws IOException {
        this.plotterList = new ArrayList();
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        this.heapPlotter = new Plotter(Plotter.Unit.BYTES){

            @Override
            public String toString() {
                return Messages.HEAP_MEMORY_USAGE;
            }
        };
        proxyClient.addWeakPropertyChangeListener(this.heapPlotter);
        this.nonHeapPlotter = new Plotter(Plotter.Unit.BYTES){

            @Override
            public String toString() {
                return Messages.NON_HEAP_MEMORY_USAGE;
            }
        };
        Utilities.setAccessibleName(this.heapPlotter, Messages.MEMORY_TAB_HEAP_PLOTTER_ACCESSIBLE_NAME);
        Utilities.setAccessibleName(this.nonHeapPlotter, Messages.MEMORY_TAB_NON_HEAP_PLOTTER_ACCESSIBLE_NAME);
        proxyClient.addWeakPropertyChangeListener(this.nonHeapPlotter);
        this.heapPlotter.createSequence(usedKey, Messages.USED, usedColor, true);
        this.heapPlotter.createSequence(committedKey, Messages.COMMITTED, committedColor, false);
        this.heapPlotter.createSequence(maxKey, Messages.MAX, maxColor, false);
        this.nonHeapPlotter.createSequence(usedKey, Messages.USED, usedColor, true);
        this.nonHeapPlotter.createSequence(committedKey, Messages.COMMITTED, committedColor, false);
        this.nonHeapPlotter.createSequence(maxKey, Messages.MAX, maxColor, false);
        this.plotterList.add(this.heapPlotter);
        this.plotterList.add(this.nonHeapPlotter);
        Map<ObjectName, MBeanInfo> mBeanMap = proxyClient.getMBeans("java.lang");
        Set<ObjectName> keys = mBeanMap.keySet();
        ObjectName[] objectNames = keys.toArray(new ObjectName[keys.size()]);
        ArrayList<PoolPlotter> nonHeapPlotters = new ArrayList<PoolPlotter>(2);
        for (ObjectName objectName : objectNames) {
            String type = objectName.getKeyProperty("type");
            if (!type.equals("MemoryPool")) continue;
            String name = Resources.format(Messages.MEMORY_POOL_LABEL, objectName.getKeyProperty("name"));
            boolean isHeap = false;
            AttributeList al = proxyClient.getAttributes(objectName, new String[]{"Type"});
            if (al.size() > 0) {
                isHeap = MemoryType.HEAP.name().equals(((Attribute)al.get(0)).getValue());
            }
            PoolPlotter poolPlotter = new PoolPlotter(objectName, name, isHeap);
            proxyClient.addWeakPropertyChangeListener(poolPlotter);
            poolPlotter.createSequence(usedKey, Messages.USED, usedColor, true);
            poolPlotter.createSequence(committedKey, Messages.COMMITTED, committedColor, false);
            poolPlotter.createSequence(maxKey, Messages.MAX, maxColor, false);
            poolPlotter.createSequence(thresholdKey, Messages.THRESHOLD, thresholdColor, false);
            poolPlotter.setUseDashedTransitions(thresholdKey, true);
            if (isHeap) {
                this.plotterList.add(poolPlotter);
                continue;
            }
            nonHeapPlotters.add(poolPlotter);
        }
        for (PoolPlotter poolPlotter : nonHeapPlotters) {
            this.plotterList.add(poolPlotter);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (ev.getStateChange() == 1) {
            Plotter plotter = (Plotter)this.plotterChoice.getSelectedItem();
            this.plotterPanel.setPlotter(plotter);
        }
    }

    public void gc() {
        new Thread("MemoryPanel.gc"){

            @Override
            public void run() {
                ProxyClient proxyClient = MemoryTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getMemoryMXBean().gc();
                }
                catch (UndeclaredThrowableException e) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Boolean, Object>(){
            private long[] used;
            private long[] committed;
            private long[] max;
            private long[] threshold;
            private long timeStamp;
            private String detailsStr;
            private boolean initialRun = false;

            @Override
            public Boolean doInBackground() {
                ProxyClient proxyClient = MemoryTab.this.vmPanel.getProxyClient();
                if (MemoryTab.this.plotterList == null) {
                    try {
                        MemoryTab.this.createPlotters();
                    }
                    catch (UndeclaredThrowableException e) {
                        proxyClient.markAsDead();
                        return false;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                    this.initialRun = true;
                }
                int n = MemoryTab.this.plotterList.size();
                this.used = new long[n];
                this.committed = new long[n];
                this.max = new long[n];
                this.threshold = new long[n];
                this.timeStamp = System.currentTimeMillis();
                for (int i = 0; i < n; ++i) {
                    Plotter plotter = MemoryTab.this.plotterList.get(i);
                    MemoryUsage mu = null;
                    this.used[i] = -1L;
                    this.threshold[i] = -1L;
                    try {
                        if (plotter instanceof PoolPlotter) {
                            PoolPlotter poolPlotter = (PoolPlotter)plotter;
                            ObjectName objectName = poolPlotter.objectName;
                            AttributeList al = proxyClient.getAttributes(objectName, new String[]{"Usage", "UsageThreshold"});
                            if (al.size() > 0) {
                                CompositeData cd = (CompositeData)((Attribute)al.get(0)).getValue();
                                mu = MemoryUsage.from(cd);
                                if (al.size() > 1) {
                                    this.threshold[i] = (Long)((Attribute)al.get(1)).getValue();
                                }
                            }
                        } else if (plotter == MemoryTab.this.heapPlotter) {
                            mu = proxyClient.getMemoryMXBean().getHeapMemoryUsage();
                        } else if (plotter == MemoryTab.this.nonHeapPlotter) {
                            mu = proxyClient.getMemoryMXBean().getNonHeapMemoryUsage();
                        }
                    }
                    catch (UndeclaredThrowableException e) {
                        proxyClient.markAsDead();
                        return false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (mu == null) continue;
                    this.used[i] = mu.getUsed();
                    this.committed[i] = mu.getCommitted();
                    this.max[i] = mu.getMax();
                }
                this.detailsStr = MemoryTab.this.formatDetails();
                return true;
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        return;
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (ExecutionException ex) {
                    if (JConsole.isDebug()) {
                        ex.printStackTrace();
                    }
                    return;
                }
                if (this.initialRun) {
                    for (Plotter p : MemoryTab.this.plotterList) {
                        MemoryTab.this.plotterChoice.addItem(p);
                        MemoryTab.this.timeComboBox.addPlotter(p);
                    }
                    MemoryTab.this.add((Component)MemoryTab.this.bottomPanel, "South");
                }
                int n = MemoryTab.this.plotterList.size();
                int poolCount = 0;
                for (int i = 0; i < n; ++i) {
                    Plotter plotter = MemoryTab.this.plotterList.get(i);
                    if (this.used[i] < 0L) continue;
                    if (plotter instanceof PoolPlotter) {
                        plotter.addValues(this.timeStamp, this.used[i], this.committed[i], this.max[i], this.threshold[i]);
                        if (this.threshold[i] > 0L) {
                            plotter.setIsPlotted(MemoryTab.thresholdKey, true);
                        }
                        MemoryTab.this.poolChart.setValue(poolCount++, (PoolPlotter)plotter, this.used[i], this.threshold[i], this.max[i]);
                    } else {
                        plotter.addValues(this.timeStamp, this.used[i], this.committed[i], this.max[i]);
                    }
                    if (plotter != MemoryTab.this.heapPlotter || MemoryTab.this.overviewPanel == null) continue;
                    MemoryTab.this.overviewPanel.getPlotter().addValues(this.timeStamp, this.used[i]);
                    MemoryTab.this.overviewPanel.updateMemoryInfo(this.used[i], this.committed[i], this.max[i]);
                }
                MemoryTab.this.details.setText(this.detailsStr);
            }
        };
    }

    private String formatDetails() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return "";
        }
        String text = "<table cellspacing=0 cellpadding=0>";
        Plotter plotter = (Plotter)this.plotterChoice.getSelectedItem();
        if (plotter == null) {
            return "";
        }
        long time = System.currentTimeMillis();
        String timeStamp = Formatter.formatDateTime(time);
        text = text + Formatter.newRow(Messages.TIME, timeStamp);
        long used = plotter.getLastValue(usedKey);
        long committed = plotter.getLastValue(committedKey);
        long max = plotter.getLastValue(maxKey);
        long threshold = plotter.getLastValue(thresholdKey);
        text = text + Formatter.newRow(Messages.USED, Formatter.formatKBytes(used));
        if (committed > 0L) {
            text = text + Formatter.newRow(Messages.COMMITTED, Formatter.formatKBytes(committed));
        }
        if (max > 0L) {
            text = text + Formatter.newRow(Messages.MAX, Formatter.formatKBytes(max));
        }
        if (threshold > 0L) {
            text = text + Formatter.newRow(Messages.USAGE_THRESHOLD, Formatter.formatKBytes(threshold));
        }
        try {
            Collection<GarbageCollectorMXBean> garbageCollectors = proxyClient.getGarbageCollectorMXBeans();
            boolean descPrinted = false;
            for (GarbageCollectorMXBean garbageCollectorMBean : garbageCollectors) {
                String gcName = garbageCollectorMBean.getName();
                long gcCount = garbageCollectorMBean.getCollectionCount();
                long gcTime = garbageCollectorMBean.getCollectionTime();
                String str = Resources.format(Messages.GC_TIME_DETAILS, Formatter.justify(Formatter.formatTime(gcTime), 14), gcName, String.format("%,d", gcCount));
                if (!descPrinted) {
                    text = text + Formatter.newRow(Messages.GC_TIME, str);
                    descPrinted = true;
                    continue;
                }
                text = text + Formatter.newRow(null, str);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.gcButton) {
            this.gc();
        }
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new MemoryOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class MemoryOverviewPanel
    extends OverviewPanel {
        MemoryOverviewPanel() {
            super(Messages.HEAP_MEMORY_USAGE, MemoryTab.usedKey, Messages.USED, Plotter.Unit.BYTES);
        }

        private void updateMemoryInfo(long used, long committed, long max) {
            this.getInfoLabel().setText(Resources.format(Messages.MEMORY_TAB_INFO_LABEL_FORMAT, Formatter.formatBytes(used, true), Formatter.formatBytes(committed, true), Formatter.formatBytes(max, true)));
        }
    }

    private class PoolChart
    extends BorderedComponent
    implements Accessible,
    MouseListener {
        final int height = 150;
        final int leftMargin = 50;
        final int rightMargin = 23;
        final int bottomMargin = 35;
        final int barWidth = 22;
        final int barGap = 3;
        final int groupGap = 8;
        final int barHeight = 100;
        final Color greenBar;
        final Color greenBarBackground;
        final Color redBarBackground;
        Font smallFont;
        ArrayList<PoolPlotter> poolPlotters;
        int nHeapPools;
        int nNonHeapPools;
        Rectangle heapRect;
        Rectangle nonHeapRect;

        public PoolChart() {
            super(null, null);
            this.height = 150;
            this.leftMargin = 50;
            this.rightMargin = 23;
            this.bottomMargin = 35;
            this.barWidth = 22;
            this.barGap = 3;
            this.groupGap = 8;
            this.barHeight = 100;
            this.greenBar = new Color(100, 255, 100);
            this.greenBarBackground = new Color(210, 255, 210);
            this.redBarBackground = new Color(255, 210, 210);
            this.smallFont = null;
            this.poolPlotters = new ArrayList(5);
            this.nHeapPools = 0;
            this.nNonHeapPools = 0;
            this.heapRect = new Rectangle(50, 121, 22, 20);
            this.nonHeapRect = new Rectangle(58, 121, 22, 20);
            this.setFocusable(true);
            this.addMouseListener(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setValue(int poolIndex, PoolPlotter poolPlotter, long value, long threshold, long max) {
            poolPlotter.value = value;
            poolPlotter.threshold = threshold;
            poolPlotter.max = max;
            if (poolIndex == this.poolPlotters.size()) {
                this.poolPlotters.add(poolPlotter);
                if (poolPlotter.isHeap) {
                    poolPlotter.barX = this.nHeapPools * 25;
                    ++this.nHeapPools;
                    this.heapRect.width = this.nHeapPools * 22 + (this.nHeapPools - 1) * 3;
                    this.nonHeapRect.x = 50 + this.heapRect.width + 8;
                } else {
                    poolPlotter.barX = this.nonHeapRect.x - 50 + this.nNonHeapPools * 25;
                    ++this.nNonHeapPools;
                    this.nonHeapRect.width = this.nNonHeapPools * 22 + (this.nNonHeapPools - 1) * 3;
                }
            } else {
                this.poolPlotters.set(poolIndex, poolPlotter);
            }
            this.repaint();
        }

        private void paintPoolBar(Graphics g, PoolPlotter poolPlotter) {
            Rectangle barRect = this.getBarRect(poolPlotter);
            g.setColor(Color.gray);
            g.drawRect(barRect.x, barRect.y, barRect.width, barRect.height);
            long value = poolPlotter.value;
            long max = poolPlotter.max;
            if (max > 0L) {
                g.translate(barRect.x, barRect.y);
                g.setColor(this.greenBarBackground);
                g.fillRect(1, 1, barRect.width - 1, barRect.height - 1);
                int greenHeight = (int)(value * (long)barRect.height / max);
                long threshold = poolPlotter.threshold;
                if (threshold > 0L) {
                    int redHeight = (int)(threshold * (long)barRect.height / max);
                    g.setColor(this.redBarBackground);
                    g.fillRect(1, 1, barRect.width - 1, barRect.height - redHeight);
                    if (value > threshold) {
                        g.setColor(thresholdColor);
                        g.fillRect(1, barRect.height - greenHeight, barRect.width - 1, greenHeight - redHeight);
                        greenHeight = redHeight;
                    }
                }
                g.setColor(this.greenBar);
                g.fillRect(1, barRect.height - greenHeight, barRect.width - 1, greenHeight);
                g.translate(-barRect.x, -barRect.y);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.poolPlotters.size() == 0) {
                return;
            }
            if (this.smallFont == null) {
                this.smallFont = g.getFont().deriveFont(9.0f);
            }
            g.setColor(this.getBackground());
            Rectangle r = g.getClipBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setFont(this.smallFont);
            FontMetrics fm = g.getFontMetrics();
            int fontDescent = fm.getDescent();
            g.setColor(this.getForeground());
            for (int pc : new int[]{0, 25, 50, 75, 100}) {
                String str = pc + "% --";
                g.drawString(str, 50 - fm.stringWidth(str) - 4, 115 - pc * 100 / 100 + fontDescent + 1);
            }
            for (PoolPlotter poolPlotter : this.poolPlotters) {
                this.paintPoolBar(g, poolPlotter);
            }
            g.setColor(Color.gray);
            g.drawRect(this.heapRect.x, this.heapRect.y, this.heapRect.width, this.heapRect.height);
            g.drawRect(this.nonHeapRect.x, this.nonHeapRect.y, this.nonHeapRect.width, this.nonHeapRect.height);
            Color heapColor = this.greenBar;
            Color nonHeapColor = this.greenBar;
            for (PoolPlotter poolPlotter : this.poolPlotters) {
                if (poolPlotter.threshold <= 0L || poolPlotter.value <= poolPlotter.threshold) continue;
                if (poolPlotter.isHeap) {
                    heapColor = thresholdColor;
                    continue;
                }
                nonHeapColor = thresholdColor;
            }
            g.setColor(heapColor);
            g.fillRect(this.heapRect.x + 1, this.heapRect.y + 1, this.heapRect.width - 1, this.heapRect.height - 1);
            g.setColor(nonHeapColor);
            g.fillRect(this.nonHeapRect.x + 1, this.nonHeapRect.y + 1, this.nonHeapRect.width - 1, this.nonHeapRect.height - 1);
            String str = Messages.HEAP;
            int stringWidth = fm.stringWidth(str);
            int x = this.heapRect.x + (this.heapRect.width - stringWidth) / 2;
            int y = this.heapRect.y + this.heapRect.height - 6;
            g.setColor(Color.white);
            g.drawString(str, x - 1, y - 1);
            g.drawString(str, x + 1, y - 1);
            g.drawString(str, x - 1, y + 1);
            g.drawString(str, x + 1, y + 1);
            g.setColor(Color.black);
            g.drawString(str, x, y);
            str = Messages.NON_HEAP;
            stringWidth = fm.stringWidth(str);
            x = this.nonHeapRect.x + (this.nonHeapRect.width - stringWidth) / 2;
            y = this.nonHeapRect.y + this.nonHeapRect.height - 6;
            g.setColor(Color.white);
            g.drawString(str, x - 1, y - 1);
            g.drawString(str, x + 1, y - 1);
            g.drawString(str, x - 1, y + 1);
            g.drawString(str, x + 1, y + 1);
            g.setColor(Color.black);
            g.drawString(str, x, y);
            g.setColor(Color.blue);
            r = null;
            Plotter plotter = (Plotter)MemoryTab.this.plotterChoice.getSelectedItem();
            if (plotter == MemoryTab.this.heapPlotter) {
                r = this.heapRect;
            } else if (plotter == MemoryTab.this.nonHeapPlotter) {
                r = this.nonHeapRect;
            } else if (plotter instanceof PoolPlotter) {
                r = this.getBarRect((PoolPlotter)plotter);
            }
            if (r != null) {
                g.drawRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
            }
        }

        private Rectangle getBarRect(PoolPlotter poolPlotter) {
            return new Rectangle(50 + poolPlotter.barX, 15, 22, 100);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.nonHeapRect.x + this.nonHeapRect.width + 23, 150);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.requestFocusInWindow();
            Plotter plotter = this.getPlotter(e);
            if (plotter != null && plotter != MemoryTab.this.plotterChoice.getSelectedItem()) {
                MemoryTab.this.plotterChoice.setSelectedItem(plotter);
                this.repaint();
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Plotter plotter = this.getPlotter(e);
            return plotter != null ? plotter.toString() : null;
        }

        private Plotter getPlotter(MouseEvent e) {
            Point p = e.getPoint();
            Plotter plotter = null;
            if (this.heapRect.contains(p)) {
                plotter = MemoryTab.this.heapPlotter;
            } else if (this.nonHeapRect.contains(p)) {
                plotter = MemoryTab.this.nonHeapPlotter;
            } else {
                for (PoolPlotter poolPlotter : this.poolPlotters) {
                    if (!this.getBarRect(poolPlotter).contains(p)) continue;
                    plotter = poolPlotter;
                    break;
                }
            }
            return plotter;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePoolChart();
            }
            return this.accessibleContext;
        }

        protected class AccessiblePoolChart
        extends JPanel.AccessibleJPanel {
            protected AccessiblePoolChart() {
                super(PoolChart.this);
            }

            @Override
            public String getAccessibleName() {
                String name = Messages.MEMORY_TAB_POOL_CHART_ACCESSIBLE_NAME;
                String keyValueList = "";
                for (PoolPlotter poolPlotter : PoolChart.this.poolPlotters) {
                    String value = poolPlotter.value * 100L / poolPlotter.max + "%";
                    keyValueList = keyValueList + Resources.format(Messages.PLOTTER_ACCESSIBLE_NAME_KEY_AND_VALUE, poolPlotter.toString(), value);
                    if (poolPlotter.threshold <= 0L) continue;
                    String threshold = poolPlotter.threshold * 100L / poolPlotter.max + "%";
                    if (poolPlotter.value > poolPlotter.threshold) {
                        keyValueList = keyValueList + Resources.format(Messages.MEMORY_TAB_POOL_CHART_ABOVE_THRESHOLD, threshold);
                        continue;
                    }
                    keyValueList = keyValueList + Resources.format(Messages.MEMORY_TAB_POOL_CHART_BELOW_THRESHOLD, threshold);
                }
                return name + "\n" + keyValueList + ".";
            }
        }
    }

    private class PoolPlotter
    extends Plotter {
        ObjectName objectName;
        String name;
        boolean isHeap;
        long value;
        long threshold;
        long max;
        int barX;

        public PoolPlotter(ObjectName objectName, String name, boolean isHeap) {
            super(Plotter.Unit.BYTES);
            this.objectName = objectName;
            this.name = name;
            this.isHeap = isHeap;
            Utilities.setAccessibleName(this, Resources.format(Messages.MEMORY_TAB_POOL_PLOTTER_ACCESSIBLE_NAME, name));
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

