/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.DefaultExternalResource;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.BuildOperationExternalResource;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalResourceRepository
implements ExternalResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceRepository.class);
    private final String name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;
    private final ExternalResourceAccessor loggingAccessor;
    private final ExternalResourceUploader loggingUploader;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultExternalResourceRepository(String name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister, ExternalResourceAccessor loggingAccessor, ExternalResourceUploader loggingUploader, BuildOperationExecutor buildOperationExecutor) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
        this.loggingAccessor = loggingAccessor;
        this.loggingUploader = loggingUploader;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public ExternalResourceRepository withProgressLogging() {
        if (this.loggingAccessor == this.accessor && this.loggingUploader == this.uploader) {
            return this;
        }
        return new DefaultExternalResourceRepository(this.name, this.loggingAccessor, this.loggingUploader, this.lister, this.loggingAccessor, this.loggingUploader, this.buildOperationExecutor);
    }

    @Override
    public ExternalResource getResource(URI source, boolean revalidate) {
        ExternalResourceReadResponse response = this.accessor.openResource(source, revalidate);
        return response == null ? null : new BuildOperationExternalResource(this.buildOperationExecutor, (ExternalResource)new DefaultExternalResource(source, response));
    }

    @Override
    public ExternalResourceMetaData getResourceMetaData(URI source, boolean revalidate) {
        return this.accessor.getMetaData(source, revalidate);
    }

    @Override
    public void put(LocalResource source, URI destination) throws IOException {
        LOGGER.debug("Attempting to put resource {}.", (Object)destination);
        this.uploader.upload(source, destination);
    }

    @Override
    public List<String> list(URI parent) {
        return this.lister.list(parent);
    }

    public String toString() {
        return this.name;
    }
}

